The displacement time-series result can be exported as a QGIS-compatible format for visualization via the **InSAR Explorer** plugin or the **PS Time Series Viewer** plugin.

### 1. QGIS with [InSAR Explorer](https://insar-explorer.readthedocs.io/) ###

The InSAR Explorer plugin supports both the GRD format and the shapefile format.

#### a. Setup ####

1. Download and install [QGIS](https://qgis.org/en/site/) if you have not done so.
2. Install the plugin:
  - Install within QGIS via "Plugins -> Manage and Install Plugins", then search for "InSAR Explorer".
  - Alternatively, download the plugin as a *.zip file from [the plugin page](https://plugins.qgis.org/plugins/insar_explorer-dev/), and install it through "Plugins -> Manage and Install Plugins -> Install from ZIP".
3. Launch the plugin: Access it from the toolbar or through "Plugins -> InSAR Explorer -> InSAR Explorer".

#### b. Usage for GRD files ####

1. Export MintPy results to GRD files using `save_explorer.py`:

```bash
save_explorer.py geo_timeseries.h5 -v geo_velocity.h5 -o geo_maskTempCoh.h5 -o timeseries/
```

2. Load data in QGIS: Open one of the exported GRD files, e.g., `geo_velocity_mm.h5`, in QGIS.
3. Launch InSAR Explorer and click on any point to plot the time series.

<p align="left">
  <img width="1000" src="https://insarlab.github.io/figs/docs/mintpy/QGIS-InSAR-Explorer-point.png">
</p>

#### c. Using shapefile ###

1. Export MintPy results to a shapefile using `save_qgis.py`:

```bash
save_qgis.py timeseries_ERA5_ramp_demErr.h5 -g inputs/geometryRadar.h5
save_qgis.py geo/geo_timeseries_ERA5_ramp_demErr.h5 -g geo/geo_geometryRadar.h5
```

2. Load data in QGIS: Browse to the *.shp file generated by `save_qgis.py` and add it to the layer. Then open "View -> Panels -> Layer Styling", and on the right choose "Fill color -> Edit" and add the command below to color-code the map based on velocity value.

```
ramp_color('RdBu', scale_linear(VEL, -20, 20, 0, 1))
```

<p align="left">
  <img width="1000" src="https://insarlab.github.io/figs/docs/mintpy/QGIS-PS-TSV-map.png">
</p>

3. Launch InSAR Explorer and click on any point to plot the time series.

<p align="left">
  <img width="1000" src="https://insarlab.github.io/figs/docs/mintpy/QGIS-InSAR-Explorer-point.png">
</p>

### d. More information ###

For more details on using the plugin, please refer to the [InSAR Explorer documentation](https://insar-explorer.readthedocs.io/).

### 2. QGIS with [PS Time Series Viewer](https://plugins.qgis.org/plugins/pstimeseries/)

The PS Time Series Viewer plugin supports the shapefile format only.

#### a. Setup

1. Download and install [QGIS](https://qgis.org/en/site/) if you have not done so.
2. Install the plugin:
  - Install within QGIS via "Plugins -> Manage and Install Plugins", then search "PS Time Series Viewer".
  - Alternatively, download the plugin as a *.zip file from [the plugin page](https://plugins.qgis.org/plugins/pstimeseries/), and install it through “Plugins -> Manage and Install Plugins -> Install from ZIP”.

#### b. Usage

1. Export MintPy results to shapefiles using `save_qgis.py`:

```bash
save_qgis.py timeseries_ERA5_ramp_demErr.h5 -g inputs/geometryRadar.h5
save_qgis.py geo/geo_timeseries_ERA5_ramp_demErr.h5 -g geo/geo_geometryRadar.h5
```

2. Load data in QGIS: Browse to the *.shp file generated by `save_qgis.py` and add it to the layer. Then open "View -> Panels -> Layer Styling", and on the right choose "Fill color -> Edit" and add the command below to color-code the map based on velocity value.

```
ramp_color('RdBu', scale_linear(VEL, -20, 20, 0, 1))
```

<p align="left">
  <img width="1000" src="https://insarlab.github.io/figs/docs/mintpy/QGIS-PS-TSV-map.png">
</p>

3. Launch PS Time Series Viewer: Access it from the toolbar or through “Plugins -> Permanent Scatterers -> PS Time Series Viewer”.

<p align="left">
  <img width="800" src="https://insarlab.github.io/figs/docs/mintpy/QGIS-PS-TSV-point.png">
</p>
