/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef BLADERUNNER_GAME_CONSTANTS_H
#define BLADERUNNER_GAME_CONSTANTS_H

namespace BladeRunner {

enum Actors {
	kActorMcCoy = 0,
	kActorSteele = 1,
	kActorGordo = 2,
	kActorDektora = 3,
	kActorGuzza = 4,
	kActorClovis = 5,
	kActorLucy = 6,
	kActorIzo = 7,
	kActorSadik = 8,
	kActorCrazylegs = 9,
	kActorLuther = 10,
	kActorGrigorian = 11,
	kActorTransient = 12,
	kActorLance = 13,
	kActorBulletBob = 14,
	kActorRunciter = 15,
	kActorInsectDealer = 16,
	kActorTyrellGuard = 17,
	kActorEarlyQ = 18,
	kActorZuben = 19,
	kActorHasan = 20,
	kActorMarcus = 21,
	kActorMia = 22,
	kActorOfficerLeary = 23,
	kActorOfficerGrayford = 24,
	kActorHanoi = 25,
	kActorBaker = 26,
	kActorDeskClerk = 27,
	kActorHowieLee = 28,
	kActorFishDealer = 29,
	kActorKlein = 30,
	kActorMurray = 31,
	kActorHawkersBarkeep = 32,
	kActorHolloway = 33,
	kActorSergeantWalls = 34,
	kActorMoraji = 35,
	kActorTheBard = 36,
	kActorPhotographer = 37,
	kActorDispatcher = 38,
	kActorAnsweringMachine = 39,
	kActorRajif = 40,
	kActorGovernorKolvig = 41,
	kActorEarlyQBartender = 42,
	kActorHawkersParrot = 43,
	kActorTaffyPatron = 44,
	kActorLockupGuard = 45,
	kActorTeenager = 46,
	kActorHysteriaPatron1 = 47,
	kActorHysteriaPatron2 = 48,
	kActorHysteriaPatron3 = 49,
	kActorShoeshineMan = 50,
	kActorTyrell = 51,
	kActorChew = 52,
	kActorGaff = 53,
	kActorBryant = 54,
	kActorTaffy = 55,
	kActorSebastian = 56,
	kActorRachael = 57,
	kActorGeneralDoll = 58,
	kActorIsabella = 59,
	kActorBlimpGuy = 60,
	kActorNewscaster = 61,
	kActorLeon = 62,
	kActorMaleAnnouncer = 63,
	kActorFreeSlotA = 64,
	kActorFreeSlotB = 65,
	kActorMaggie = 66,
	kActorGenwalkerA = 67,
	kActorGenwalkerB = 68,
	kActorGenwalkerC = 69,
	kActorMutant1 = 70,
	kActorMutant2 = 71,
	kActorMutant3 = 72,
	kActorVoiceOver = 99
};

enum Clues {
	kClueOfficersStatement = 0,
	kClueDoorForced1 = 1,
	kClueDoorForced2 = 2,
	kClueLimpingFootprints = 3,
	kClueGracefulFootprints = 4,
	kClueShellCasings = 5,
	kClueCandy = 6,
	kClueToyDog = 7,
	kClueChopstickWrapper = 8,
	kClueSushiMenu = 9,
	kClueLabCorpses = 10,
	kClueLabShellCasings = 11,
	kClueRuncitersVideo = 12,
	kClueLucy = 13,
	kClueDragonflyAnklet = 14,
	kClueReferenceLetter = 15,
	kClueCrowdInterviewA = 16,
	kClueCrowdInterviewB = 17,
	kClueZubenRunsAway = 18,
	kClueZubenInterview = 19,
	kClueZuben = 20,
	kClueBigManLimping = 21,
	kClueRunciterInterviewA = 22,
	kClueRunciterInterviewB1 = 23,
	kClueRunciterInterviewB2 = 24,
	kClueHowieLeeInterview = 25,
	kCluePaintTransfer = 26,
	kClueChromeDebris = 27,
	kClueRuncitersViewA = 28,
	kClueRuncitersViewB = 29,
	kClueCarColorAndMake = 30,
	kCluePartialLicenseNumber = 31,
	kClueBriefcase = 32,
	kClueGaffsInformation = 33,
	kClueCrystalVisitedRunciters = 34,
	kClueCrystalVisitedChinatown = 35,
	kClueWantedPoster = 36,
	kClueLicensePlate = 37,
	kClueLicensePlateMatch = 38,
	kClueLabPaintTransfer = 39,
	kClueDispatchHitAndRun = 40,
	kClueInceptShotRoy = 41,
	kClueInceptShotsLeon = 42,
	kCluePhoneCallGuzza = 43,
	kClueDragonflyEarring = 44,
	kClueTyrellSecurity = 45,
	kClueTyrellGuardInterview = 46,
	kClueBombingSuspect = 47,
	kClueSadiksGun = 48,
	kClueDetonatorWire = 49,
	kClueVictimInformation = 50,
	kClueAttemptedFileAccess = 51,
	kClueCrystalsCase = 52,
	kClueKingstonKitchenBox1 = 53,
	kClueTyrellSalesPamphlet1 = 54,
	kClueTyrellSalesPamphlet2 = 55,
	kCluePeruvianLadyInterview = 56,
	kClueHasanInterview = 57,
	kClueBobInterview1 = 58,
	kClueBobInterview2 = 59,
	kClueIzoInterview = 60,
	kClueIzosWarning = 61,
	kClueRadiationGoggles = 62,
	kClueGogglesReplicantIssue = 63,
	kClueFishLadyInterview = 64,
	kClueDogCollar1 = 65,
	kClueWeaponsCache = 66,
	kClueChewInterview = 67,
	kClueMorajiInterview = 68,
	kClueGordoInterview1 = 69,
	kClueGordoInterview2 = 70,
	kClueAnsweringMachineMessage = 71,
	kClueChessTable = 72,
	kClueSightingSadikBradbury = 73,
	kClueStaggeredbyPunches = 74,
	kClueMaggieBracelet = 75,
	kClueEnvelope = 76,
	kClueIzosFriend = 77,
	kClueChinaBarSecurityPhoto = 78,
	kCluePurchasedScorpions = 79,
	kClueWeaponsOrderForm = 80,
	kClueShippingForm = 81,
	kClueGuzzasCash = 82,
	kCluePoliceIssueWeapons = 83,
	kClueHysteriaToken = 84,
	kClueRagDoll = 85,
	kClueMoonbus1 = 86,
	kClueCheese = 87,
	kClueDektorasDressingRoom = 88,
	kClueEarlyQsClub = 89,
	kClueDragonflyCollection = 90,
	kClueDragonflyBelt = 91,
	kClueEarlyQInterview = 92,
	kClueStrangeScale1 = 93,
	kClueDektoraInterview1 = 94,
	kClueSuspectDektora = 95,
	kClueDektoraInterview2 = 96,
	kClueDektoraInterview3 = 97,
	kClueDektorasCard = 98,
	kClueGrigoriansNote = 99,
	kClueCollectionReceipt = 100,
	kClueSpecialIngredient = 101,
	kClueStolenCheese = 102,
	kClueGordoInterview3 = 103,
	kClueGordoConfession = 104,
	kClueGordosLighter1 = 105,
	kClueGordosLighter2 = 106,
	kClueDektoraInterview4 = 107,
	kClueHollowayInterview = 108,
	kClueBakersBadge = 109,
	kClueHoldensBadge = 110,
	kClueCar = 111,
	kClueCarIdentified = 112,
	kClueCarRegistration1 = 113,
	kClueCarRegistration2 = 114,
	kClueCarRegistration3 = 115,
	kClueCrazylegsInterview1 = 116,
	kClueCrazylegsInterview2 = 117,
	kClueLichenDogWrapper = 118,
	kClueRequisitionForm = 119,
	kClueScaryChair = 120,
	kClueIzosStashRaided = 121,
	kClueHomelessManInterview1 = 122,
	kClueHomelessManInterview2 = 123,
	kClueHomelessManKid = 124,
	kClueFolder = 125,
	kClueGuzzaFramedMcCoy = 126,
	kClueOriginalShippingForm = 127,
	kClueOriginalRequisitionForm = 128,
	kClueCandyWrapper = 129,
	kClueGordoBlabs = 130,
	kClueFlaskOfAbsinthe = 131,
	kClueGuzzaAgreesToMeet = 132,
	kClueDektoraConfession = 133,
	kClueRunciterConfession1 = 134,
	kClueRunciterConfession2 = 135,
	kClueLutherLanceInterview = 136,
	kClueMoonbus2 = 137,
	kClueMoonbusCloseup = 138,
	kCluePhoneCallDektora1 = 139,
	kCluePhoneCallDektora2 = 140,
	kCluePhoneCallLucy1 = 141,
	kCluePhoneCallLucy2 = 142,
	kCluePhoneCallClovis = 143,
	kCluePhoneCallCrystal = 144,
	kCluePowerSource = 145,
	kClueBomb = 146,
	kClueDNATyrell = 147,
	kClueDNASebastian = 148,
	kClueDNAChew = 149,
	kClueDNAMoraji = 150,
	kClueDNALutherLance = 151,
	kClueDNAMarcus = 152,
	kClueGarterSnake = 153,
	kClueSlug = 154,
	kClueGoldfish = 155,
	kClueZubenTalksAboutLucy1 = 156,
	kClueZubenTalksAboutLucy2 = 157,
	kClueZubensMotive = 158,
	kClueSightingBulletBob = 159,
	kClueSightingClovis = 160,
	kClueSightingDektora = 161,
	kClueVKDektoraReplicant = 162,
	kClueVKDektoraHuman = 163,
	kClueVKBobGorskyReplicant = 164,
	kClueVKBobGorskyHuman = 165,
	kClueVKLutherLanceReplicant = 166,
	kClueVKLutherLanceHuman = 167,
	kClueVKGrigorianReplicant = 168,
	kClueVKGrigorianHuman = 169,
	kClueVKIzoReplicant = 170,
	kClueVKIzoHuman = 171,
	kClueVKCrazylegsReplicant = 172,
	kClueVKCrazylegsHuman = 173,
	kClueVKRunciterReplicant = 174,
	kClueVKRunciterHuman = 175,
	kClueVKEarlyQReplicant = 176,
	kClueVKEarlyQHuman = 177,
	kClueCrimeSceneNotes = 178,
	kClueGrigorianInterviewA = 179,
	kClueGrigorianInterviewB1 = 180,
	kClueGrigorianInterviewB2 = 181,
	kClueLabAnalysisGoldChain = 182,
	kClueSightingZuben = 183,
	kClueCrystalRetiredZuben = 184,
	kClueCrystalRetiredGordo = 185,
	kClueSightingGordo = 186,
	kClueCrystalRetiredIzo = 187,
	kClueClovisIncept = 188,
	kClueDektoraIncept = 189,
	kClueLucyIncept = 190,
	kClueGordoIncept = 191,
	kClueIzoIncept = 192,
	kClueSadikIncept = 193,
	kClueZubenIncept = 194,
	kClueMcCoyIncept = 195,
	kClueWarRecordsGordoFrizz = 196,
	kCluePoliceWeaponUsed = 197,
	kClueMcCoysWeaponUsedonBob = 198,
	kClueBobRobbed = 199,
	kClueBobShotInSelfDefense = 200,
	kClueBobShotInColdBlood = 201,
	kClueMcCoyRecoveredHoldensBadge = 202,
	kClueCrystalTestedBulletBob = 203,
	kClueCrystalRetiredBob = 204,
	kClueCrystalTestedCrazylegs = 205,
	kClueCrystalRetiredCrazylegs = 206,
	kClueCrystalArrestedCrazylegs = 207,
	kClueCrystalTestedRunciter = 208,
	kClueCrystalRetiredRunciter1 = 209,
	kClueCrystalRetiredRunciter2 = 210,
	kClueSightingMcCoyRuncitersShop = 211,
	kClueMcCoyKilledRunciter1 = 212,
	kClueMcCoysDescription = 213,
	kClueMcCoyIsABladeRunner = 214,
	kClueMcCoyLetZubenEscape = 215,
	kClueMcCoyWarnedIzo = 216,
	kClueMcCoyHelpedIzoIzoIsAReplicant = 217,
	kClueMcCoyHelpedDektora = 218,
	kClueMcCoyHelpedLucy = 219,
	kClueMcCoyHelpedGordo = 220,
	kClueMcCoyShotGuzza = 221,
	kClueMcCoyRetiredZuben = 222,
	kClueMcCoyRetiredLucy = 223,
	kClueMcCoyRetiredDektora = 224,
	kClueMcCoyRetiredGordo = 225,
	kClueMcCoyRetiredSadik = 226,
	kClueMcCoyShotZubenInTheBack = 227,
	kClueMcCoyRetiredLutherLance = 228,
	kClueMcCoyBetrayal = 229,
	kClueMcCoyKilledRunciter2 = 230,
	kClueClovisOrdersMcCoysDeath = 231,
	kClueEarlyAttemptedToSeduceLucy = 232,
	kClueCarWasStolen = 233,
	kClueGrigoriansResponse1 = 234,
	kClueGrigoriansResponse2 = 235,
	kClueCrazysInvolvement = 236,
	kClueGrigoriansResources = 237,
	kClueMcCoyPulledAGun = 238,
	kClueMcCoyIsStupid = 239,
	kClueMcCoyIsAnnoying = 240,
	kClueMcCoyIsKind = 241,
	kClueMcCoyIsInsane = 242,
	kClueAnimalMurderSuspect = 243,
	kClueMilitaryBoots = 244,
	kClueOuterDressingRoom = 245,
	kCluePhotoOfMcCoy1 = 246,
	kCluePhotoOfMcCoy2 = 247,
	kClueEarlyQAndLucy = 248,
	kClueClovisflowers = 249,
	kClueLucyWithDektora = 250,
	kClueWomanInAnimoidRow = 251,
	kClueScorpions = 252,
	kClueStrangeScale2 = 253,
	kClueChinaBarSecurityCamera = 254,
	kClueIzo = 255,
	kClueGuzza = 256,
	kClueChinaBarSecurityDisc = 257,
	kClueScorpionbox = 258,
	kClueTyrellSecurityPhoto = 259,
	kClueChinaBar = 260,
	kCluePlasticExplosive = 261,
	kClueDogCollar2 = 262,
	kClueKingstonKitchenBox2 = 263,
	kClueCrystalsCigarette = 264,
	kClueSpinnerKeys = 265,
	kClueAct2Ended = 266,
	kClueAct3Ended = 267,
	kClueAct4Ended = 268,
	kClueExpertBomber = 269,
	kClueAmateurBomber = 270,
	kClueVKLucyReplicant = 271,
	kClueVKLucyHuman = 272,
	kClueLucyInterview = 273,
	kClueMoonbusReflection = 274,
	kClueMcCoyAtMoonbus = 275,
	kClueClovisAtMoonbus = 276,
	kClueSadikAtMoonbus = 277,
	kClueRachaelInterview = 278,
	kClueTyrellInterview = 279,
	kClueRuncitersConfession1 = 280,
	kClueRuncitersConfession2 = 281,
	kClueRuncitersConfession3 = 282,
	kClueEarlyInterviewA = 283,
	kClueEarlyInterviewB1 = 284,
	kClueEarlyInterviewB2 = 285,
	kClueCrazylegsInterview3 = 286,
	kClueCrazylegGgrovels = 287
};

enum ClueTypes {
	kClueTypeIntangible = -1,
	kClueTypePhotograph = 0,
	kClueTypeVideoClip = 1,
	kClueTypeAudioRecording = 2,
	kClueTypeObject = 3
};

enum Suspects {
	kSuspectSadik = 0,
	kSuspectClovis = 1,
	kSuspectZuben = 2,
	kSuspectLucy = 3,
	kSuspectDekora = 4,
	kSuspectGordo = 5,
	kSuspectIzo = 6,
	kSuspectMcCoy = 7,
	kSuspectGuzza = 8
};

enum Crimes {
	kCrimeAnimalMurder = 0,
	kCrimeEisendullerMurder = 1,
	kCrimeArmsDealing = 2,
	kCrimeMorajiMurder = 3,
	kCrimeBradburyAssault = 4,
	kCrimeFactoryBombing = 5,
	kCrimeBobMurder = 6,
	kCrimeRunciterMurder = 7,
	kCrimeMoonbusHijacking = 8
};

enum SpinnerDestinations {
	kSpinnerDestinationPoliceStation = 0,
	kSpinnerDestinationMcCoysApartment = 1,
	kSpinnerDestinationRuncitersAnimals = 2,
	kSpinnerDestinationChinatown = 3,
	kSpinnerDestinationAnimoidRow = 4,
	kSpinnerDestinationTyrellBuilding = 5,
	kSpinnerDestinationDNARow = 6,
	kSpinnerDestinationBradburyBuilding = 7,
	kSpinnerDestinationNightclubRow = 8,
	kSpinnerDestinationHysteriaHall = 9
};

enum Flags {
	kFlagRC02Discovered = 1,
	kFlagGotOfficersStatement = 3,
	kFlagRC02FirstLeave = 4,
	kFlagRC01toRC02 = 8,
	kFlagRC02toRC01 = 9,
	kFlagKleinTalkShellCasings = 12,
	kFlagKleinTalkOfficersStatement = 13,
	kFlagPS13toPS12 = 19,
	kFlagPS13toPS05 = 21,
	kFlagPS02toPS05 = 22,
	kFlagPS06toPS05 = 23,
	kFlagIntroPlayed = 24,
	kFlagMA02toMA06 = 33,
	kFlagMA06ToMA02 = 34,
	kFlagMA02ToMA04 = 35,
	kFlagMA04ToMA02 = 36,
	kFlagMA01toMA06 = 37,
	kFlagMA06toMA01 = 38,
	kFlagZubenRetired = 40,
	kFlagZubenSpared = 41,
	kFlagIzoIsReplicant = 44,
	kFlagGordoIsReplicant = 45,
	kFlagLucyIsReplicant = 46,
	kFlagDektoraIsReplicant = 47,
	kFlagSadikIsReplicant = 48,
	kFlagMA07toMA06 = 57,
	kFlagMA06toMA07 = 58,
	kFlagChapter1Ended = 61,
	kFlagMA04toMA05 = 62,
	kFlagMA05toMA04 = 63,
	kFlagCT05toCT12 = 76,
	kFlagWarehouseOpen = 94,
	kFlagKleinTalkPaintTransfer = 104,
	kFlagKleinTalkChromeDebris = 105,
	kFlagKleinTalkClues = 111,
	kFlagRC03toRC01 = 114,
	kFlagRC01toRC03 = 115,
	kFlagCT01toCT12 = 123,
	kFlagPlayerHasShellCasings = 125,
	kFlagPlayerHasOfficersStatement = 126,
	kFlagPlayerHasPaintTransfer = 127,
	kFlagPlayerHasChromeDebris = 128,
	kFlagPS02toPS01 = 130,
	kFlagPS02toPS07 = 131,
	kFlagPS02toPS03 = 132,
	kFlagPS02toPS09 = 133,
	kFlagPS05toPS06 = 136,
	kFlagKleinInsulted = 138,
	kFlagRC02LucyDeskAvailable = 141,
	kFlagChapter1Ending = 146,
	kFlagChopstickWrapperTaken = 147,
	kFlagCandyTaken = 148,
	kFlagDogTaken = 149,
	kFlagKleinInsultedTalk = 156,
	kFlagGuzzaTalkZubenRetired = 159,
	kFlagGuzzaTalkZubenEscaped = 160,
	kFlagChromeDebrisTaken = 163,
	kFlagRC01PoliceDone = 186,
	kFlagShellCasingsTaken = 190,
	kFlagBoughtHowieLeeFood = 192,
	kFlagPS15toPS05 = 204,
	kFlagSpinnerToCT01 = 248,
	kFlagSpinnerToRC01 = 249,
	kFlagSpinnerToMA01 = 250,
	kFlagSpinnerToPS01 = 251,
	kFlagSpinnerToAR01 = 252,
	kFlagSpinnerToDR01 = 253,
	kFlagSpinnerToBB01 = 254,
	kFlagSpinnerToNR01 = 255,
	kFlagSpinnerToHF01 = 256,
	kFlagGaffSpinnerCT12 = 294,
	kFlagSpinnerToTB02 = 307,
	kFlagDirectorsCut = 378,
	KFlagMcCoyAndOfficerLearyTalking = 392,
	KFlagMcCoyAndOfficerLearyArtMetaphor = 397,
	kFlagGenericWalkerWaiting = 443,
	kFlagMaggieIsHurt = 461,
	kFlagKIAPrivacyAddon = 487,
	kFlagKIAPrivacyAddonIntro = 599,
	kFlagMcCoySleeping = 647,
	kFlagPhoneMessageFromClovis = 649,
	kFlagPhoneMessageFromLucy = 650,
	kFlagChapter2Intro = 678,
	kFlagPS05TV0 = 688,
	kFlagPS05TV1 = 689,
	kFlagPS05TV2 = 690,
	kFlagPS05TV3 = 691,
	kFlagPS05TV4 = 692,
	kFlagRC51Discovered = 709,
	kFlagMA04WatchedTV = 711,
	kFlagZubenBountyPaid = 723
};

enum Variables {
	kVariableChapter = 1,
	kVariableChinyen = 2,
	kVariablePoliceMazeScore = 9,
	kVariablePoliceMazePS10TargetCounter = 10,
	kVariableGenericWalkerAModel = 32,
	kVariableGenericWalkerBModel = 33,
	kVariableGenericWalkerCModel = 34,
	kVariableWalkLoopActor = 37,
	kVariableWalkLoopRun = 38,
	kVariableAffectionTowards = 45, // 0 none, 1 steele, 2 dektora, 3 lucy
	kVariableDNAEvidences = 48,
	kVariableNextTvNews = 52
};

enum Outtakes {
	kOuttakeIntro = 0,
	kOuttakeMovieA = 1,
	kOuttakeMovieB1 = 2,
	kOuttakeMovieB2 = 3,
	kOuttakeMovieB3 = 4,
	kOuttakeMovieB4 = 5,
	kOuttakeMovieB5 = 6,
	kOuttakeMovieC1 = 7,
	kOuttakeMovieC2 = 8,
	kOuttakeMovieC3 = 9,
	kOuttakeMovieD = 10,
	kOuttakeInterrogation = 11,
	kOuttakeEnd1A = 12,
	kOuttakeEnd1B = 13,
	kOuttakeEnd1C = 14,
	kOuttakeEnd1D = 15,
	kOuttakeEnd1E = 16,
	kOuttakeEnd1F = 17,
	kOuttakeEnd2 = 18,
	kOuttakeEnd3 = 19,
	kOuttakeEnd4A = 20,
	kOuttakeEnd4B = 21,
	kOuttakeEnd4C = 22,
	kOuttakeEnd4D = 23,
	kOuttakeEnd5 = 24,
	kOuttakeEnd6 = 25,
	kOuttakeEnd7 = 26,
	kOuttakeTyrellBuildingFly = 27,
	kOuttakeWestwood = 28,
	kOuttakeFlyThrough = 29,
	kOuttakeAway1 = 30,
	kOuttakeAway2 = 31,
	kOuttakeAscent = 32,
	kOuttakeDescent = 33,
	kOuttakeInside1 = 34,
	kOuttakeInside2 = 35,
	kOuttakeTowards1 = 36,
	kOuttakeTowards2 = 37,
	kOuttakeTowards3 = 38,
	kOuttakeRachel = 39,
	kOuttakeDektora = 40,
	kOuttakeBladeRunner = 41
};

enum AnimationModes {
	kAnimationModeIdle = 0,
	kAnimationModeWalk = 1,
	kAnimationModeRun = 2,
	kAnimationModeTalk = 3,
	kAnimationModeCombatIdle = 4,
	kAnimationModeCombatAim = 5,
	kAnimationModeCombatAttack = 6,
	kAnimationModeCombatWalk = 7,
	kAnimationModeCombatRun = 8,
	kAnimationModeHit = 21,
	kAnimationModeCombatHit = 22,
	kAnimationModeWalkUp = 44,
	kAnimationModeWalkDown = 45,
	kAnimationModeCombatWalkUp = 46,
	kAnimationModeCombatWalkDown = 47,
	kAnimationModeDie = 48,
	kAnimationModeCombatDie = 49,
	kAnimationModeFeeding = 52,
	kAnimationModeSit = 53, // TODO: check
	kAnimationModeClimbUp = 64,
	kAnimationModeClimbDown = 65,
	kAnimationModeCombatClimbUp = 66,
	kAnimationModeCombatClimbDown = 67
};

enum SceneLoopMode {
	kSceneLoopModeNone = -1,
	kSceneLoopModeLoseControl = 0,
	kSceneLoopModeChangeSet = 1,
	kSceneLoopModeOnce = 2,
	kSceneLoopModeSpinner = 3
};

enum Scenes {
	kSceneAR01 = 0,
	kSceneAR02 = 1,
	kSceneBB01 = 2,
	kSceneBB02 = 3,
	kSceneBB03 = 4,
	kSceneBB04 = 5,
	kSceneBB05 = 6,
	kSceneBB06 = 7,
	kSceneBB07 = 8,
	kSceneBB08 = 9,
	kSceneBB09 = 10,
	kSceneBB10 = 11,
	kSceneBB11 = 12,
	kSceneCT01 = 13, // Chinatown - Howie Lee Restaurant
	kSceneCT02 = 14, // Chinatown - Kitchen
	kSceneCT03 = 15, // Chinatown - Back Alley
	kSceneCT04 = 16, // Chinatown - Dumpster
	kSceneCT05 = 17, // Chinatown - Warehouse
	kSceneCT06 = 18, // Chinatown - Passage
	kSceneCT07 = 19,
	kSceneCT08 = 20, // Chinatown - Yukon Hotel - Backroom
	kSceneCT09 = 21, // Chinatown - Yukon Hotel - Lobby
	kSceneCT10 = 22, // Chinatown - Yukon Hotel - Room
	kSceneCT11 = 23, // Chinatown - Yukon Hotel - Outside
	kSceneCT12 = 24, // Chinatown - Warehouse - Outside
	kSceneDR01 = 25,
	kSceneDR02 = 26,
	kSceneDR03 = 27,
	kSceneDR04 = 28,
	kSceneDR05 = 29,
	kSceneDR06 = 30,
	kSceneHC01 = 31,
	kSceneHC02 = 32,
	kSceneHC03 = 33,
	kSceneHF01 = 34,
	kSceneHF02 = 35,
	kSceneHF03 = 36,
	kSceneHF04 = 37,
	kSceneHF05 = 38,
	kSceneHF06 = 39,
	kSceneHF07 = 40,
	kSceneKP01 = 41,
	kSceneKP02 = 42,
	kSceneKP03 = 43,
	kSceneKP04 = 44,
	kSceneKP05 = 45,
	kSceneKP06 = 46,
	kSceneKP07 = 47,
	kSceneMA01 = 48, // McCoy's Apartment - Roof
	kSceneMA02 = 49, // McCoy's Apartment - Living room
	kSceneMA04 = 50, // McCoy's Apartment - Sleeping room
	kSceneMA05 = 51, // McCoy's Apartment - Balcony
	kSceneMA06 = 52, // McCoy's Apartment - Elevator
	kSceneMA07 = 53, // McCoy's Apartment - Ground floor
	kSceneNR01 = 54,
	kSceneNR02 = 55,
	kSceneNR03 = 56,
	kSceneNR04 = 57,
	kSceneNR05 = 58,
	kSceneNR06 = 59,
	kSceneNR07 = 60,
	kSceneNR08 = 61,
	kSceneNR09 = 62,
	kSceneNR10 = 63,
	kSceneNR11 = 64,
	kScenePS01 = 65, // Police Station - Roof
	kScenePS02 = 66, // Police Station - Elevator
	kScenePS03 = 67, // Police Station - Ground floor
	kScenePS04 = 68, // Police Station - Guzza's Office
	kScenePS05 = 69,
	kScenePS06 = 70,
	kScenePS07 = 71,
	kScenePS09 = 72, // Police Station - Lockup
	kScenePS10 = 73,
	kScenePS11 = 74,
	kScenePS12 = 75,
	kScenePS13 = 76,
	kScenePS14 = 77,
	kSceneRC01 = 78, // Runciter - Outside
	kSceneRC02 = 79, // Runciter - Inside
	kSceneRC03 = 80,
	kSceneRC04 = 81,
	kSceneTB02 = 82,
	kSceneTB03 = 83,
	kSceneTB05 = 84,
	kSceneTB06 = 85,
	kSceneUG01 = 86,
	kSceneUG02 = 87,
	kSceneUG03 = 88,
	kSceneUG04 = 89,
	kSceneUG05 = 90,
	kSceneUG06 = 91,
	kSceneUG07 = 92,
	kSceneUG08 = 93,
	kSceneUG09 = 94,
	kSceneUG10 = 95,
	kSceneUG12 = 96,
	kSceneUG13 = 97,
	kSceneUG14 = 98,
	kSceneUG15 = 99,
	kSceneUG16 = 100,
	kSceneUG17 = 101,
	kSceneUG18 = 102,
	kSceneUG19 = 103,
	kSceneBB51 = 104,
	kSceneCT51 = 105,
	kSceneHC04 = 106,
	kSceneRC51 = 107, // Runciter - Lucy's desk
	kSceneTB07 = 108,
	kScenePS15 = 119,
	kSceneBB12 = 120
};

enum Sets {
	kSetAR01_AR02 = 0,
	kSetBB02_BB04_BB06_BB51 = 1,
	kSetBB06_BB07 = 2, //BB06
	kSetBB07 = 3,
	kSetCT01_CT12 = 4,
	kSetCT03_CT04 = 5,
	kSetCT08_CT51_UG12 = 6, //UG12
	kSetDR01_DR02_DR04 = 7,
	kSetHC01_HC02_HC03_HC04 = 8,
	kSetKP05_KP06 = 9,
	kSetMA02_MA04 = 10, //MA04
	kSetNR02 = 11,
	kSetNR04 = 12,
	kSetNR05_NR08 = 13,
	kSetPS10_PS11_PS12_PS13 = 14,
	kSetPS05 = 15,
	kSetRC02_RC51 = 16,
	kSetTB02_TB03 = 17,
	kSetTB07 = 18,
	kSetUG16 = 19,
	kSetBB01 = 20,
	kSetBB03 = 21,
	kSetBB05 = 22,
	kSetBB08 = 23,
	kSetBB09 = 24,
	kSetBB10 = 25,
	kSetBB11 = 26,
	kSetCT02 = 27,
	kSetCT05 = 28,
	kSetCT06 = 29,
	kSetCT07 = 30,
	kSetCT09 = 31,
	kSetCT10 = 32,
	kSetCT11 = 33,
	kSetDR03 = 34,
	kSetDR05 = 35,
	kSetDR06 = 36,
	kSetHF01 = 37,
	kSetHF02 = 38,
	kSetHF03 = 39,
	kSetHF04 = 40,
	kSetHF05 = 41,
	kSetHF06 = 42,
	kSetHF07 = 43,
	kSetKP01 = 44,
	kSetKP02 = 45,
	kSetKP03 = 46,
	kSetKP04 = 47,
	kSetKP07 = 48,
	kSetMA01 = 49,
	kSetMA04 = 50,
	kSetMA05 = 51,
	kSetMA06 = 52,
	kSetMA07 = 53,
	kSetNR01 = 54,
	kSetNR03 = 55,
	kSetNR06 = 56,
	kSetNR07 = 57,
	kSetNR09 = 58,
	kSetNR10 = 59,
	kSetNR11 = 60,
	kSetPS01 = 61,
	kSetPS02 = 62,
	kSetPS03 = 63,
	kSetPS04 = 64,
	kSetPS06 = 65,
	kSetPS07 = 66,
	kSetPS09 = 67,
	kSetPS14 = 68,
	kSetRC01 = 69,
	kSetRC03 = 70,
	kSetRC04 = 71,
	kSetTB05 = 72,
	kSetTB06 = 73,
	kSetUG01 = 74,
	kSetUG02 = 75,
	kSetUG03 = 76,
	kSetUG04 = 77,
	kSetUG05 = 78,
	kSetUG06 = 79,
	kSetUG07 = 80,
	kSetUG08 = 81,
	kSetUG09 = 82,
	kSetUG10 = 83,
	kSetUG12 = 84,
	kSetUG13 = 85,
	kSetUG14 = 86,
	kSetUG15 = 87,
	kSetUG17 = 88,
	kSetUG18 = 89,
	kSetUG19 = 90,
	kSetFreeSlotA = 91,
	kSetFreeSlotB = 92,
	kSetFreeSlotC = 93,
	kSetFreeSlotD = 94,
	kSetFreeSlotE = 95,
	kSetFreeSlotF = 96,
	kSetFreeSlotG = 97,
	kSetFreeSlotH = 98,
	kSetFreeSlotI = 99,
	kSetFreeSlotJ = 100,
	kSetPS15 = 101,
	kSetBB12 = 102
};

enum GameItems {
	kItemPoliceMazeTarget1 = 0,
	kItemPoliceMazeTarget2 = 1,
	kItemPoliceMazeTarget3 = 2,
	kItemPoliceMazeTarget4 = 3,
	kItemPoliceMazeTarget5 = 4,
	kItemPoliceMazeTarget6 = 5,
	kItemPoliceMazeTarget7 = 6,
	kItemPoliceMazeTarget8 = 7,
	kItemPoliceMazeTarget9 = 8,
	kItemChromeDebris = 66,
	kItemCandy = 79,
	kItemChopstickWrapper = 82,
	kItemToyDog = 98,
	kItemShellCasingA = 100,
	kItemShellCasingB = 101,
	kItemShellCasingC = 102
};

enum Elevators {
	kElevatorMA = 1,
	kElevatorPS = 2
};

// enum SceneObjectOffset {
// 	kSceneObjectActorIdStart  = 0,
// 	kSceneObjectActorIdEnd    = kSceneObjectActorIdStart  +  73,
// 	kSceneObjectItemIdStart   = kSceneObjectActorIdEnd    +   1,
// 	kSceneObjectItemIdEnd     = kSceneObjectItemIdStart   + 123,
// 	kSceneObjectObjectIdStart = kSceneObjectItemIdEnd     +   1,
// 	kSceneObjectObjectIdEnd   = kSceneObjectObjectIdStart +  95
// };

enum SceneObjectOffset {
	kSceneObjectOffsetActors  = 0,
	kSceneObjectOffsetItems   = 74,
	kSceneObjectOffsetObjects = 198
};

enum ActorCombatStates {
	kActorCombatStateIdle = 0,
	kActorCombatStateCover = 1,
	kActorCombatStateApproachCloseAttack = 2,
	kActorCombatStateUncover = 3,
	kActorCombatStateAim = 4,
	kActorCombatStateRangedAttack = 5,
	kActorCombatStateCloseAttack = 6,
	kActorCombatStateFlee = 7,
	kActorCombatStateApproachRangedAttack = 8
};

enum PoliceMazeTrackInstruction {
	kPMTIActivate = -26,
	kPMTILeave = -25,
	kPMTIShoot = -24,
	kPMTIEnemyReset = -23,
	kPMTIEnemySet = -22,
	kPMTIFlagReset = -21,
	kPMTIFlagSet = -20,
	kPMTIVariableDec = -19,
	kPMTIVariableInc = -18,
	kPMTIVariableReset = -17,
	kPMTIVariableSet = -16,
	kPMTITargetSet = -15,
	kPMTI12 = -14,
	kPMTI13 = -13,
	kPMTIPausedSet = -12,
	kPMTIPausedReset = -11,
	kPMTIPlaySound = -10,
	kPMTIObstacleReset = -9,
	kPMTIObstacleSet = -8,
	kPMTIWaitRandom = -7,
	kPMTIRotate = -6,
	kPMTIFacing = -5,
	kPMTIRestart = -4,
	kPMTIWait = -3,
	kPMTIMove = -2,
	kPMTIPosition = -1,
	kPMTI26 = 0
};

} // End of namespace BladeRunner

#endif
