/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.xml.infer.ChoiceParticle;
import com.thaiopensource.xml.infer.DatatypeInferrer;
import com.thaiopensource.xml.infer.DatatypeRepertoire;
import com.thaiopensource.xml.infer.ElementDecl;
import com.thaiopensource.xml.infer.ElementDeclInferrer;
import com.thaiopensource.xml.infer.ElementParticle;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.Schema;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InferHandler
extends DefaultHandler {
    private final Map<Name, ElementDeclInferrer> inferrerMap = new HashMap<Name, ElementDeclInferrer>();
    private OpenElement openElement = null;
    private final Set<Name> startSet = new HashSet<Name>();
    private final List<Name> attributeNames = new Vector<Name>();
    private final DatatypeRepertoire datatypes;
    private final StringBuffer textBuffer = new StringBuffer();
    private final Set<String> usedNamespaceUris = new HashSet<String>();
    private final Schema schema = new Schema();
    private final Set<String> assignedPrefixes = new HashSet<String>();

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Name name = this.makeName(string, string2);
        if (this.openElement == null) {
            this.startSet.add(name);
        } else {
            if (this.textBuffer.length() > 0) {
                if (!DatatypeInferrer.isWhiteSpace(this.textBuffer.toString())) {
                    this.openElement.inferrer.addText();
                }
                this.textBuffer.setLength(0);
            }
            this.openElement.inferrer.addElement(name);
        }
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            this.attributeNames.add(this.makeName(attributes.getURI(i), attributes.getLocalName(i)));
        }
        ElementDeclInferrer elementDeclInferrer = this.inferrerMap.get(name);
        if (elementDeclInferrer == null) {
            elementDeclInferrer = new ElementDeclInferrer(this.datatypes, this.attributeNames);
            this.inferrerMap.put(name, elementDeclInferrer);
        } else {
            elementDeclInferrer.addAttributeNames(this.attributeNames);
        }
        int n2 = attributes.getLength();
        for (n = 0; n < n2; ++n) {
            elementDeclInferrer.addAttributeValue(this.attributeNames.get(n), attributes.getValue(n));
        }
        this.attributeNames.clear();
        this.openElement = new OpenElement(this.openElement, elementDeclInferrer);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (string != null && !string.equals("") && this.schema.getPrefixMap().get(string2) == null && !this.assignedPrefixes.contains(string)) {
            this.assignedPrefixes.add(string);
            this.schema.getPrefixMap().put(string2, string);
        }
    }

    private Name makeName(String string, String string2) {
        if (!string.equals("")) {
            this.usedNamespaceUris.add(string);
        }
        return new Name(string, string2);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.openElement.inferrer.wantValue()) {
            this.textBuffer.append(cArray, n, n2);
        } else {
            block3: for (int i = 0; i < n2; ++i) {
                switch (cArray[n + i]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        this.openElement.inferrer.addText();
                        return;
                    }
                }
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.openElement.inferrer.wantValue()) {
            this.openElement.inferrer.addValue(this.textBuffer.toString());
            this.textBuffer.setLength(0);
        } else {
            this.openElement.inferrer.endSequence();
        }
        this.openElement = this.openElement.parent;
    }

    public Schema getSchema() {
        for (Map.Entry<Name, ElementDeclInferrer> entry : this.inferrerMap.entrySet()) {
            ElementDecl elementDecl = entry.getValue().infer();
            Name name = entry.getKey();
            this.schema.getElementDecls().put(name, elementDecl);
        }
        this.schema.setStart(this.makeStart());
        this.schema.getPrefixMap().keySet().retainAll(this.usedNamespaceUris);
        return this.schema;
    }

    private Particle makeStart() {
        Particle particle = null;
        for (Name name : this.startSet) {
            ElementParticle elementParticle = new ElementParticle(name);
            if (particle == null) {
                particle = elementParticle;
                continue;
            }
            particle = new ChoiceParticle(particle, elementParticle);
        }
        return particle;
    }

    public InferHandler(DatatypeLibraryFactory datatypeLibraryFactory) {
        this.datatypes = new DatatypeRepertoire(datatypeLibraryFactory);
    }

    private static class OpenElement {
        final OpenElement parent;
        final ElementDeclInferrer inferrer;

        public OpenElement(OpenElement openElement, ElementDeclInferrer elementDeclInferrer) {
            this.parent = openElement;
            this.inferrer = elementDeclInferrer;
        }
    }
}

