# coding: utf8
from __future__ import unicode_literals

from ...symbols import NOUN, PROPN, PART, INTJ, SPACE, PRON, AUX, SCONJ
from ...symbols import POS, PUNCT, SYM, ADJ, CCONJ, NUM, DET, ADV, ADP, X, VERB

TAG_MAP = {
    "JJ-Ez": {POS: ADJ},
    "INJC": {POS: X},
    "QFC": {POS: DET},
    "UNK": {POS: X},
    "NSTC": {POS: ADV},
    "NST": {POS: ADV},
    "VMC": {POS: VERB},
    "PRPC": {POS: PRON},
    "RBC": {POS: ADV},
    "PSPC": {POS: ADP},
    "INJ": {POS: X},
    "JJZ": {POS: ADJ},
    "CCC": {POS: SCONJ},
    "NN-Ez": {POS: NOUN},
    "ECH": {POS: NOUN},
    "WQ": {POS: DET},
    "RDP": {POS: ADJ},
    "JJC": {POS: ADJ},
    "NEG": {POS: PART},
    "NNZ": {POS: NOUN},
    "QO": {POS: ADJ},
    "INTFC": {POS: ADV},
    "INTF": {POS: ADV},
    "NFC": {POS: ADP},
    "QCC": {POS: NUM},
    "QC": {POS: NUM},
    "QF": {POS: DET},
    "VAUX": {POS: AUX},
    "VM": {POS: VERB},
    "DEM": {POS: DET},
    "NNPC": {POS: PROPN},
    "NNC": {POS: NOUN},
    "PSP": {POS: ADP},
    ".": {POS: PUNCT},
    ",": {POS: PUNCT},
    "-LRB-": {POS: PUNCT},
    "-RRB-": {POS: PUNCT},
    "``": {POS: PUNCT},
    '""': {POS: PUNCT},
    "''": {POS: PUNCT},
    ":": {POS: PUNCT},
    "$": {POS: SYM},
    "#": {POS: SYM},
    "AFX": {POS: ADJ},
    "CC": {POS: CCONJ},
    "CD": {POS: NUM},
    "DT": {POS: DET},
    "EX": {POS: ADV},
    "FW": {POS: X},
    "HYPH": {POS: PUNCT},
    "IN": {POS: ADP},
    "JJ": {POS: ADJ},
    "JJR": {POS: ADJ},
    "JJS": {POS: ADJ},
    "LS": {POS: PUNCT},
    "MD": {POS: VERB},
    "NIL": {POS: ""},
    "NN": {POS: NOUN},
    "NNP": {POS: PROPN},
    "NNPS": {POS: PROPN},
    "NNS": {POS: NOUN},
    "PDT": {POS: ADJ},
    "POS": {POS: PART},
    "PRP": {POS: PRON},
    "PRP$": {POS: ADJ},
    "RB": {POS: ADV},
    "RBR": {POS: ADV},
    "RBS": {POS: ADV},
    "RP": {POS: PART},
    "SP": {POS: SPACE},
    "SYM": {POS: SYM},
    "TO": {POS: PART},
    "UH": {POS: INTJ},
    "VB": {POS: VERB},
    "VBD": {POS: VERB},
    "VBG": {POS: VERB},
    "VBN": {POS: VERB},
    "VBP": {POS: VERB},
    "VBZ": {POS: VERB},
    "WDT": {POS: ADJ},
    "WP": {POS: NOUN},
    "WP$": {POS: ADJ},
    "WRB": {POS: ADV},
    "ADD": {POS: X},
    "NFP": {POS: PUNCT},
    "GW": {POS: X},
    "XX": {POS: X},
    "BES": {POS: VERB},
    "HVS": {POS: VERB},
    "_SP": {POS: SPACE},
}
