# coding: utf8
from __future__ import unicode_literals

from ...symbols import POS, PUNCT, ADJ, CCONJ, NUM, DET, ADV, ADP, X, VERB
from ...symbols import NOUN, PROPN, PART, INTJ, SPACE, PRON, AUX, SCONJ


TAG_MAP = {
    "ADJ__Gender=Fem|Number=Plur": {POS: ADJ},
    "ADJ__Gender=Fem|Number=Plur|NumType=Ord": {POS: ADJ},
    "ADJ__Gender=Fem|Number=Sing": {POS: ADJ},
    "ADJ__Gender=Fem|Number=Sing|NumType=Ord": {POS: ADJ},
    "ADJ__Gender=Masc": {POS: ADJ},
    "ADJ__Gender=Masc|Number=Plur": {POS: ADJ},
    "ADJ__Gender=Masc|Number=Plur|NumType=Ord": {POS: ADJ},
    "ADJ__Gender=Masc|Number=Sing": {POS: ADJ},
    "ADJ__Gender=Masc|Number=Sing|NumType=Card": {POS: ADJ},
    "ADJ__Gender=Masc|Number=Sing|NumType=Ord": {POS: ADJ},
    "ADJ__NumType=Card": {POS: ADJ},
    "ADJ__NumType=Ord": {POS: ADJ},
    "ADJ__Number=Plur": {POS: ADJ},
    "ADJ__Number=Sing": {POS: ADJ},
    "ADJ__Number=Sing|NumType=Ord": {POS: ADJ},
    "ADJ___": {POS: ADJ},
    "ADP__Gender=Fem|Number=Plur|Person=3": {POS: ADP},
    "ADP__Gender=Masc|Number=Plur|Person=3": {POS: ADP},
    "ADP__Gender=Masc|Number=Sing|Person=3": {POS: ADP},
    "ADP___": {POS: ADP},
    "ADV__Polarity=Neg": {POS: ADV},
    "ADV__PronType=Int": {POS: ADV},
    "ADV___": {POS: ADV},
    "AUX__Gender=Fem|Number=Plur|Tense=Past|VerbForm=Part": {POS: AUX},
    "AUX__Gender=Fem|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: AUX},
    "AUX__Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part": {POS: AUX},
    "AUX__Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: AUX},
    "AUX__Gender=Masc|Number=Plur|Tense=Past|VerbForm=Part": {POS: AUX},
    "AUX__Gender=Masc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: AUX},
    "AUX__Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part": {POS: AUX},
    "AUX__Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: AUX},
    "AUX__Mood=Cnd|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Cnd|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Cnd|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Cnd|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Cnd|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Imp|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Plur|Person=1|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Plur|Person=1|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Plur|Person=3|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Plur|Person=3|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Plur|Person=3|Tense=Past|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Sing|Person=1|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Sing|Person=2|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Sing|Person=3|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Sing|Person=3|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Sing|Person=3|Tense=Past|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Sub|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Sub|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Sub|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Sub|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Mood=Sub|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "AUX__Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: AUX},
    "AUX__Tense=Past|VerbForm=Part": {POS: AUX},
    "AUX__Tense=Pres|VerbForm=Part": {POS: AUX},
    "AUX__VerbForm=Inf": {POS: AUX},
    "CCONJ___": {POS: CCONJ},
    "DET__Definite=Def|Gender=Fem|Number=Sing|PronType=Art": {POS: DET},
    "DET__Definite=Def|Gender=Masc|Number=Sing|PronType=Art": {POS: DET},
    "DET__Definite=Def|Number=Plur|PronType=Art": {POS: DET},
    "DET__Definite=Def|Number=Sing|PronType=Art": {POS: DET},
    "DET__Definite=Ind|Gender=Fem|Number=Plur|PronType=Art": {POS: DET},
    "DET__Definite=Ind|Gender=Fem|Number=Sing|PronType=Art": {POS: DET},
    "DET__Definite=Ind|Gender=Masc|Number=Plur|PronType=Art": {POS: DET},
    "DET__Definite=Ind|Gender=Masc|Number=Sing|PronType=Art": {POS: DET},
    "DET__Definite=Ind|Number=Plur|PronType=Art": {POS: DET},
    "DET__Definite=Ind|Number=Sing|PronType=Art": {POS: DET},
    "DET__Gender=Fem|Number=Plur": {POS: DET},
    "DET__Gender=Fem|Number=Plur|PronType=Int": {POS: DET},
    "DET__Gender=Fem|Number=Sing": {POS: DET},
    "DET__Gender=Fem|Number=Sing|Poss=Yes": {POS: DET},
    "DET__Gender=Fem|Number=Sing|PronType=Dem": {POS: DET},
    "DET__Gender=Fem|Number=Sing|PronType=Int": {POS: DET},
    "DET__Gender=Masc|Number=Plur": {POS: DET},
    "DET__Gender=Masc|Number=Sing": {POS: DET},
    "DET__Gender=Masc|Number=Sing|PronType=Dem": {POS: DET},
    "DET__Gender=Masc|Number=Sing|PronType=Int": {POS: DET},
    "DET__Number=Plur": {POS: DET},
    "DET__Number=Plur|Poss=Yes": {POS: DET},
    "DET__Number=Plur|PronType=Dem": {POS: DET},
    "DET__Number=Sing": {POS: DET},
    "DET__Number=Sing|Poss=Yes": {POS: DET},
    "DET___": {POS: DET},
    "INTJ___": {POS: INTJ},
    "NOUN__Gender=Fem": {POS: NOUN},
    "NOUN__Gender=Fem|Number=Plur": {POS: NOUN},
    "NOUN__Gender=Fem|Number=Sing": {POS: NOUN},
    "NOUN__Gender=Masc": {POS: NOUN},
    "NOUN__Gender=Masc|Number=Plur": {POS: NOUN},
    "NOUN__Gender=Masc|Number=Plur|NumType=Card": {POS: NOUN},
    "NOUN__Gender=Masc|Number=Sing": {POS: NOUN},
    "NOUN__Gender=Masc|Number=Sing|NumType=Card": {POS: NOUN},
    "NOUN__NumType=Card": {POS: NOUN},
    "NOUN__Number=Plur": {POS: NOUN},
    "NOUN__Number=Sing": {POS: NOUN},
    "NOUN___": {POS: NOUN},
    "NUM__Gender=Masc|Number=Plur|NumType=Card": {POS: NUM},
    "NUM__NumType=Card": {POS: NUM},
    "PART___": {POS: PART},
    "PRON__Gender=Fem|Number=Plur": {POS: PRON},
    "PRON__Gender=Fem|Number=Plur|Person=3": {POS: PRON},
    "PRON__Gender=Fem|Number=Plur|Person=3|PronType=Prs": {POS: PRON},
    "PRON__Gender=Fem|Number=Plur|Person=3|PronType=Rel": {POS: PRON},
    "PRON__Gender=Fem|Number=Plur|PronType=Dem": {POS: PRON},
    "PRON__Gender=Fem|Number=Plur|PronType=Rel": {POS: PRON},
    "PRON__Gender=Fem|Number=Sing|Person=3": {POS: PRON},
    "PRON__Gender=Fem|Number=Sing|Person=3|PronType=Prs": {POS: PRON},
    "PRON__Gender=Fem|Number=Sing|PronType=Dem": {POS: PRON},
    "PRON__Gender=Fem|Number=Sing|PronType=Rel": {POS: PRON},
    "PRON__Gender=Fem|PronType=Rel": {POS: PRON},
    "PRON__Gender=Masc|Number=Plur": {POS: PRON},
    "PRON__Gender=Masc|Number=Plur|Person=3": {POS: PRON},
    "PRON__Gender=Masc|Number=Plur|Person=3|PronType=Prs": {POS: PRON},
    "PRON__Gender=Masc|Number=Plur|Person=3|PronType=Rel": {POS: PRON},
    "PRON__Gender=Masc|Number=Plur|PronType=Dem": {POS: PRON},
    "PRON__Gender=Masc|Number=Plur|PronType=Rel": {POS: PRON},
    "PRON__Gender=Masc|Number=Sing": {POS: PRON},
    "PRON__Gender=Masc|Number=Sing|Person=3": {POS: PRON},
    "PRON__Gender=Masc|Number=Sing|Person=3|PronType=Dem": {POS: PRON},
    "PRON__Gender=Masc|Number=Sing|Person=3|PronType=Prs": {POS: PRON},
    "PRON__Gender=Masc|Number=Sing|PronType=Dem": {POS: PRON},
    "PRON__Gender=Masc|Number=Sing|PronType=Rel": {POS: PRON},
    "PRON__Gender=Masc|PronType=Rel": {POS: PRON},
    "PRON__NumType=Card|PronType=Rel": {POS: PRON},
    "PRON__Number=Plur|Person=1": {POS: PRON},
    "PRON__Number=Plur|Person=1|PronType=Prs": {POS: PRON},
    "PRON__Number=Plur|Person=1|Reflex=Yes": {POS: PRON},
    "PRON__Number=Plur|Person=2": {POS: PRON},
    "PRON__Number=Plur|Person=2|PronType=Prs": {POS: PRON},
    "PRON__Number=Plur|Person=2|Reflex=Yes": {POS: PRON},
    "PRON__Number=Plur|Person=3": {POS: PRON},
    "PRON__Number=Plur|PronType=Rel": {POS: PRON},
    "PRON__Number=Sing|Person=1": {POS: PRON},
    "PRON__Number=Sing|Person=1|PronType=Prs": {POS: PRON},
    "PRON__Number=Sing|Person=1|Reflex=Yes": {POS: PRON},
    "PRON__Number=Sing|Person=2|PronType=Prs": {POS: PRON},
    "PRON__Number=Sing|Person=3": {POS: PRON},
    "PRON__Number=Sing|PronType=Dem": {POS: PRON},
    "PRON__Number=Sing|PronType=Rel": {POS: PRON},
    "PRON__Person=3": {POS: PRON},
    "PRON__Person=3|Reflex=Yes": {POS: PRON},
    "PRON__PronType=Int": {POS: PRON},
    "PRON__PronType=Rel": {POS: PRON},
    "PRON___": {POS: PRON},
    "PROPN__Gender=Fem|Number=Plur": {POS: PROPN},
    "PROPN__Gender=Fem|Number=Sing": {POS: PROPN},
    "PROPN__Gender=Masc": {POS: PROPN},
    "PROPN__Gender=Masc|Number=Plur": {POS: PROPN},
    "PROPN__Gender=Masc|Number=Sing": {POS: PROPN},
    "PROPN__Number=Plur": {POS: PROPN},
    "PROPN__Number=Sing": {POS: PROPN},
    "PROPN___": {POS: PROPN},
    "PUNCT___": {POS: PUNCT},
    "SCONJ___": {POS: SCONJ},
    "VERB__Gender=Fem|Number=Plur|Tense=Past|VerbForm=Part": {POS: VERB},
    "VERB__Gender=Fem|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB},
    "VERB__Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part": {POS: VERB},
    "VERB__Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB},
    "VERB__Gender=Masc|Number=Plur|Tense=Past|VerbForm=Part": {POS: VERB},
    "VERB__Gender=Masc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB},
    "VERB__Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part": {POS: VERB},
    "VERB__Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB},
    "VERB__Gender=Masc|Tense=Past|VerbForm=Part": {POS: VERB},
    "VERB__Gender=Masc|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB},
    "VERB__Mood=Cnd|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Cnd|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Cnd|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Imp|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Imp|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Imp|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Plur|Person=1|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Plur|Person=1|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Plur|Person=2|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Plur|Person=2|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Plur|Person=3|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Plur|Person=3|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Plur|Person=3|Tense=Past|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Sing|Person=1|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Sing|Person=1|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Sing|Person=3|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Sing|Person=3|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Sing|Person=3|Tense=Past|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|Person=3|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Ind|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Sub|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Sub|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Sub|Number=Sing|Person=3|Tense=Past|VerbForm=Fin": {POS: VERB},
    "VERB__Mood=Sub|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "VERB__Number=Plur|Tense=Past|VerbForm=Part": {POS: VERB},
    "VERB__Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB},
    "VERB__Number=Sing|Tense=Past|VerbForm=Part": {POS: VERB},
    "VERB__Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB},
    "VERB__Tense=Past|VerbForm=Part": {POS: VERB},
    "VERB__Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB},
    "VERB__Tense=Pres|VerbForm=Part": {POS: VERB},
    "VERB__VerbForm=Inf": {POS: VERB},
    "VERB__VerbForm=Part": {POS: VERB},
    "X___": {POS: X},
    "_SP": {POS: SPACE},
}
