# For now, the individual object implementations are split out into
# separate files (obj_*.c), with helper functions and module
# initialization in datetime.c.  This will be changed to simply be a
# single file when things have settled down.

from distutils.core import setup, Extension

setup(
    name="PosixTimeZone", version = "0.9.4",
    py_modules=["PosixTimeZone","test_PosixTimeZone"],
    ext_modules=[Extension("_PosixTimeZone", ["_PosixTimeZone.c"])],
    author='Stuart Bishop',
    author_email='zen@shangri-la.dropbear.id.au',
    maintainer='Stuart Bishop',
    maintainer_email='zen@shangri-la.dropbear.id.au',
    url='http://stuartbishop.net/Software/PosixTimeZone',
    license=open('LICENSE.txt').read(),
    description='datetime tzinfo class to hook into the OS timezone libraries',
    long_description='''
        PosixTimeZone is a tzinfo implementation for Python 2.3, using the 
        POSIX calls provided by many operating systems to handle timezone 
        calculations::

            >>> from datetime import timedelta,datetime
            >>> from PosixTimeZone import PosixTimeZone
            >>> UTC = PosixTimeZone('UTC')
            >>> Amsterdam = PosixTimeZone('Europe/Amsterdam')
            >>> now = datetime.now(UTC)
            >>> str(now)
            '2003-01-30 07:01:07.885573+00:00'
            >>> now.tzname()
            'UTC'
            >>> str(now.astimezone(Amsterdam))
            '2003-01-30 08:01:07.885573+01:00'
            >>> now.astimezone(Amsterdam).tzname()
            'CET'
        ''',
        keywords = ['datetime','timezone','conversion'],
        classifiers = [
            'Development Status :: 4 - Beta',
            'Intended Audience :: Developers',
            'License :: OSI Approved :: BSD License',
            'Operating System :: POSIX',
            'Programming Language :: Python',
            'Programming Language :: C',
            'Topic :: Software Development :: Libraries :: Python Modules',
            ],
    )
