#!/usr/bin/env python
"""
Sensoration dictionary

- the following dicts contain all sensor informations for initializing the data base
- identical information will be stored in cdf files by magpy

Information will be stored in three different tables:
SENSOR, DATAINFO, STATION

SENSOR:
        SensorID: a combination of name, serialnumber and revision
        SensorName: a name defined by the observers to refer to the instrument
        SensorType: type of sensor (e.g. fluxgate, overhauzer, temperature ...)
        SensorSerialNum: its serial number
        SensorGroup: Geophysical group (e.g. Magnetism, Gravity, Environment, Meteorology, Seismology, Radiometry, ...)
        SensorDataLogger: type of any electronics connected to the sensor
        SensorDataLoggerSerNum: its serial number
        SensorDataLoggerRevision: 4 digit revision id '0001'
        SensorDataLoggerRevisionComment: description of revision
        SensorDescription: Description of the sensor
        SensorElements: Measured components e.g. x,y,z,t_sensor,t_electonics
        SensorKeys: the keys to be used for the elements in MagPy e.g. 'x,y,z,t1,t2', should have the same number as Elements (check MagPy Manual for this)
        SensorModule: type of sensor connection
        SensorDate: Date of Sensor construction/buy
        SensorRevision: 4 digit number defining a revision ID
        SensorRevisionComment: Comment for current revision - changes to previous number (e.g. calibration)
        SensorRevisionDate: Date of revision - for 0001 this equals the SensorDate
STATION:
        StationID: unique ID of the station e.g. IAGA code
        StationIAGAcode:
        StationName: e.g. Cobenzl
        StationStreet: Stations address
        StationCity: Vienna
        StationEmail: 'ramon.egli@zamg.ac.at',
        StationPostalCode: '1190',
        StationCountry: 'Austria',
        StationInstitution: 'Zentralanstalt fuer Meteorologie und Geodynamik',
        StationWebInfo: 'http://www.zamg.ac.at',
        StationDescription: 'Running since 1951.'
DATAINFO:
        DataID:
"""

INSTDICTLIST = ['didddict', 'lemidict','gsm90dicta','gsm90dictb','cs1dict',
                             'cs2dict','posdicta','fgedict','lemi22dict',
                             'lemi36dict','opticaldict','pmagdict']


didddict = { 'SensorID': 'DIDD_3121331_0002',
             'SensorName': 'DIDD',
             'SensorType': 'dIdD',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': '3121331',
             'SensorDataLogger': 'Magrec1.0',
             'SensorDataLoggerSerNum': '001',
             'SensorDataLoggerRevision': '0001',
             'SensorDataLoggerRevisionComment': '0001',
             'SensorDescription': '',
             'SensorElements': 'x,y,z,f',
             'SensorKeys': 'x,y,z,f',
             'SensorModule': 'Serial',
             'SensorDate': '2008-04-06',
             'SensorRevision': '0002',
             'SensorRevisionComment': 'refurbished after flooding in 2009',
             'SensorRevisionDate': '2009-05-01',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '0.0',
             'DataDeltaReferencePier': 'D',
             'DataDeltaReferenceEpoch': '2009',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'xyz',
             'DataSensorAzimuth': '0',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg', # available types deg, gon, rad; used for Azimuth, Tilt, Latitude, Longitude
             'DataPier': 'Shaft',
             'DataAcquisitionLatitude': '48.265',
             'DataAcquisitionLongitude': '16.318',
             'DataLocationReference': 'WGS84',
             'DataElevation': '400',
             'DataElevationRef': 'm NN',
             'DataComponents': 'xyzf',
             'DataSamplingRate': '60',
             'DataType': 'variation', # available types variation, preliminary, quasidefinite, definite
             'DataDigitalSampling': '5',
             'DataSamplingFilter': 'Gauss 45sec',   # should contain window type and width (or describing parameters)
             'DataFlagModification': '2013-02-28 12:00:00',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '', # available types spline, polynom, horizontal linear
             'StationID': 'WIK',
             'StationIAGAcode': 'WIK',
             'StationName': 'Cobenzl',
             'StationStreet': 'Hohe Warte 38',
             'StationCity': 'Vienna',
             'StationEmail': 'ramon.egli@zamg.ac.at',
             'StationPostalCode': '1190',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.zamg.ac.at',
             'StationDescription': 'Running since 1951.'
             }


lemidict = { 'SensorID': 'LEMI025_1_0001',
             'SensorName': 'LEMI025',
             'SensorType': 'Fluxgate',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': '1',
             'SensorDataLogger': 'Lemi',
             'SensorDataLoggerSerNum': '001',
             'SensorDataLoggerRevision': '0001',
             'SensorDataLoggerRevisionComment': '0001',
             'SensorDescription': '',
             'SensorElements': 'x,y,z,Tsensor,Telectronics',
             'SensorKeys': 'x,y,z,t1,t2',
             'SensorModule': 'Serial',
             'SensorDate': '2009-04-06',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'original state',
             'SensorRevisionDate': '2009-04-06',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '0.0',
             'DataDeltaReferencePier': 'D',
             'DataDeltaReferenceEpoch': '2009',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'hdz',
             'DataSensorAzimuth': '3.3',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg',
             'DataPier': 'Basement-East',
             'DataAcquisitionLatitude': '48.265',
             'DataAcquisitionLongitude': '16.318',
             'DataLocationReference': 'WGS84',
             'DataElevation': '400',
             'DataElevationRef': 'm NN',
             'DataComponents': 'xyzf',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '',
             'DataSamplingRate': '60',
             'DataType': 'variation',
             'DataDigitalSampling': '0.1',
             'DataSamplingFilter': 'Gauss 45 sec',
             'DataFlagModification': '2013-02-28 12:00:00',
             'StationID': 'WIK',
             'StationIAGAcode': 'WIK',
             'StationName': 'Cobenzl',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.zamg.ac.at',
             'StationDescription': 'Running since 1951.'
             }


gsm90dicta = { 'SensorID': 'GSM90_14245_0001',
             'SensorName': 'GSM90',
             'SensorType': 'Overhauzer',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': '14245',
             'SensorDataLogger': 'GSM90F',
             'SensorDataLoggerSerNum': '1114800',
             'SensorDataLoggerRevision': '0001',
             'SensorDataLoggerRevisionComment': 'New',
             'SensorDescription': 'GEM: Overhauzer-Sensor without GPS',
             'SensorElements': 'f',
             'SensorKeys': 'f',
             'SensorModule': 'Serial',
             'SensorDate': '2011-11-15',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'none',
             'SensorRevisionDate': '2011-11-15',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '3.07',
             'DataDeltaReferencePier': 'A2',
             'DataDeltaReferenceEpoch': '2013',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'xyz',
             'DataSensorAzimuth': '0',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg', # available types deg, gon, rad; used for Azimuth, Tilt, Latitude, Longitude
             'DataPier': 'AS-E-10',
             'DataAcquisitionLatitude': '47.930',
             'DataAcquisitionLongitude': '15.865',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataComponents': 'f',
             'DataSamplingRate': '1',
             'DataType': 'variation', # available types variation, preliminary, quasidefinite, definite
             'DataDigitalSampling': '1',
             'DataSamplingFilter': 'None',   # should contain window type and width (or describing parameters)
             'DataFlagModification': '2013-02-28 12:00:00',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '', # available types spline, polynom, horizontal linear
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }


gsm90dictb = { 'SensorID': 'GSM90_31968_0001',
             'SensorName': 'GSM90',
             'SensorType': 'Overhauzer',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': '31968',
             'SensorDataLogger': 'GSM90',
             'SensorDataLoggerSerNum': '3061291',
             'SensorDataLoggerRevision': '0001',
             'SensorDataLoggerRevisionComment': 'Connected via GDAS data logger in combination with FGE - software for NTP timing 2013-06.',
             'SensorDescription': 'GEM: Overhauzer-Sensor without GPS',
             'SensorElements': 'f',
             'SensorKeys': 'f',
             'SensorModule': 'Serial',
             'SensorDate': '2012-02-24',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'none',
             'SensorRevisionDate': '2012-02-24',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '4.7',
             'DataDeltaReferencePier': 'A2',
             'DataDeltaReferenceEpoch': '2013',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'xyz',
             'DataSensorAzimuth': '0',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg', # available types deg, gon, rad; used for Azimuth, Tilt, Latitude, Longitude
             'DataPier': 'GS-W-01',
             'DataAcquisitionLatitude': '47.930',
             'DataAcquisitionLongitude': '15.865',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataComponents': 'xyzf',
             'DataSamplingRate': '60',
             'DataType': 'variation', # available types variation, preliminary, quasidefinite, definite
             'DataDigitalSampling': '5',
             'DataSamplingFilter': 'None',   # should contain window type and width (or describing parameters)
             'DataFlagModification': '2013-02-28 12:00:00',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '', # available types spline, polynom, horizontal linear
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }

cs1dict = { 'SensorID': 'G823A_C214_0001',
             'SensorName': 'G823A',
             'SensorType': 'Caesium',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': 'C214',
             'SensorDataLogger': 'G823A',
             'SensorDataLoggerSerNum': '823004',
             'SensorDataLoggerRevision': '0001',
             'SensorDataLoggerRevisionComment': 'Initial state from 1996-09-30.',
             'SensorDescription': 'Geometrics GEM: Caesium-Sensor attached to single ADC unit',
             'SensorElements': 'f',
             'SensorKeys': 'f',
             'SensorModule': 'Serial',
             'SensorDate': '1996-09-30',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'none',
             'SensorRevisionDate': '1996-09-30',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '0.0',
             'DataDeltaReferencePier': 'A2',
             'DataDeltaReferenceEpoch': '2013',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'xyz',
             'DataSensorAzimuth': '0',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg', # available types deg, gon, rad; used for Azimuth, Tilt, Latitude, Longitude
             'DataPier': 'SGO',
             'DataAcquisitionLatitude': '47.929',
             'DataAcquisitionLongitude': '15.865',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataComponents': 'xyzf',
             'DataSamplingRate': '1',
             'DataType': 'variation', # available types variation, preliminary, quasidefinite, definite
             'DataDigitalSampling': '10 Hz',
             'DataSamplingFilter': 'Gauss 45sec',   # should contain window type and width (or describing parameters)
             'DataFlagModification': '2013-02-28 12:00:00',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '', # available types spline, polynom, horizontal linear
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }

cs2dict = { 'SensorID': 'G823A_C228_0001',
             'SensorName': 'G823A',
             'SensorType': 'Caesium',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': 'C228',
             'SensorDataLogger': 'G823A',
             'SensorDataLoggerSerNum': '823003',
             'SensorDataLoggerRevision': '0001',
             'SensorDataLoggerRevisionComment': 'Initial state from 1996-09-30.',
             'SensorDescription': 'Geometrics GEM: Caesium-Sensor attached to single ADC unit',
             'SensorElements': 'f',
             'SensorKeys': 'f',
             'SensorModule': 'Serial',
             'SensorDate': '1996-09-30',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'none',
             'SensorRevisionDate': '1996-09-30',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '0.0',
             'DataDeltaReferencePier': 'A2',
             'DataDeltaReferenceEpoch': '2013',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'xyz',
             'DataSensorAzimuth': '0',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg', # available types deg, gon, rad; used for Azimuth, Tilt, Latitude, Longitude
             'DataPier': 'VS-W-70',
             'DataAcquisitionLatitude': '47.929',
             'DataAcquisitionLongitude': '15.865',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataComponents': 'xyzf',
             'DataSamplingRate': '60',
             'DataType': 'variation', # available types variation, preliminary, quasidefinite, definite
             'DataDigitalSampling': '5',
             'DataSamplingFilter': 'Gauss 45sec',   # should contain window type and width (or describing parameters)
             'DataFlagModification': '2013-02-28 12:00:00',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '', # available types spline, polynom, horizontal linear
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }


posdicta = { 'SensorID': 'POS1_N432_0001',
             'SensorName': 'POS1',
             'SensorType': 'Overhauzer',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': 'N432',
             'SensorDataLogger': 'POS1',
             'SensorDataLoggerSerNum': '001',
             'SensorDataLoggerRevision': '0001',
             'SensorDataLoggerRevisionComment': 'New',
             'SensorDescription': 'Quantum Magnetometry Laboratory: Overhauzer-Sensor with build-in GPS',
             'SensorElements': 'f',
             'SensorKeys': 'f',
             'SensorModule': 'Serial',
             'SensorDate': '2012-02-24',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'none',
             'SensorRevisionDate': '2012-02-24',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '6.8',
             'DataDeltaReferencePier': 'A2',
             'DataDeltaReferenceEpoch': '2013',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'xyz',
             'DataSensorAzimuth': '0',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg', # available types deg, gon, rad; used for Azimuth, Tilt, Latitude, Longitude
             'DataPier': 'GS-W-01',
             'DataAcquisitionLatitude': '47.928',
             'DataAcquisitionLongitude': '15.864',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataComponents': 'xyzf',
             'DataSamplingRate': '5',
             'DataType': 'variation', # available types variation, preliminary, quasidefinite, definite
             'DataDigitalSampling': '5',
             'DataSamplingFilter': 'None',   # should contain window type and width (or describing parameters)
             'DataFlagModification': '2013-02-28 12:00:00',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '', # available types spline, polynom, horizontal linear
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }



fgedict = { 'SensorID': 'FGE_S0252_0001',
             'SensorName': 'FGE',
             'SensorType': 'Fluxgate',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': 'S0252',
             'SensorDataLogger': 'GDAS',
             'SensorDataLoggerSerNum': '001',
             'SensorDataLoggerRevision': '0002',
             'SensorDataLoggerRevisionComment': 'updated 2013',
             'SensorDescription': 'Sensor of the Danish Meteorological Institute (now DTU).',
             'SensorElements': 'x,y,z,Tsensor',
             'SensorKeys': 'x,y,z,t1',
             'SensorModule': 'Serial',
             'SensorDate': '2004-02-13',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'original state',
             'SensorRevisionDate': '2004-02-13',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '0.0',
             'DataDeltaReferencePier': 'A2',
             'DataDeltaReferenceEpoch': '2013',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'xyz',
             'DataSensorAzimuth': '3.39',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg', # available types deg, gon, rad; used for Azimuth, Tilt, Latitude, Longitude
             'DataPier': 'GS-W-02',
             'DataAcquisitionLatitude': '47.930',
             'DataAcquisitionLongitude': '15.865',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataComponents': 'xyzf',
             'DataSamplingRate': '1',
             'DataType': 'variation', # available types variation, preliminary, quasidefinite, definite
             'DataDigitalSampling': '1',
             'DataSamplingFilter': 'Gauss',   # should contain window type and width (or describing parameters)
             'DataFlagModification': '2013-02-28 12:00:00',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '', # available types spline, polynom, horizontal linear
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }



lemi22dict = { 'SensorID': 'LEMI025_22_0001',
             'SensorName': 'LEMI025',
             'SensorType': 'Fluxgate',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': '22',
             'SensorDataLogger': 'Lemi',
             'SensorDataLoggerSerNum': '001',
             'SensorDataLoggerRevision': '0001',
             'SensorDataLoggerRevisionComment': '0001',
             'SensorDescription': '',
             'SensorElements': 'x,y,z,Tsensor,Telectronics',
             'SensorKeys': 'x,y,z,t1,t2',
             'SensorModule': 'Serial',
             'SensorDate': '2012-07-11',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'original state',
             'SensorRevisionDate': '2012-07-11',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '0.0',
             'DataDeltaReferencePier': 'A2',
             'DataDeltaReferenceEpoch': '2013',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataCompensationX': '-20.79',
             'DataCompensationY': '0.0',
             'DataCompensationZ': '-43.65',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'xyz',
             'DataSensorAzimuth': '3.35',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg', # available types deg, gon, rad; used for Azimuth, Tilt, Latitude, Longitude
             'DataPier': 'GS-W-02',
             'DataAcquisitionLatitude': '47.928',
             'DataAcquisitionLongitude': '15.865',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataComponents': 'xyzf',
             'DataSamplingRate': '1',
             'DataType': 'variation', # available types variation, preliminary, quasidefinite, definite
             'DataDigitalSampling': '10 Hz',
             'DataSamplingFilter': 'Gauss',   # should contain window type and width (or describing parameters)
             'DataFlagModification': '2013-02-28 12:00:00',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '', # available types spline, polynom, horizontal linear
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }

lemi36dict = { 'SensorID': 'LEMI036_1_0001',
             'SensorName': 'LEMI036',
             'SensorType': 'Fluxgate',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': '1',
             'SensorDataLogger': 'Lemi',
             'SensorDataLoggerSerNum': '001',
             'SensorDataLoggerRevision': '0001',
             'SensorDataLoggerRevisionComment': '0001',
             'SensorDescription': 'Lemi036 suspended borehole sensor. Connected via RS422/485-USB Moxa converter to the IndustryPC. Note: Moxa 1100er series drivers need to be installed.',
             'SensorElements': 'x,y,z,Tsensor,Telectronics',
             'SensorKeys': 'x,y,z,t1,t2',
             'SensorModule': 'Serial',
             'SensorDate': '2012-07-11',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'original state',
             'SensorRevisionDate': '2012-07-11',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '0.0',
             'DataDeltaReferencePier': 'A2',
             'DataDeltaReferenceEpoch': '2013',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'xyz',
             'DataSensorAzimuth': '3.35',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg', # available types deg, gon, rad; used for Azimuth, Tilt, Latitude, Longitude
             'DataPier': 'GS-O-01',
             'DataAcquisitionLatitude': '47.928',
             'DataAcquisitionLongitude': '15.866',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataComponents': 'xyzf',
             'DataSamplingRate': '1',
             'DataType': 'variation', # available types variation, preliminary, quasidefinite, definite
             'DataDigitalSampling': '10 Hz',
             'DataCompensationX': '-20.095',
             'DataCompensationY': '0.0',
             'DataCompensationZ': '-44.13',
             'DataSamplingFilter': 'Gauss',   # should contain window type and width (or describing parameters)
             'DataFlagModification': '2013-02-28 12:00:00',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '', # available types spline, polynom, horizontal linear
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }



opticaldict = { 'SensorID': 'LacOptCobenzl',
             'SensorName': 'Lacour Optical',
             'SensorSerialNum': 'BJ 1957',
             'SensorType': 'Fluxgate',
             'SensorGroup': 'Magnetism',
             'SensorDataLogger': 'Optical',
             'SensorElements': 'x,y,z,f',
             'SensorKeys': 'x,y,z,f',
             'SensorModule': 'File',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '0.0',
             'DataDeltaReferencePier': 'D',
             'DataDeltaReferenceEpoch': '2009',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataSensorOrientation': 'hdz',
             'DataSensorAzimuth': '3.3',
             'DataSensorTilt': '0',
             'DataAngularUnit': 'deg',
             'DataPier': 'Basement-East',
             'DataAcquisitionLatitude': '48.265',
             'DataAcquisitionLongitude': '16.318',
             'DataLocationReference': 'WGS84',
             'DataElevation': '400',
             'DataElevationRef': 'm NN',
             'DataComponents': 'xyzf',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '',
             'DataSamplingRate': '3600',
             'DataType': 'preliminary',
             'StationID': 'WIK',
             'StationIAGAcode': 'WIK',
             'StationName': 'Cobenzl',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.zamg.ac.at',
             'StationDescription': 'Running since 1951.'
             }

pmagdict = { 'SensorID': 'ELSEC820rCobenzl',
             'SensorName': 'ELSEC820R',
             'SensorType': 'ProtonMagnetometer',
             'SensorGroup': 'Magnetism',
             'SensorSerialNum': 'not known',
             'SensorElements': 'f',
             'SensorKeys': 'f',
             'SensorModule': 'Serial',
             'DataPier': 'F',
             'SensorDataLogger': 'ELSEC',
             'DataDigitalSampling': '10',
             'DataDeltaX': '0.0',
             'DataDeltaY': '0.0',
             'DataDeltaZ': '0.0',
             'DataDeltaF': '0.0',
             'DataDeltaReferencePier': 'D',
             'DataDeltaReferenceEpoch': '2009',
             'DataScaleX': '0.0',
             'DataScaleY': '0.0',
             'DataScaleZ': '0.0',
             'DataScaleUsed': 'y',
             'DataAngularUnit': 'deg',
             'DataPier': 'Basement-East',
             'DataAcquisitionLatitude': '48.265',
             'DataAcquisitionLongitude': '16.318',
             'DataLocationReference': 'WGS84',
             'DataElevation': '400',
             'DataElevationRef': 'm NN',
             'DataAbsMinTime': '',
             'DataAbsMaxTime': '',
             'DataAbsKnots': '',
             'DataAbsDegree': '',
             'DataAbsFunc': '',
             'DataType': 'preliminary',
             'StationID': 'WIK',
             'StationIAGAcode': 'WIK',
             'StationName': 'Cobenzl',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.zamg.ac.at',
             'StationDescription': 'Running since 1951.'
             }


env051dict = { 'SensorID': 'ENV05_1_0001',
             'SensorName': 'ENV05',
             'SensorType': 'Fluxgate',
             'SensorGroup': 'Environment',
             'SensorSerialNum': '1',
             'SensorDescription': 'Environment sensor. Connected via USB.',
             'SensorElements': 'T, Dewpoint, rh',
             'SensorKeys': 't1,t2,var1',
             'SensorModule': 'Serial',
             'SensorDate': '2012-01-01',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'original state',
             'DataPier': 'ceres',
             'DataAcquisitionLatitude': '47.928',
             'DataAcquisitionLongitude': '15.865',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataSamplingRate': '1',
             'DataDigitalSampling': '1',
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }

env052dict = { 'SensorID': 'ENV05_2_0001',
             'SensorName': 'ENV05',
             'SensorType': 'Fluxgate',
             'SensorGroup': 'Environment',
             'SensorSerialNum': '2',
             'SensorDescription': 'Environment sensor. Connected via USB.',
             'SensorElements': 'T, Dewpoint, rh',
             'SensorKeys': 't1,t2,var1',
             'SensorModule': 'Serial',
             'SensorDate': '2012-01-01',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'original state',
             'DataPier': 'kallisto',
             'DataAcquisitionLatitude': '47.930',
             'DataAcquisitionLongitude': '15.865',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataSamplingRate': '1',
             'DataDigitalSampling': '1',
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }


ds332988040000 = { 'SensorID': '332988040000_0001',
             'SensorName': '332988040000',
             'SensorType': 'DS1820B',
             'SensorGroup': 'Environment',
             'SensorSerialNum': '332988040000',
             'SensorDescription': 'Environment sensor. Connected via USB.',
             'SensorElements': 'T',
             'SensorKeys': 't1',
             'SensorModule': 'ow',
             'SensorDate': '2012-01-01',
             'SensorRevision': '0001',
             'SensorRevisionComment': 'original state',
             'DataPier': 'atlas',
             'DataAcquisitionLatitude': '47.928',
             'DataAcquisitionLongitude': '15.866',
             'DataLocationReference': 'WGS84',
             'DataElevation': '1087',
             'DataElevationRef': 'm NN',
             'DataSamplingRate': '1',
             'DataDigitalSampling': '1',
             'StationID': 'WIC',
             'StationIAGAcode': 'WIC',
             'StationName': 'Conrad Observatory',
             'StationStreet': 'Trafelberg 2',
             'StationCity': 'Muggendorf',
             'StationEmail': 'roman.leonhardt@zamg.ac.at',
             'StationPostalCode': '2763',
             'StationCountry': 'Austria',
             'StationInstitution': 'Zentralanstalt fuer Meteorologie und Geodynamik',
             'StationWebInfo': 'http://www.conrad-observatory.at',
             'StationDescription': 'The Conrad Observatory is a geophysical observatory for monitoring important physical parameters of our planet. It is named after the Austrian geophysicist Victor Conrad (1876 - 1962), who worked for many years at the Central Institute for Meteorology and Geodynamic (ZAMG) in Vienna. It is located 50km southwest of Vienna, Austria, in a nature reserve on the Trafelberg, at an altitude of just above 1000m. The observatory is almost entirely underground and guarantees, among other things, constant temperature for all applied techniques. With its range of supported measurement techniques, instrumentation and the layout of the underground facilities, the Conrad Observatory represents a unique research and development location for earth scientists of all disciplines.'
             }
