<?php

// TODO: use ArcanistUnitTestEngine once our arcanist supports it
final class MercurialTestEngine extends ArcanistBaseUnitTestEngine {

  public function run() {
    $root = Filesystem::resolvePath($this->getWorkingCopy()->getProjectRoot());
    $json_tmp = new TempFile();
    $future = new ExecFuture('%s/scripts/unit.py %s', $root, $json_tmp);
    $future->setCWD(Filesystem::resolvePath($root));
    $future->resolve();
    $result = $this->parseJsonResult($json_tmp);
    return $result;
  }

  protected function parseJsonResult($json_path) {
    $results = [];
    $json = json_decode(Filesystem::readFile($json_path));

    // The JSON looks like the following:
    //   { "test-name.t": {
    //       "result": "success",
    //       "diff": "",
    //       "time": "0.750", } }
    foreach ($json as $name => $info) {
      $result = new ArcanistUnitTestResult();
      $result->setName($name);
      $result->setDuration($info->time);

      switch ($info->result) {
      case 'failure':
        $result->setResult(ArcanistUnitTestResult::RESULT_FAIL);
        $result->setUserData("```\n".$info->diff."\n```");
        break;
      case 'skip':
        $result->setResult(ArcanistUnitTestResult::RESULT_SKIP);
        break;
      case 'success':
        $result->setResult(ArcanistUnitTestResult::RESULT_PASS);
        break;
      default:
        $result->setResult(ArcanistUnitTestResult::RESULT_UNSOUND);
      }

      $results[] = $result;
    }
    return $results;
  }

}
