# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Iterable
from typing_extensions import Literal, TypedDict

from .logging_param import LoggingParam

__all__ = ["CompressResponseRuleParam", "ActionParameters", "ActionParametersAlgorithm"]


class ActionParametersAlgorithm(TypedDict, total=False):
    name: Literal["none", "auto", "default", "gzip", "brotli"]
    """Name of compression algorithm to enable."""


class ActionParameters(TypedDict, total=False):
    algorithms: Iterable[ActionParametersAlgorithm]
    """Custom order for compression algorithms."""


class CompressResponseRuleParam(TypedDict, total=False):
    id: str
    """The unique ID of the rule."""

    action: Literal["compress_response"]
    """The action to perform when the rule matches."""

    action_parameters: ActionParameters
    """The parameters configuring the rule's action."""

    description: str
    """An informative description of the rule."""

    enabled: bool
    """Whether the rule should be executed."""

    expression: str
    """The expression defining which traffic will match the rule."""

    logging: LoggingParam
    """An object configuring the rule's logging behavior."""

    ref: str
    """The reference of the rule (the rule ID by default)."""
