/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.layoutmgr.table.TableStepper;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.BreakUtil;

class RowGroupLayoutManager {
    private static Log log = LogFactory.getLog(RowGroupLayoutManager.class);
    private static final MinOptMax MAX_STRETCH = MinOptMax.getInstance(0, 0, Integer.MAX_VALUE);
    private EffRow[] rowGroup;
    private TableLayoutManager tableLM;
    private TableStepper tableStepper;

    RowGroupLayoutManager(TableLayoutManager tableLM, EffRow[] rowGroup, TableStepper tableStepper) {
        this.tableLM = tableLM;
        this.rowGroup = rowGroup;
        this.tableStepper = tableStepper;
    }

    public LinkedList<ListElement> getNextKnuthElements(LayoutContext context, int alignment, int bodyType) {
        LinkedList<ListElement> returnList = new LinkedList<ListElement>();
        this.createElementsForRowGroup(context, alignment, bodyType, returnList);
        context.updateKeepWithPreviousPending(this.rowGroup[0].getKeepWithPrevious());
        context.updateKeepWithNextPending(this.rowGroup[this.rowGroup.length - 1].getKeepWithNext());
        int breakBefore = 9;
        TableRow firstRow = this.rowGroup[0].getTableRow();
        if (firstRow != null) {
            breakBefore = firstRow.getBreakBefore();
        }
        context.setBreakBefore(BreakUtil.compareBreakClasses(breakBefore, this.rowGroup[0].getBreakBefore()));
        int breakAfter = 9;
        TableRow lastRow = this.rowGroup[this.rowGroup.length - 1].getTableRow();
        if (lastRow != null) {
            breakAfter = lastRow.getBreakAfter();
        }
        context.setBreakAfter(BreakUtil.compareBreakClasses(breakAfter, this.rowGroup[this.rowGroup.length - 1].getBreakAfter()));
        return returnList;
    }

    private void createElementsForRowGroup(LayoutContext context, int alignment, int bodyType, LinkedList returnList) {
        log.debug("Handling row group with " + this.rowGroup.length + " rows...");
        EffRow[] effRowArray = this.rowGroup;
        int n = effRowArray.length;
        for (int i = 0; i < n; ++i) {
            EffRow aRowGroup;
            EffRow row = aRowGroup = effRowArray[i];
            for (Object o : row.getGridUnits()) {
                GridUnit gu = (GridUnit)o;
                if (!gu.isPrimary()) continue;
                PrimaryGridUnit primary = gu.getPrimary();
                primary.createCellLM();
                primary.getCellLM().setParent(this.tableLM);
                int spanWidth = 0;
                ListIterator<FONode> colIter = this.tableLM.getTable().getColumns().listIterator(primary.getColIndex());
                int c = primary.getCell().getNumberColumnsSpanned();
                for (int i2 = 0; i2 < c; ++i2) {
                    spanWidth += ((TableColumn)colIter.next()).getColumnWidth().getValue(this.tableLM);
                }
                LayoutContext childLC = LayoutContext.newInstance();
                childLC.setStackLimitBP(context.getStackLimitBP());
                childLC.setRefIPD(spanWidth);
                List<ListElement> elems = primary.getCellLM().getNextKnuthElements(childLC, alignment);
                ElementListObserver.observe(elems, "table-cell", primary.getCell().getId());
                primary.setElements(elems);
            }
        }
        this.computeRowHeights();
        LinkedList elements = this.tableStepper.getCombinedKnuthElementsForRowGroup(context, this.rowGroup, bodyType);
        returnList.addAll(elements);
    }

    private void computeRowHeights() {
        log.debug("rowGroup:");
        MinOptMax[] rowHeights = new MinOptMax[this.rowGroup.length];
        for (int rgi = 0; rgi < this.rowGroup.length; ++rgi) {
            MinOptMax explicitRowHeight;
            EffRow row = this.rowGroup[rgi];
            TableRow tableRowFO = this.rowGroup[rgi].getTableRow();
            if (tableRowFO == null) {
                rowHeights[rgi] = MAX_STRETCH;
                explicitRowHeight = MAX_STRETCH;
            } else {
                LengthRangeProperty rowBPD = tableRowFO.getBlockProgressionDimension();
                rowHeights[rgi] = rowBPD.toMinOptMax(this.tableLM);
                explicitRowHeight = rowBPD.toMinOptMax(this.tableLM);
            }
            for (Object o : row.getGridUnits()) {
                GridUnit gu = (GridUnit)o;
                if (gu.isEmpty() || gu.getColSpanIndex() != 0 || !gu.isLastGridUnitRowSpan()) continue;
                PrimaryGridUnit primary = gu.getPrimary();
                int effectiveCellBPD = 0;
                LengthRangeProperty cellBPD = primary.getCell().getBlockProgressionDimension();
                if (!cellBPD.getMinimum(this.tableLM).isAuto()) {
                    effectiveCellBPD = cellBPD.getMinimum(this.tableLM).getLength().getValue(this.tableLM);
                }
                if (!cellBPD.getOptimum(this.tableLM).isAuto()) {
                    effectiveCellBPD = cellBPD.getOptimum(this.tableLM).getLength().getValue(this.tableLM);
                }
                if (gu.getRowSpanIndex() == 0) {
                    effectiveCellBPD = Math.max(effectiveCellBPD, explicitRowHeight.getOpt());
                }
                effectiveCellBPD = Math.max(effectiveCellBPD, primary.getContentLength());
                int borderWidths = primary.getBeforeAfterBorderWidth();
                int padding = 0;
                CommonBorderPaddingBackground cbpb = primary.getCell().getCommonBorderPaddingBackground();
                padding += cbpb.getPaddingBefore(false, primary.getCellLM());
                int effRowHeight = effectiveCellBPD + (padding += cbpb.getPaddingAfter(false, primary.getCellLM())) + borderWidths;
                for (int prev = rgi - 1; prev >= rgi - gu.getRowSpanIndex(); --prev) {
                    effRowHeight -= rowHeights[prev].getOpt();
                }
                if (effRowHeight <= rowHeights[rgi].getMin()) continue;
                rowHeights[rgi] = rowHeights[rgi].extendMinimum(effRowHeight);
            }
            row.setHeight(rowHeights[rgi]);
            row.setExplicitHeight(explicitRowHeight);
        }
    }
}

