/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;

class RandomAccessReadDataStream
extends TTFDataStream {
    private static final Log LOG = LogFactory.getLog(RandomAccessReadDataStream.class);
    private final long length;
    private final byte[] data;
    private int currentPosition = 0;

    RandomAccessReadDataStream(RandomAccessRead randomAccessRead) throws IOException {
        int amountRead;
        this.length = randomAccessRead.length();
        this.data = new byte[(int)this.length];
        int remainingBytes = this.data.length;
        while ((amountRead = randomAccessRead.read(this.data, this.data.length - remainingBytes, remainingBytes)) > 0) {
            remainingBytes -= amountRead;
        }
    }

    RandomAccessReadDataStream(InputStream inputStream) throws IOException {
        this.data = IOUtils.toByteArray(inputStream);
        this.length = this.data.length;
    }

    @Override
    public long getCurrentPosition() throws IOException {
        return this.currentPosition;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        if ((long)this.currentPosition >= this.length) {
            return -1;
        }
        return this.data[this.currentPosition++] & 0xFF;
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    private int readInt() throws IOException {
        int b1 = this.read();
        int b2 = this.read();
        int b3 = this.read();
        int b4 = this.read();
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Invalid position " + pos);
        }
        this.currentPosition = pos < this.length ? (int)pos : (int)this.length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if ((long)this.currentPosition >= this.length) {
            return -1;
        }
        int remainingBytes = (int)(this.length - (long)this.currentPosition);
        int bytesToRead = Math.min(remainingBytes, len);
        System.arraycopy(this.data, this.currentPosition, b, off, bytesToRead);
        this.currentPosition += bytesToRead;
        return bytesToRead;
    }

    @Override
    public RandomAccessRead createSubView(long length) {
        try {
            return new RandomAccessReadBuffer(this.data).createView(this.currentPosition, length);
        }
        catch (IOException e) {
            LOG.warn("Could not create a SubView", e);
            return null;
        }
    }

    @Override
    public InputStream getOriginalData() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long getOriginalDataSize() {
        return this.length;
    }
}

