/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import java.util.Hashtable;
import jcckit.util.ConfigParameters;
import jcckit.util.FactoryException;

public class FontStyle {
    private static final Hashtable REPOSITORY = new Hashtable();
    static final String NORMAL_TXT = "normal";
    static final String BOLD_TXT = "bold";
    static final String ITALIC_TXT = "italic";
    static final String BOLD_ITALIC_TXT = "bold italic";
    public static final FontStyle NORMAL = new FontStyle("normal");
    public static final FontStyle BOLD = new FontStyle("bold");
    public static final FontStyle ITALIC = new FontStyle("italic");
    public static final FontStyle BOLD_ITALIC = new FontStyle("bold italic");
    private final String _description;

    private FontStyle(String description) {
        this._description = description;
        REPOSITORY.put(description, this);
    }

    public static FontStyle getFontStyle(ConfigParameters config, String key, FontStyle defaultValue) {
        FontStyle result = defaultValue;
        String value = config.get(key, null);
        if (value != null && (result = (FontStyle)REPOSITORY.get(value)) == null) {
            throw new FactoryException(config, key, "Invalid font style.");
        }
        return result;
    }

    public String toString() {
        return this._description;
    }
}

