N = 101; x_max = 5; interval = linspace(0,x_max,N)';
omega = 2*pi;
f = @(x,t)(cos(x*pi/2).*(x<=1))*(sin(omega*t)*(t<=2));
u0 = 0;   u1 = 0;
w2 = 1; w1 = 0.25; a = 2; b = 0; c = 0; d = 1;
BCleft = [0]; BCright = [0];
t0 = 0; tend = 10; steps = [250,10];
[x,u,t] = I2BVP1D(interval,w2,w1,a,b,c,d,f,BCleft,BCright,u0,u1,t0,tend,steps);

figure(1); mesh(t,x,u); xlabel('time t'); ylabel('position x'); zlabel('u')
           xlim([min(t),max(t)]); ylim([min(x),max(x)]); view([20,20])

figure(2); contour(t,x,u,0.001*[-1,+1]); xlabel('time t'); ylabel('position x');
           xlim([min(t),max(t)]); ylim([min(x),max(x)]);


