## -*- texinfo -*-
## @deftypefn{function file}{}@var{xGauss} = FEM1DGaussPoints(@var{x})
##
##  determine the coordinates of the Gauss points
##
##parameters:
##@itemize
##@item @var{x} coordinates of the nodes, generated by @var{BVP1D()}
##@end itemize
##
##return values
##@itemize
##@item @var{xGauss} coordinates of the Gauss points
##@end itemize
##
## @end deftypefn

function xGauss = FEM1DGaussPoints(x)
  x = x(:);
  h = diff(x(1:2:end));  %% length of intervals
  xm = x(2:2:end);       %% midpoints
  xGauss = sort([xm - sqrt(0.6)*h/2;xm;xm + sqrt(0.6)*h/2]);
endfunction

