## -*- texinfo -*-
## @deftypefn{function file}{}[@var{du},@var{ddu}] = FEM1DEvaluateDu(@var{x},@var{u})
##
##  evaluate the first and second derivatives at the nodes x
##
##parameters:
##@itemize
##@item @var{x} coordinates of the nodes, generated by @var{BVP1D()}
##@item @var{u} values of the function at the nodes
##@end itemize
##
##return values
##@itemize
##@item @var{du} the values of the derivative at the nodes
##@item @var{ddu} the values of the derivative at the nodes
##@end itemize
##
## @end deftypefn

function [du,ddu] = FEM1DEvaluateDu(x,u)
%% du = FEM1DEvaluateDu(x,u)
%% evaluate first and second derivatives at the nodes x
%% requires the interval x and u to be generated by BVP1D()
  n = (length(x)-1)/2;  %% number of subintervals
  du = zeros(size(x)); ddu = du;
  M = 0.5*[-3,4,-1;-2,0,2;1,-4,3];  %% matrix to determine first derivatives
  h = diff(x); h = h(1:2:end)*2;
  for jj = 1:n
    range = [2*jj-1:2*jj+1];
    du(range) += M*u(range)/h(jj);
    ddu(range) += 2*[1;2;1]*[1 -2 1]*u(range)/h(jj)^2;
  endfor
  du([1;end]) *= 2; ddu([1;end]) *= 2;
endfunction

