MODULE tIEEE754;

(* Alex Shiryaev: big procedures can overflow memory for error handlers
   in the JIT *)

	IMPORT SYSTEM, Out;

	PROCEDURE TestREAL;
		VAR y, x, z: REAL; s: SET;
	BEGIN
		x := 0.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {});
		s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(x = 0.0);

		x := +0.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {});
		s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(x = +0.0);

		x := 1.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {23..29});
		s := {23..29}; x := SYSTEM.VAL(REAL, s); ASSERT(x = 1.0);

		x := 2.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {30});
		s := {30}; x := SYSTEM.VAL(REAL, s); ASSERT(x = 2.0);

		x := 3.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {22,30});
		s := {22,30}; x := SYSTEM.VAL(REAL, s); ASSERT(x = 3.0);

		x := -1.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {23..29,31});
		s := {23..29,31}; x := SYSTEM.VAL(REAL, s); ASSERT(x = -1.0);

		x := -2.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {30,31});
		s := {30,31}; x := SYSTEM.VAL(REAL, s); ASSERT(x = -2.0);

		x := 0.1; s := SYSTEM.VAL(SET, x); ASSERT(s = {0,2,3,6,7,10,11,14,15,18,19,22,23,24,26,27,28,29});
		s := {0,2,3,6,7,10,11,14,15,18,19,22,23,24,26,27,28,29}; x := SYSTEM.VAL(REAL, s); ASSERT(x = 0.1);

		x := -0.1; s := SYSTEM.VAL(SET, x); ASSERT(s = {0,2,3,6,7,10,11,14,15,18,19,22,23,24,26,27,28,29,31});
		s := {0,2,3,6,7,10,11,14,15,18,19,22,23,24,26,27,28,29,31}; x := SYSTEM.VAL(REAL, s); ASSERT(x = -0.1);

		x := MAX(REAL); s := SYSTEM.VAL(SET, x); ASSERT(s = {0..22,24..30});
		s := {0..22,24..30}; x := SYSTEM.VAL(REAL, s); ASSERT(x = MAX(REAL));

		x := MIN(REAL); s := SYSTEM.VAL(SET, x); ASSERT(s = {0..22,24..30,31});
		s := {0..22,24..30,31}; x := SYSTEM.VAL(REAL, s); ASSERT(x = MIN(REAL));

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x + y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x + y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});

		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});

		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x + y; s := {0}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); x := x + y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); y := x + y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x + y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0});

		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := {0}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x + y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x + y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});

		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x / y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); x := x / y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); y := x / y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x / y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {0,31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0,31});

		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {0}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := {0,31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); x := x + y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); y := x + y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0,31});

		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := {0,31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x + y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x + y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0,31});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});

		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x / y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); x := x / y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); y := x / y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x / y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});

		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {0}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0});

		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {0,31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0,31})
	END TestREAL;

BEGIN
	ASSERT( SIZE(SET) = 4 );
	ASSERT( SIZE(REAL) = 4 );

	ASSERT(MIN(REAL) = -MAX(REAL));
	ASSERT(-MAX(REAL) = MIN(REAL));

	ASSERT(-MIN(REAL) = MAX(REAL));
	ASSERT(MAX(REAL) = -MIN(REAL));

	TestREAL;

	Out.String('TestIEEE754: OK'); Out.Ln
END tIEEE754.

(*<<
TestIEEE754: OK
>>*)

(*[[
!! (SYMFILE #tIEEE754 STAMP #tIEEE754.%main 1 #tIEEE754.m)
!! (CHKSUM STAMP)
!! 
MODULE tIEEE754 STAMP 0
IMPORT Out STAMP
ENDHDR

PROC tIEEE754.TestREAL 16 3 0
! 	PROCEDURE TestREAL;
! 		x := 0.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {});
FCONST 0.0
STLF -8
LDLF -8
STLW -16
LDLW -16
JEQZ L3
CONST 0
CONST 11
GLOBAL EASSERT
CALL 2
LABEL L3
! 		s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(x = 0.0);
CONST 0
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST 0.0
FJEQ L5
CONST 0
CONST 12
GLOBAL EASSERT
CALL 2
LABEL L5
! 		x := +0.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {});
FCONST 0.0
STLF -8
LDLF -8
STLW -16
LDLW -16
JEQZ L7
CONST 0
CONST 14
GLOBAL EASSERT
CALL 2
LABEL L7
! 		s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(x = +0.0);
CONST 0
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST 0.0
FJEQ L9
CONST 0
CONST 15
GLOBAL EASSERT
CALL 2
LABEL L9
! 		x := 1.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {23..29});
FCONST 1.0
STLF -8
LDLF -8
STLW -16
LDLW -16
CONST 1065353216
JEQ L11
CONST 0
CONST 17
GLOBAL EASSERT
CALL 2
LABEL L11
! 		s := {23..29}; x := SYSTEM.VAL(REAL, s); ASSERT(x = 1.0);
CONST 1065353216
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST 1.0
FJEQ L13
CONST 0
CONST 18
GLOBAL EASSERT
CALL 2
LABEL L13
! 		x := 2.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {30});
FCONST 2.0
STLF -8
LDLF -8
STLW -16
LDLW -16
CONST 1073741824
JEQ L15
CONST 0
CONST 20
GLOBAL EASSERT
CALL 2
LABEL L15
! 		s := {30}; x := SYSTEM.VAL(REAL, s); ASSERT(x = 2.0);
CONST 1073741824
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST 2.0
FJEQ L17
CONST 0
CONST 21
GLOBAL EASSERT
CALL 2
LABEL L17
! 		x := 3.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {22,30});
FCONST 3.0
STLF -8
LDLF -8
STLW -16
LDLW -16
CONST 1077936128
JEQ L19
CONST 0
CONST 23
GLOBAL EASSERT
CALL 2
LABEL L19
! 		s := {22,30}; x := SYSTEM.VAL(REAL, s); ASSERT(x = 3.0);
CONST 1077936128
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST 3.0
FJEQ L21
CONST 0
CONST 24
GLOBAL EASSERT
CALL 2
LABEL L21
! 		x := -1.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {23..29,31});
FCONST -1.0
STLF -8
LDLF -8
STLW -16
LDLW -16
CONST -1082130432
JEQ L23
CONST 0
CONST 26
GLOBAL EASSERT
CALL 2
LABEL L23
! 		s := {23..29,31}; x := SYSTEM.VAL(REAL, s); ASSERT(x = -1.0);
CONST -1082130432
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST -1.0
FJEQ L25
CONST 0
CONST 27
GLOBAL EASSERT
CALL 2
LABEL L25
! 		x := -2.0; s := SYSTEM.VAL(SET, x); ASSERT(s = {30,31});
FCONST -2.0
STLF -8
LDLF -8
STLW -16
LDLW -16
CONST -1073741824
JEQ L27
CONST 0
CONST 29
GLOBAL EASSERT
CALL 2
LABEL L27
! 		s := {30,31}; x := SYSTEM.VAL(REAL, s); ASSERT(x = -2.0);
CONST -1073741824
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST -2.0
FJEQ L29
CONST 0
CONST 30
GLOBAL EASSERT
CALL 2
LABEL L29
! 		x := 0.1; s := SYSTEM.VAL(SET, x); ASSERT(s = {0,2,3,6,7,10,11,14,15,18,19,22,23,24,26,27,28,29});
FCONST 0.1
STLF -8
LDLF -8
STLW -16
LDLW -16
CONST 1036831949
JEQ L31
CONST 0
CONST 32
GLOBAL EASSERT
CALL 2
LABEL L31
! 		s := {0,2,3,6,7,10,11,14,15,18,19,22,23,24,26,27,28,29}; x := SYSTEM.VAL(REAL, s); ASSERT(x = 0.1);
CONST 1036831949
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST 0.1
FJEQ L33
CONST 0
CONST 33
GLOBAL EASSERT
CALL 2
LABEL L33
! 		x := -0.1; s := SYSTEM.VAL(SET, x); ASSERT(s = {0,2,3,6,7,10,11,14,15,18,19,22,23,24,26,27,28,29,31});
FCONST -0.1
STLF -8
LDLF -8
STLW -16
LDLW -16
CONST -1110651699
JEQ L35
CONST 0
CONST 35
GLOBAL EASSERT
CALL 2
LABEL L35
! 		s := {0,2,3,6,7,10,11,14,15,18,19,22,23,24,26,27,28,29,31}; x := SYSTEM.VAL(REAL, s); ASSERT(x = -0.1);
CONST -1110651699
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST -0.1
FJEQ L37
CONST 0
CONST 36
GLOBAL EASSERT
CALL 2
LABEL L37
! 		x := MAX(REAL); s := SYSTEM.VAL(SET, x); ASSERT(s = {0..22,24..30});
FCONST 3.40282346639e+38
STLF -8
LDLF -8
STLW -16
LDLW -16
CONST 2139095039
JEQ L39
CONST 0
CONST 38
GLOBAL EASSERT
CALL 2
LABEL L39
! 		s := {0..22,24..30}; x := SYSTEM.VAL(REAL, s); ASSERT(x = MAX(REAL));
CONST 2139095039
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST 3.40282346639e+38
FJEQ L41
CONST 0
CONST 39
GLOBAL EASSERT
CALL 2
LABEL L41
! 		x := MIN(REAL); s := SYSTEM.VAL(SET, x); ASSERT(s = {0..22,24..30,31});
FCONST -3.40282346639e+38
STLF -8
LDLF -8
STLW -16
LDLW -16
CONST -8388609
JEQ L43
CONST 0
CONST 41
GLOBAL EASSERT
CALL 2
LABEL L43
! 		s := {0..22,24..30,31}; x := SYSTEM.VAL(REAL, s); ASSERT(x = MIN(REAL));
CONST -8388609
STLW -16
LDLW -16
STLF -8
LDLF -8
FCONST -3.40282346639e+38
FJEQ L45
CONST 0
CONST 42
GLOBAL EASSERT
CALL 2
LABEL L45
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -12
CONST -2147483648
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L47
CONST 0
CONST 44
GLOBAL EASSERT
CALL 2
LABEL L47
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x + y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L49
CONST 0
CONST 45
GLOBAL EASSERT
CALL 2
LABEL L49
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x + y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -4
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L51
CONST 0
CONST 46
GLOBAL EASSERT
CALL 2
LABEL L51
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483648
JEQ L53
CONST 0
CONST 47
GLOBAL EASSERT
CALL 2
LABEL L53
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
CONST 0
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L55
CONST 0
CONST 49
GLOBAL EASSERT
CALL 2
LABEL L55
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L57
CONST 0
CONST 50
GLOBAL EASSERT
CALL 2
LABEL L57
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -4
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L59
CONST 0
CONST 51
GLOBAL EASSERT
CALL 2
LABEL L59
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
LDLF -12
STLW -16
LDLW -16
JEQZ L61
CONST 0
CONST 52
GLOBAL EASSERT
CALL 2
LABEL L61
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
CONST 0
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L63
CONST 0
CONST 54
GLOBAL EASSERT
CALL 2
LABEL L63
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L65
CONST 0
CONST 55
GLOBAL EASSERT
CALL 2
LABEL L65
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -4
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L67
CONST 0
CONST 56
GLOBAL EASSERT
CALL 2
LABEL L67
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
LDLF -12
STLW -16
LDLW -16
JEQZ L69
CONST 0
CONST 57
GLOBAL EASSERT
CALL 2
LABEL L69
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
CONST -2147483648
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L71
CONST 0
CONST 59
GLOBAL EASSERT
CALL 2
LABEL L71
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L73
CONST 0
CONST 60
GLOBAL EASSERT
CALL 2
LABEL L73
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -4
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L75
CONST 0
CONST 61
GLOBAL EASSERT
CALL 2
LABEL L75
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483648
JEQ L77
CONST 0
CONST 62
GLOBAL EASSERT
CALL 2
LABEL L77
! 		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST 0
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
CONST -2147483648
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L79
CONST 0
CONST 64
GLOBAL EASSERT
CALL 2
LABEL L79
! 		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST 0
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L81
CONST 0
CONST 65
GLOBAL EASSERT
CALL 2
LABEL L81
! 		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST 0
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -4
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L83
CONST 0
CONST 66
GLOBAL EASSERT
CALL 2
LABEL L83
! 		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});
CONST 0
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483648
JEQ L85
CONST 0
CONST 67
GLOBAL EASSERT
CALL 2
LABEL L85
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
CONST -2147483648
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L87
CONST 0
CONST 69
GLOBAL EASSERT
CALL 2
LABEL L87
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L89
CONST 0
CONST 70
GLOBAL EASSERT
CALL 2
LABEL L89
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -4
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L91
CONST 0
CONST 71
GLOBAL EASSERT
CALL 2
LABEL L91
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483648
JEQ L93
CONST 0
CONST 72
GLOBAL EASSERT
CALL 2
LABEL L93
! 		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST 0
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
CONST 0
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L95
CONST 0
CONST 74
GLOBAL EASSERT
CALL 2
LABEL L95
! 		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST 0
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L97
CONST 0
CONST 75
GLOBAL EASSERT
CALL 2
LABEL L97
! 		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST 0
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -4
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L99
CONST 0
CONST 76
GLOBAL EASSERT
CALL 2
LABEL L99
! 		s := {}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});
CONST 0
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
LDLF -12
STLW -16
LDLW -16
JEQZ L101
CONST 0
CONST 77
GLOBAL EASSERT
CALL 2
LABEL L101
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x + y; s := {0}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -12
CONST 1
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L103
CONST 0
CONST 79
GLOBAL EASSERT
CALL 2
LABEL L103
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); x := x + y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L105
CONST 0
CONST 80
GLOBAL EASSERT
CALL 2
LABEL L105
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); y := x + y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -4
CONST 1
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L107
CONST 0
CONST 81
GLOBAL EASSERT
CALL 2
LABEL L107
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x + y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST 1
JEQ L109
CONST 0
CONST 82
GLOBAL EASSERT
CALL 2
LABEL L109
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := {0}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -12
CONST 1
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L111
CONST 0
CONST 84
GLOBAL EASSERT
CALL 2
LABEL L111
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x + y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L113
CONST 0
CONST 85
GLOBAL EASSERT
CALL 2
LABEL L113
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x + y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -4
CONST 1
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L115
CONST 0
CONST 86
GLOBAL EASSERT
CALL 2
LABEL L115
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0});
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST 1
JEQ L117
CONST 0
CONST 87
GLOBAL EASSERT
CALL 2
LABEL L117
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
CONST -2147483648
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L119
CONST 0
CONST 89
GLOBAL EASSERT
CALL 2
LABEL L119
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L121
CONST 0
CONST 90
GLOBAL EASSERT
CALL 2
LABEL L121
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -4
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L123
CONST 0
CONST 91
GLOBAL EASSERT
CALL 2
LABEL L123
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483648
JEQ L125
CONST 0
CONST 92
GLOBAL EASSERT
CALL 2
LABEL L125
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
CONST -2147483648
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L127
CONST 0
CONST 94
GLOBAL EASSERT
CALL 2
LABEL L127
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L129
CONST 0
CONST 95
GLOBAL EASSERT
CALL 2
LABEL L129
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -4
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L131
CONST 0
CONST 96
GLOBAL EASSERT
CALL 2
LABEL L131
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483648
JEQ L133
CONST 0
CONST 97
GLOBAL EASSERT
CALL 2
LABEL L133
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x / y; s := {31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FZCHECK 99
FDIV
STLF -12
CONST -2147483648
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L135
CONST 0
CONST 99
GLOBAL EASSERT
CALL 2
LABEL L135
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); x := x / y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FZCHECK 100
FDIV
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L137
CONST 0
CONST 100
GLOBAL EASSERT
CALL 2
LABEL L137
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); y := x / y; s := {31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FZCHECK 101
FDIV
STLF -4
CONST -2147483648
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L139
CONST 0
CONST 101
GLOBAL EASSERT
CALL 2
LABEL L139
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x / y; s := SYSTEM.VAL(SET, z); ASSERT(s = {31});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FZCHECK 102
FDIV
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483648
JEQ L141
CONST 0
CONST 102
GLOBAL EASSERT
CALL 2
LABEL L141
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {0,31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
CONST -2147483647
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L143
CONST 0
CONST 104
GLOBAL EASSERT
CALL 2
LABEL L143
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L145
CONST 0
CONST 105
GLOBAL EASSERT
CALL 2
LABEL L145
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -4
CONST -2147483647
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L147
CONST 0
CONST 106
GLOBAL EASSERT
CALL 2
LABEL L147
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0,31});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483647
JEQ L149
CONST 0
CONST 107
GLOBAL EASSERT
CALL 2
LABEL L149
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {0}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
CONST 1
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L151
CONST 0
CONST 109
GLOBAL EASSERT
CALL 2
LABEL L151
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L153
CONST 0
CONST 110
GLOBAL EASSERT
CALL 2
LABEL L153
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -4
CONST 1
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L155
CONST 0
CONST 111
GLOBAL EASSERT
CALL 2
LABEL L155
! 		s := {0}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0});
CONST 1
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST 1
JEQ L157
CONST 0
CONST 112
GLOBAL EASSERT
CALL 2
LABEL L157
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := {0,31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -12
CONST -2147483647
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L159
CONST 0
CONST 114
GLOBAL EASSERT
CALL 2
LABEL L159
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); x := x + y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L161
CONST 0
CONST 115
GLOBAL EASSERT
CALL 2
LABEL L161
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); y := x + y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -4
CONST -2147483647
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L163
CONST 0
CONST 116
GLOBAL EASSERT
CALL 2
LABEL L163
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0,31});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483647
JEQ L165
CONST 0
CONST 117
GLOBAL EASSERT
CALL 2
LABEL L165
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := {0,31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -12
CONST -2147483647
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L167
CONST 0
CONST 119
GLOBAL EASSERT
CALL 2
LABEL L167
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x + y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L169
CONST 0
CONST 120
GLOBAL EASSERT
CALL 2
LABEL L169
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x + y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -4
CONST -2147483647
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L171
CONST 0
CONST 121
GLOBAL EASSERT
CALL 2
LABEL L171
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x + y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0,31});
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FPLUS
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483647
JEQ L173
CONST 0
CONST 122
GLOBAL EASSERT
CALL 2
LABEL L173
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
CONST 0
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L175
CONST 0
CONST 124
GLOBAL EASSERT
CALL 2
LABEL L175
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L177
CONST 0
CONST 125
GLOBAL EASSERT
CALL 2
LABEL L177
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -4
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L179
CONST 0
CONST 126
GLOBAL EASSERT
CALL 2
LABEL L179
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
LDLF -12
STLW -16
LDLW -16
JEQZ L181
CONST 0
CONST 127
GLOBAL EASSERT
CALL 2
LABEL L181
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
CONST 0
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L183
CONST 0
CONST 129
GLOBAL EASSERT
CALL 2
LABEL L183
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L185
CONST 0
CONST 130
GLOBAL EASSERT
CALL 2
LABEL L185
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x * y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -4
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L187
CONST 0
CONST 131
GLOBAL EASSERT
CALL 2
LABEL L187
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x * y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FTIMES
STLF -12
LDLF -12
STLW -16
LDLW -16
JEQZ L189
CONST 0
CONST 132
GLOBAL EASSERT
CALL 2
LABEL L189
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x / y; s := {}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FZCHECK 134
FDIV
STLF -12
CONST 0
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L191
CONST 0
CONST 134
GLOBAL EASSERT
CALL 2
LABEL L191
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); x := x / y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FZCHECK 135
FDIV
STLF -8
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L193
CONST 0
CONST 135
GLOBAL EASSERT
CALL 2
LABEL L193
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); y := x / y; s := {}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FZCHECK 136
FDIV
STLF -4
CONST 0
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L195
CONST 0
CONST 136
GLOBAL EASSERT
CALL 2
LABEL L195
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x / y; s := SYSTEM.VAL(SET, z); ASSERT(s = {});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FZCHECK 137
FDIV
STLF -12
LDLF -12
STLW -16
LDLW -16
JEQZ L197
CONST 0
CONST 137
GLOBAL EASSERT
CALL 2
LABEL L197
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {0}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
CONST 1
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L199
CONST 0
CONST 139
GLOBAL EASSERT
CALL 2
LABEL L199
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -8
CONST 1
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L201
CONST 0
CONST 140
GLOBAL EASSERT
CALL 2
LABEL L201
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {0}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -4
CONST 1
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L203
CONST 0
CONST 141
GLOBAL EASSERT
CALL 2
LABEL L203
! 		s := {31}; x := SYSTEM.VAL(REAL, s); s := {0,31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0});
CONST -2147483648
STLW -16
LDLW -16
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST 1
JEQ L205
CONST 0
CONST 142
GLOBAL EASSERT
CALL 2
LABEL L205
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := {0,31}; x := SYSTEM.VAL(REAL, s); ASSERT(z = x);
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
CONST -2147483647
STLW -16
LDLW -16
STLF -8
LDLF -12
LDLF -8
FJEQ L207
CONST 0
CONST 144
GLOBAL EASSERT
CALL 2
LABEL L207
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); x := x - y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(x = z);
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -8
CONST -2147483647
STLW -16
LDLW -16
STLF -12
LDLF -8
LDLF -12
FJEQ L209
CONST 0
CONST 145
GLOBAL EASSERT
CALL 2
LABEL L209
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); y := x - y; s := {0,31}; z := SYSTEM.VAL(REAL, s); ASSERT(y = z);
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -4
CONST -2147483647
STLW -16
LDLW -16
STLF -12
LDLF -4
LDLF -12
FJEQ L211
CONST 0
CONST 146
GLOBAL EASSERT
CALL 2
LABEL L211
! 		s := {0,31}; x := SYSTEM.VAL(REAL, s); s := {31}; y := SYSTEM.VAL(REAL, s); z := x - y; s := SYSTEM.VAL(SET, z); ASSERT(s = {0,31})
CONST -2147483647
STLW -16
LDLW -16
STLF -8
CONST -2147483648
STLW -16
LDLW -16
STLF -4
LDLF -8
LDLF -4
FMINUS
STLF -12
LDLF -12
STLW -16
LDLW -16
CONST -2147483647
JEQ L213
CONST 0
CONST 147
GLOBAL EASSERT
CALL 2
LABEL L213
RETURN
END

PROC tIEEE754.%main 0 3 0
! 	TestREAL;
GLOBAL tIEEE754.TestREAL
CALL 0
! 	Out.String('TestIEEE754: OK'); Out.Ln
CONST 16
GLOBAL tIEEE754.%1
GLOBAL Out.String
CALL 2
GLOBAL Out.Ln
CALL 0
RETURN
END

! String "TestIEEE754: OK"
DEFINE tIEEE754.%1
STRING 54657374494545453735343A204F4B00

! End of file
]]*)
