MODULE tGC407;

(*<<
42
42
53
>>*)

IMPORT Out, SYSTEM;

TYPE foo = POINTER TO RECORD a, b: INTEGER END;
TYPE bar = POINTER TO ARRAY OF INTEGER;
TYPE qux = ARRAY 1 OF INTEGER;

VAR p: foo; q: bar; r: POINTER TO qux;

(* VAR parameters should be included in the GC map of a procedure *)

PROCEDURE baz(VAR x: INTEGER);
BEGIN
  p := NIL; q := NIL;
  x := 42;
  SYSTEM.GC;
  Out.Int(x, 0); Out.Ln
END baz;

(* Read-only parameters also *)

PROCEDURE bop(CONST x: qux);
BEGIN
  r := NIL;
  SYSTEM.GC;
  Out.Int(x[0], 0); Out.Ln
END bop;

BEGIN
  NEW(p);
  baz(p.b);
  NEW(q, 20000);
  baz(q[19500]);

  NEW(r); r[0] := 53;
  bop(r^);
END tGC407.

(*[[
!! (SYMFILE #tGC407 STAMP #tGC407.%main 1 #tGC407.m)
!! (CHKSUM STAMP)
!! 
MODULE tGC407 STAMP 0
IMPORT Out STAMP
ENDHDR

PROC tGC407.baz 0 3 0x00100001
! PROCEDURE baz(VAR x: INTEGER);
!   p := NIL; q := NIL;
CONST 0
STGW tGC407.p
CONST 0
STGW tGC407.q
!   x := 42;
CONST 42
LDLW 12
STOREW
!   SYSTEM.GC;
GLOBAL SYSTEM.GC
CALL 0
!   Out.Int(x, 0); Out.Ln
CONST 0
LDLW 12
LOADW
GLOBAL Out.Int
CALL 2
GLOBAL Out.Ln
CALL 0
RETURN
END

PROC tGC407.bop 0 4 0x00100001
! PROCEDURE bop(CONST x: qux);
!   r := NIL;
CONST 0
STGW tGC407.r
!   SYSTEM.GC;
GLOBAL SYSTEM.GC
CALL 0
!   Out.Int(x[0], 0); Out.Ln
CONST 0
LDLW 12
LOADW
GLOBAL Out.Int
CALL 2
GLOBAL Out.Ln
CALL 0
RETURN
END

PROC tGC407.%main 0 5 0
!   NEW(p);
CONST 8
GLOBAL tGC407.%1
GLOBAL NEW
CALLW 2
STGW tGC407.p
!   baz(p.b);
LDGW tGC407.p
NCHECK 38
CONST 4
OFFSET
GLOBAL tGC407.baz
CALL 1
!   NEW(q, 20000);
CONST 20000
CONST 1
CONST 4
CONST 0
GLOBAL NEWFLEX
CALLW 4
STGW tGC407.q
!   baz(q[19500]);
LDGW tGC407.q
NCHECK 40
CONST 19500
DUP 1
LDNW -4
LDNW 4
BOUND 40
INDEXW
GLOBAL tGC407.baz
CALL 1
!   NEW(r); r[0] := 53;
CONST 4
CONST 0
GLOBAL NEW
CALLW 2
STGW tGC407.r
CONST 53
LDGW tGC407.r
NCHECK 42
STOREW
!   bop(r^);
LDGW tGC407.r
NCHECK 43
GLOBAL tGC407.bop
CALL 1
RETURN
END

! Global variables
GLOVAR tGC407.p 4
GLOVAR tGC407.q 4
GLOVAR tGC407.r 4

! Global pointer map
DEFINE tGC407.%gcmap
WORD GC_POINTER
WORD tGC407.p
WORD GC_POINTER
WORD tGC407.q
WORD GC_POINTER
WORD tGC407.r
WORD GC_END

! Descriptor for *anon*
DEFINE tGC407.%1
WORD 0
WORD 0
WORD tGC407.%1.%anc

DEFINE tGC407.%1.%anc
WORD tGC407.%1

! End of file
]]*)
