MODULE tRand64;

(* Check the first few random numbers are as expected *)

IMPORT Random, Out;

(* An implementation of the same generator as in Random.m, but using
   LONGINT. *)

CONST a = 48271; m = 2147483647;

VAR u: LONGINT;

PROCEDURE next(): INTEGER;
BEGIN
  u := (a * u) MOD m;
  RETURN SHORT(u)
END next;

VAR x, y, z: INTEGER; r: REAL;

BEGIN
  u := 31415926;

  (* Check that Random.Random agrees with our slow implementation *)
  FOR x := 1 TO 100 DO 
    y := Random.Random();
    z := next();
    Out.Int(y, 10); Out.Int(z, 12); Out.Ln;
    ASSERT(y = z)
  END;
  Out.Ln;

  (* A more thorough check *)
  FOR x := 1 TO 100000 DO ASSERT(Random.Random() = next()) END;

  (* Check results of Random.Uniform *)
  FOR x := 1 TO 20 DO
    r := Random.Uniform();
    Out.Real(r); Out.Ln;
    ASSERT((0.0 <= r) & (r < 1.0))
  END;
  Out.Ln;

  (* Check results of Random.Roll *)
  FOR x := 1 TO 20 DO
    y := Random.Roll(100000);
    Out.Int(y, 0); Out.Ln;
    ASSERT((0 <= y) & (y < 100000))
  END
END tRand64.

(*<<
 354709164   354709164
 278937913   278937913
2037015380  2037015380
1935662791  1935662791
1512587038  1512587038
1792396945  1792396945
 824278112   824278112
 151732736   151732736
1371663186  1371663186
 337847102   337847102
 226645324   226645324
1114736986  1114736986
2118791974  2118791974
 151204932   151204932
1663840066  1663840066
1482911733  1482911733
1707341839  1707341839
1117989450  1117989450
 204691840   204691840
 107548793   107548793
1019812104  1019812104
 582432003   582432003
1866793936  1866793936
1448772889  1448772889
 911160364   911160364
   9356437     9356437
 673004557   673004557
1617842778  1617842778
1645913683  1645913683
1594387681  1594387681
1168808365  1168808365
 858212931   858212931
1836841671  1836841671
 879483505   879483505
2091535959  2091535959
 883580478   883580478
 140540471   140540471
 128234768   128234768
 972615474   972615474
 834054740   834054740
1780424231  1780424231
 562501661   562501661
1881929110  1881929110
1894317063  1894317063
 725258813   725258813
 689748929   689748929
 284088671   284088671
1561151746  1561151746
1007274289  1007274289
 959952592   959952592
1616917113  1616917113
2060295055  2060295055
 387423688   387423688
1041245372  1041245372
 100593777   100593777
 301683700   301683700
 487272393   487272393
1884780559  1884780559
2097658334  2097658334
  64000817    64000817
1301953021  1301953021
 465347236   465347236
  97481336    97481336
 384899479   384899479
1601720612  1601720612
 801918911   801918911
1035015706  1035015706
  36096871    36096871
 822822324   822822324
 746350539   746350539
 901205997   901205997
 538443908   538443908
 231303427   231303427
 480243964   480243964
1917900526  1917900526
 956268376   956268376
2017269278  2017269278
 106828770   106828770
 623320223   623320223
2044589963  2044589963
 348655147   348655147
 103259298   103259298
 120029071   120029071
  12406635    12406635
1880224219  1880224219
1201902188  1201902188
 602309596   602309596
1452895430  1452895430
 194357804   194357804
1636986788  1636986788
 180968536   180968536
1716208907  1716208907
1790983125  1790983125
1297249596  1297249596
1059585643  1059585643
 640552654   640552654
 647611728   647611728
2093756556  2093756556
 699835915   699835915
1861685655  1861685655

0.226738
0.864667
0.354230
0.0490013
0.343383
0.464189
0.866463
0.0525061
0.521613
0.794844
0.932708
0.759232
0.900341
0.359484
0.670408
0.266190
0.281766
0.140336
0.168203
0.307730

42085
12368
41309
31702
21728
40110
84853
64529
97495
88840
95675
75056
34716
18121
51672
81322
7469
41220
49226
16046
>>*)

(*[[
!! SYMFILE #tRand64 STAMP #tRand64.%main 1
!! END STAMP
!! 
MODULE tRand64 STAMP 0
IMPORT Random STAMP
IMPORT Out STAMP
ENDHDR

PROC tRand64.next 0 16 0
! PROCEDURE next(): INTEGER;
!   u := (a * u) MOD m;
LDGQ tRand64.u
QCONST 48271
QTIMES
QCONST 2147483647
QMOD
STGQ tRand64.u
!   RETURN SHORT(u)
LDGQ tRand64.u
CONVQN
RETURNW
END

PROC tRand64.%main 0 16 0
!   u := 31415926;
QCONST 31415926
STGQ tRand64.u
!   FOR x := 1 TO 100 DO 
CONST 1
STGW tRand64.x
JUMP 2
LABEL 1
!     y := Random.Random();
CONST Random.Random
CALLW 0
STGW tRand64.y
!     z := next();
CONST tRand64.next
CALLW 0
STGW tRand64.z
!     Out.Int(y, 10); Out.Int(z, 12); Out.Ln;
CONST 10
LDGW tRand64.y
CONST Out.Int
CALL 2
CONST 12
LDGW tRand64.z
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!     ASSERT(y = z)
LDGW tRand64.y
LDGW tRand64.z
JEQ 3
CONST 0
EASSERT 30
LABEL 3
!   FOR x := 1 TO 100 DO 
LDGW tRand64.x
INC
STGW tRand64.x
LABEL 2
LDGW tRand64.x
CONST 100
JLEQ 1
!   Out.Ln;
CONST Out.Ln
CALL 0
!   FOR x := 1 TO 100000 DO ASSERT(Random.Random() = next()) END;
CONST 1
STGW tRand64.x
JUMP 5
LABEL 4
CONST Random.Random
CALLW 0
CONST tRand64.next
CALLW 0
JEQ 6
CONST 0
EASSERT 35
LABEL 6
LDGW tRand64.x
INC
STGW tRand64.x
LABEL 5
LDGW tRand64.x
CONST 100000
JLEQ 4
!   FOR x := 1 TO 20 DO
CONST 1
STGW tRand64.x
JUMP 8
LABEL 7
!     r := Random.Uniform();
CONST Random.Uniform
CALLF 0
STGF tRand64.r
!     Out.Real(r); Out.Ln;
LDGF tRand64.r
CONST Out.Real
CALL 1
CONST Out.Ln
CALL 0
!     ASSERT((0.0 <= r) & (r < 1.0))
LDGF tRand64.r
FCONST 0.
FJLT 10
LDGF tRand64.r
FCONST 1.
FJLT 9
LABEL 10
CONST 0
EASSERT 41
LABEL 9
!   FOR x := 1 TO 20 DO
LDGW tRand64.x
INC
STGW tRand64.x
LABEL 8
LDGW tRand64.x
CONST 20
JLEQ 7
!   Out.Ln;
CONST Out.Ln
CALL 0
!   FOR x := 1 TO 20 DO
CONST 1
STGW tRand64.x
JUMP 12
LABEL 11
!     y := Random.Roll(100000);
CONST 100000
CONST Random.Roll
CALLW 1
STGW tRand64.y
!     Out.Int(y, 0); Out.Ln;
CONST 0
LDGW tRand64.y
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!     ASSERT((0 <= y) & (y < 100000))
LDGW tRand64.y
JLTZ 14
LDGW tRand64.y
CONST 100000
JLT 13
LABEL 14
CONST 0
EASSERT 49
LABEL 13
!   FOR x := 1 TO 20 DO
LDGW tRand64.x
INC
STGW tRand64.x
LABEL 12
LDGW tRand64.x
CONST 20
JLEQ 11
RETURN
END

! Global variables
GLOBAL tRand64.u 8
GLOBAL tRand64.x 4
GLOBAL tRand64.y 4
GLOBAL tRand64.z 4
GLOBAL tRand64.r 4

! End of file
]]*)
