MODULE tDivMod;

(*<<
(-7) DIV 3 = -3
(-7) MOD 3 = 2
(-7) DIV (-3) = 2
(-7) MOD (-3) = -1
(-7) DIV 3 = -3
(-7) MOD 3 = 2
(-7) DIV (-3) = 2
(-7) MOD (-3) = -1
>>*)

IMPORT Out;

VAR failed: BOOLEAN;

PROCEDURE Test(b: INTEGER);
VAR a, q, r, q1, r1: INTEGER;
BEGIN
  FOR a := -10 TO 10 DO
    q := a DIV b; r := a MOD b;
    q1 := (-a) DIV (-b); r1 := (-a) MOD (-b);
    IF (q * b + r # a) OR (q1 * (-b) + r1 # -a) OR (q1 # q) THEN
      Out.Int(a, 0); Out.Char(' ');
      Out.Int(b, 0); Out.Char(' ');
      Out.Int(q, 0); Out.Char(' ');
      Out.Int(r, 0); Out.Char(' ');
      Out.Int(q1, 0); Out.Char(' ');
      Out.Int(r1, 0); Out.Ln;
      failed := TRUE
    END
  END
END Test;

VAR m, n: INTEGER;

BEGIN
  failed := FALSE;

  (* Run time *)
  m := -7; n := 3;
  Out.String("(-7) DIV 3 = "); Out.Int(m DIV n, 0); Out.Ln;
  Out.String("(-7) MOD 3 = "); Out.Int(m MOD n, 0); Out.Ln;
  Out.String("(-7) DIV (-3) = "); Out.Int(m DIV (-n), 0); Out.Ln;
  Out.String("(-7) MOD (-3) = "); Out.Int(m MOD (-n), 0); Out.Ln;

  (* Compile time *)
  Out.String("(-7) DIV 3 = "); Out.Int((-7) DIV 3, 0); Out.Ln;
  Out.String("(-7) MOD 3 = "); Out.Int((-7) MOD 3, 0); Out.Ln;
  Out.String("(-7) DIV (-3) = "); Out.Int((-7) DIV (-3), 0); Out.Ln;
  Out.String("(-7) MOD (-3) = "); Out.Int((-7) MOD (-3), 0); Out.Ln;

  FOR n := 1 TO 10 DO Test(n) END;
  IF failed THEN Out.String("Failed!"); Out.Ln END  
END tDivMod.

(*[[
!! SYMFILE #tDivMod STAMP #tDivMod.%main 1
!! END STAMP
!! 
MODULE tDivMod STAMP 0
IMPORT Out STAMP
ENDHDR

PROC tDivMod.Test 5 12 0
! PROCEDURE Test(b: INTEGER);
!   FOR a := -10 TO 10 DO
CONST -10
STLW -4
JUMP 7
LABEL 6
!     q := a DIV b; r := a MOD b;
LDLW -4
LDLW 12
ZCHECK 22
DIV
STLW -8
LDLW -4
LDLW 12
ZCHECK 22
MOD
STLW -12
!     q1 := (-a) DIV (-b); r1 := (-a) MOD (-b);
LDLW -4
UMINUS
LDLW 12
UMINUS
ZCHECK 23
DIV
STLW -16
LDLW -4
UMINUS
LDLW 12
UMINUS
ZCHECK 23
MOD
STLW -20
!     IF (q * b + r # a) OR (q1 * (-b) + r1 # -a) OR (q1 # q) THEN
LDLW -8
LDLW 12
TIMES
LDLW -12
PLUS
LDLW -4
JNEQ 10
LDLW -16
LDLW 12
UMINUS
TIMES
LDLW -20
PLUS
LDLW -4
UMINUS
JNEQ 10
LDLW -16
LDLW -8
JEQ 9
LABEL 10
!       Out.Int(a, 0); Out.Char(' ');
CONST 0
LDLW -4
CONST Out.Int
CALL 2
CONST 32
ALIGNC
CONST Out.Char
CALL 1
!       Out.Int(b, 0); Out.Char(' ');
CONST 0
LDLW 12
CONST Out.Int
CALL 2
CONST 32
ALIGNC
CONST Out.Char
CALL 1
!       Out.Int(q, 0); Out.Char(' ');
CONST 0
LDLW -8
CONST Out.Int
CALL 2
CONST 32
ALIGNC
CONST Out.Char
CALL 1
!       Out.Int(r, 0); Out.Char(' ');
CONST 0
LDLW -12
CONST Out.Int
CALL 2
CONST 32
ALIGNC
CONST Out.Char
CALL 1
!       Out.Int(q1, 0); Out.Char(' ');
CONST 0
LDLW -16
CONST Out.Int
CALL 2
CONST 32
ALIGNC
CONST Out.Char
CALL 1
!       Out.Int(r1, 0); Out.Ln;
CONST 0
LDLW -20
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!       failed := TRUE
CONST 1
STGC tDivMod.failed
LABEL 9
!   FOR a := -10 TO 10 DO
INCL -4
LABEL 7
LDLW -4
CONST 10
JLEQ 6
RETURN
END

PROC tDivMod.%main 0 12 0
!   failed := FALSE;
CONST 0
STGC tDivMod.failed
!   m := -7; n := 3;
CONST -7
STGW tDivMod.m
CONST 3
STGW tDivMod.n
!   Out.String("(-7) DIV 3 = "); Out.Int(m DIV n, 0); Out.Ln;
CONST 14
CONST tDivMod.%1
CONST Out.String
CALL 2
CONST 0
LDGW tDivMod.m
LDGW tDivMod.n
ZCHECK 43
DIV
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!   Out.String("(-7) MOD 3 = "); Out.Int(m MOD n, 0); Out.Ln;
CONST 14
CONST tDivMod.%2
CONST Out.String
CALL 2
CONST 0
LDGW tDivMod.m
LDGW tDivMod.n
ZCHECK 44
MOD
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!   Out.String("(-7) DIV (-3) = "); Out.Int(m DIV (-n), 0); Out.Ln;
CONST 17
CONST tDivMod.%3
CONST Out.String
CALL 2
CONST 0
LDGW tDivMod.m
LDGW tDivMod.n
UMINUS
ZCHECK 45
DIV
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!   Out.String("(-7) MOD (-3) = "); Out.Int(m MOD (-n), 0); Out.Ln;
CONST 17
CONST tDivMod.%4
CONST Out.String
CALL 2
CONST 0
LDGW tDivMod.m
LDGW tDivMod.n
UMINUS
ZCHECK 46
MOD
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!   Out.String("(-7) DIV 3 = "); Out.Int((-7) DIV 3, 0); Out.Ln;
CONST 14
CONST tDivMod.%1
CONST Out.String
CALL 2
CONST 0
CONST -3
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!   Out.String("(-7) MOD 3 = "); Out.Int((-7) MOD 3, 0); Out.Ln;
CONST 14
CONST tDivMod.%2
CONST Out.String
CALL 2
CONST 0
CONST 2
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!   Out.String("(-7) DIV (-3) = "); Out.Int((-7) DIV (-3), 0); Out.Ln;
CONST 17
CONST tDivMod.%3
CONST Out.String
CALL 2
CONST 0
CONST 2
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!   Out.String("(-7) MOD (-3) = "); Out.Int((-7) MOD (-3), 0); Out.Ln;
CONST 17
CONST tDivMod.%4
CONST Out.String
CALL 2
CONST 0
CONST -1
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
!   FOR n := 1 TO 10 DO Test(n) END;
CONST 1
STGW tDivMod.n
JUMP 12
LABEL 11
LDGW tDivMod.n
CONST tDivMod.Test
CALL 1
LDGW tDivMod.n
INC
STGW tDivMod.n
LABEL 12
LDGW tDivMod.n
CONST 10
JLEQ 11
!   IF failed THEN Out.String("Failed!"); Out.Ln END  
LDGC tDivMod.failed
JUMPF 14
CONST 8
CONST tDivMod.%5
CONST Out.String
CALL 2
CONST Out.Ln
CALL 0
LABEL 14
RETURN
END

! Global variables
GLOBAL tDivMod.failed 1
GLOBAL tDivMod.m 4
GLOBAL tDivMod.n 4

! String "(-7) DIV 3 = "
DEFINE tDivMod.%1
STRING 282D3729204449562033203D2000

! String "(-7) MOD 3 = "
DEFINE tDivMod.%2
STRING 282D3729204D4F442033203D2000

! String "(-7) DIV (-3) = "
DEFINE tDivMod.%3
STRING 282D37292044495620282D3329203D2000

! String "(-7) MOD (-3) = "
DEFINE tDivMod.%4
STRING 282D3729204D4F4420282D3329203D2000

! String "Failed!"
DEFINE tDivMod.%5
STRING 4661696C65642100

! End of file
]]*)

$Id: tDivMod.m 1647 2010-12-15 11:44:27Z mike $
