(*
 * debugger/debconf.ml.  Generated from debconf.ml.in by configure.
 *
 * debconf.ml.in
 * 
 * This file is part of the Oxford Oberon-2 compiler
 * Copyright (c) 2006 J. M. Spivey
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: config.ml.in 936 2009-01-27 10:53:04Z mike $
 *)

open Print

let use_inet = ("" <> "")
let lib_mods = 
  List.map Symtab.intern (Util.split_string "DynLink Files Conv In Out Err Args Bit Timer GC 	Strings Random Math MathL XYplane")
let mono_font = "Monospace 10"
let sans_font = "Sans 10"
let macos = ("" <> "")

let resource_dir = ref "/usr/lib/obc"

let pixbuf_resource f = 
  GdkPixbuf.from_file (!resource_dir ^ "/" ^ f)

let image_resource f =
  GMisc.image ~file:(!resource_dir ^ "/" ^ f) ()

let image_stock x =
  GMisc.image ~stock:x ()

let flash_msg = ref (fun msg -> ())

let flash_message fmt args = !flash_msg (sprintf fmt args)

let find_source m =
  Util.search_path (Symtab.extern m ^ ".m") !Config.libpath
