MODULE tFib;

(*<<
fib(10) = 55
>>*)

IMPORT Out, FibFun := xPrelude;

BEGIN
  VAR n, f: INTEGER;
  BEGIN
    n := 10;

    f := FibFun.Fib(n);

    Out.String(FibFun.PROC); Out.String("("); Out.Int(n, 0); 
    Out.String(") = "); Out.Int(f, 0); Out.Ln
  END
END tFib.

(*[[
!! SYMFILE #tFib STAMP #tFib.%main 1
!! END STAMP
!! 
MODULE tFib STAMP 0
IMPORT Out STAMP
IMPORT xPrelude STAMP
ENDHDR

PROC tFib.%main 2 12 0
!     n := 10;
CONST 10
STLW -4
!     f := FibFun.Fib(n);
LDLW -4
CONST xPrelude.Fib
CALLW 1
STLW -8
!     Out.String(FibFun.PROC); Out.String("("); Out.Int(n, 0); 
CONST 4
CONST xPrelude.%1
CONST Out.String
CALL 2
CONST 2
CONST tFib.%2
CONST Out.String
CALL 2
CONST 0
LDLW -4
CONST Out.Int
CALL 2
!     Out.String(") = "); Out.Int(f, 0); Out.Ln
CONST 5
CONST tFib.%1
CONST Out.String
CALL 2
CONST 0
LDLW -8
CONST Out.Int
CALL 2
CONST Out.Ln
CALL 0
RETURN
END

! String ") = "
DEFINE tFib.%1
STRING 29203D2000

! String "("
DEFINE tFib.%2
STRING 2800

! End of file
]]*)

$Id: tFib.m 1647 2010-12-15 11:44:27Z mike $
