/* vala-dmap-db.c generated by valac 0.40.7, the Vala compiler
 * generated from vala-dmap-db.vala, do not modify */

/*   FILE: vala-dmap-db.vala -- A DmapDb implementation in Vala
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 21 December 2010 
 *
 * Copyright (c) 2010 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <libdmapsharing/dmap.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_VALA_DMAP_DB (vala_dmap_db_get_type ())
#define VALA_DMAP_DB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_DMAP_DB, ValaDmapDb))
#define VALA_DMAP_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_DMAP_DB, ValaDmapDbClass))
#define IS_VALA_DMAP_DB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_DMAP_DB))
#define IS_VALA_DMAP_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_DMAP_DB))
#define VALA_DMAP_DB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_DMAP_DB, ValaDmapDbClass))

typedef struct _ValaDmapDb ValaDmapDb;
typedef struct _ValaDmapDbClass ValaDmapDbClass;
typedef struct _ValaDmapDbPrivate ValaDmapDbPrivate;
enum  {
	VALA_DMAP_DB_0_PROPERTY,
	VALA_DMAP_DB_NUM_PROPERTIES
};
static GParamSpec* vala_dmap_db_properties[VALA_DMAP_DB_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ValaDmapDb {
	GObject parent_instance;
	ValaDmapDbPrivate * priv;
};

struct _ValaDmapDbClass {
	GObjectClass parent_class;
};

struct _ValaDmapDbPrivate {
	GeeArrayList* db;
};


static gpointer vala_dmap_db_parent_class = NULL;
static DmapDbInterface * vala_dmap_db_dmap_db_parent_iface = NULL;

GType vala_dmap_db_get_type (void) G_GNUC_CONST;
#define VALA_DMAP_DB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VALA_DMAP_DB, ValaDmapDbPrivate))
static guint vala_dmap_db_real_add (DmapDb* base,
                             DmapRecord* record,
                             GError** error);
static guint vala_dmap_db_real_add_path (DmapDb* base,
                                  const gchar* path,
                                  GError** error);
static guint vala_dmap_db_real_add_with_id (DmapDb* base,
                                     DmapRecord* record,
                                     guint id,
                                     GError** error);
static gint64 vala_dmap_db_real_count (DmapDb* base);
static void vala_dmap_db_real_foreach (DmapDb* base,
                                GHFunc func,
                                gpointer func_target);
static DmapRecord* vala_dmap_db_real_lookup_by_id (DmapDb* base,
                                            guint id);
static guint vala_dmap_db_real_lookup_id_by_location (DmapDb* base,
                                               const gchar* location);
ValaDmapDb* vala_dmap_db_new (void);
ValaDmapDb* vala_dmap_db_construct (GType object_type);
static void vala_dmap_db_finalize (GObject * obj);


static guint
vala_dmap_db_real_add (DmapDb* base,
                       DmapRecord* record,
                       GError** error)
{
	ValaDmapDb * self;
	guint result = 0U;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (ValaDmapDb*) base;
	g_return_val_if_fail (record != NULL, 0U);
	_tmp0_ = self->priv->db;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (record, DMAP_TYPE_RECORD, DmapRecord));
	_tmp1_ = self->priv->db;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	result = (guint) _tmp3_;
	return result;
}


static guint
vala_dmap_db_real_add_path (DmapDb* base,
                            const gchar* path,
                            GError** error)
{
	ValaDmapDb * self;
	guint result = 0U;
	self = (ValaDmapDb*) base;
	g_return_val_if_fail (path != NULL, 0U);
	g_error ("vala-dmap-db.vala:35: add_path not implemented");
	return result;
}


static guint
vala_dmap_db_real_add_with_id (DmapDb* base,
                               DmapRecord* record,
                               guint id,
                               GError** error)
{
	ValaDmapDb * self;
	guint result = 0U;
	self = (ValaDmapDb*) base;
	g_return_val_if_fail (record != NULL, 0U);
	g_error ("vala-dmap-db.vala:39: add_with_id not implemented");
	return result;
}


static gint64
vala_dmap_db_real_count (DmapDb* base)
{
	ValaDmapDb * self;
	gint64 result = 0LL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (ValaDmapDb*) base;
	_tmp0_ = self->priv->db;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint64) _tmp2_;
	return result;
}


static void
vala_dmap_db_real_foreach (DmapDb* base,
                           GHFunc func,
                           gpointer func_target)
{
	ValaDmapDb * self;
	gint i = 0;
	self = (ValaDmapDb*) base;
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp2_;
			GeeArrayList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			void* _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = i;
			_tmp3_ = self->priv->db;
			_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			if (!(_tmp2_ < _tmp5_)) {
				break;
			}
			_tmp6_ = i;
			_tmp7_ = GINT_TO_POINTER (_tmp6_ + 1);
			_tmp8_ = self->priv->db;
			_tmp9_ = i;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			func (_tmp7_, (DmapRecord*) _tmp10_, func_target);
		}
	}
}


static DmapRecord*
vala_dmap_db_real_lookup_by_id (DmapDb* base,
                                guint id)
{
	ValaDmapDb * self;
	DmapRecord* result = NULL;
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	self = (ValaDmapDb*) base;
	_tmp0_ = self->priv->db;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, ((gint) id) - 1);
	result = (DmapRecord*) _tmp1_;
	return result;
}


static guint
vala_dmap_db_real_lookup_id_by_location (DmapDb* base,
                                         const gchar* location)
{
	ValaDmapDb * self;
	guint result = 0U;
	self = (ValaDmapDb*) base;
	g_return_val_if_fail (location != NULL, 0U);
	g_error ("vala-dmap-db.vala:63: lookup_id_by_location not implemented");
	return result;
}


ValaDmapDb*
vala_dmap_db_construct (GType object_type)
{
	ValaDmapDb * self = NULL;
	self = (ValaDmapDb*) g_object_new (object_type, NULL);
	return self;
}


ValaDmapDb*
vala_dmap_db_new (void)
{
	return vala_dmap_db_construct (TYPE_VALA_DMAP_DB);
}


static void
vala_dmap_db_class_init (ValaDmapDbClass * klass)
{
	vala_dmap_db_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaDmapDbPrivate));
	G_OBJECT_CLASS (klass)->finalize = vala_dmap_db_finalize;
}


static void
vala_dmap_db_dmap_db_interface_init (DmapDbInterface * iface)
{
	vala_dmap_db_dmap_db_parent_iface = g_type_interface_peek_parent (iface);
	iface->add = (guint (*) (DmapDb *, DmapRecord*, GError**)) vala_dmap_db_real_add;
	iface->add_path = (guint (*) (DmapDb *, const gchar*, GError**)) vala_dmap_db_real_add_path;
	iface->add_with_id = (guint (*) (DmapDb *, DmapRecord*, guint, GError**)) vala_dmap_db_real_add_with_id;
	iface->count = (gint64 (*) (DmapDb *)) vala_dmap_db_real_count;
	iface->foreach = (void (*) (DmapDb *, DmapIdRecordFunc, gpointer)) vala_dmap_db_real_foreach;
	iface->lookup_by_id = (DmapRecord* (*) (DmapDb *, guint)) vala_dmap_db_real_lookup_by_id;
	iface->lookup_id_by_location = (guint (*) (DmapDb *, const gchar*)) vala_dmap_db_real_lookup_id_by_location;
}


static void
vala_dmap_db_instance_init (ValaDmapDb * self)
{
	GeeArrayList* _tmp0_;
	self->priv = VALA_DMAP_DB_GET_PRIVATE (self);
	_tmp0_ = gee_array_list_new (DMAP_TYPE_RECORD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->db = _tmp0_;
}


static void
vala_dmap_db_finalize (GObject * obj)
{
	ValaDmapDb * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VALA_DMAP_DB, ValaDmapDb);
	_g_object_unref0 (self->priv->db);
	G_OBJECT_CLASS (vala_dmap_db_parent_class)->finalize (obj);
}


GType
vala_dmap_db_get_type (void)
{
	static volatile gsize vala_dmap_db_type_id__volatile = 0;
	if (g_once_init_enter (&vala_dmap_db_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDmapDbClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dmap_db_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDmapDb), 0, (GInstanceInitFunc) vala_dmap_db_instance_init, NULL };
		static const GInterfaceInfo dmap_db_info = { (GInterfaceInitFunc) vala_dmap_db_dmap_db_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_dmap_db_type_id;
		vala_dmap_db_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaDmapDb", &g_define_type_info, 0);
		g_type_add_interface_static (vala_dmap_db_type_id, DMAP_TYPE_DB, &dmap_db_info);
		g_once_init_leave (&vala_dmap_db_type_id__volatile, vala_dmap_db_type_id);
	}
	return vala_dmap_db_type_id__volatile;
}



