/* dpapview.c generated by valac 0.56.3, the Vala compiler
 * generated from dpapview.vala, do not modify */

/*   FILE: dpapviewer.vala -- View DPAP data
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 24 November 2010
 *
 * Copyright (c) 2010 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib-object.h>
#include <libdmapsharing/dmap.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>
#include <stdio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DPAP_VIEWER (dpap_viewer_get_type ())
#define DPAP_VIEWER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DPAP_VIEWER, DpapViewer))
#define DPAP_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DPAP_VIEWER, DpapViewerClass))
#define IS_DPAP_VIEWER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DPAP_VIEWER))
#define IS_DPAP_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DPAP_VIEWER))
#define DPAP_VIEWER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DPAP_VIEWER, DpapViewerClass))

typedef struct _DpapViewer DpapViewer;
typedef struct _DpapViewerClass DpapViewerClass;
typedef struct _DpapViewerPrivate DpapViewerPrivate;

#define TYPE_VALA_DMAP_DB (vala_dmap_db_get_type ())
#define VALA_DMAP_DB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_DMAP_DB, ValaDmapDb))
#define VALA_DMAP_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_DMAP_DB, ValaDmapDbClass))
#define IS_VALA_DMAP_DB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_DMAP_DB))
#define IS_VALA_DMAP_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_DMAP_DB))
#define VALA_DMAP_DB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_DMAP_DB, ValaDmapDbClass))

typedef struct _ValaDmapDb ValaDmapDb;
typedef struct _ValaDmapDbClass ValaDmapDbClass;

#define TYPE_VALA_IMAGE_RECORD_FACTORY (vala_image_record_factory_get_type ())
#define VALA_IMAGE_RECORD_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_IMAGE_RECORD_FACTORY, ValaImageRecordFactory))
#define VALA_IMAGE_RECORD_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_IMAGE_RECORD_FACTORY, ValaImageRecordFactoryClass))
#define IS_VALA_IMAGE_RECORD_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_IMAGE_RECORD_FACTORY))
#define IS_VALA_IMAGE_RECORD_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_IMAGE_RECORD_FACTORY))
#define VALA_IMAGE_RECORD_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_IMAGE_RECORD_FACTORY, ValaImageRecordFactoryClass))

typedef struct _ValaImageRecordFactory ValaImageRecordFactory;
typedef struct _ValaImageRecordFactoryClass ValaImageRecordFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_VALA_IMAGE_RECORD (vala_image_record_get_type ())
#define VALA_IMAGE_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_IMAGE_RECORD, ValaImageRecord))
#define VALA_IMAGE_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_IMAGE_RECORD, ValaImageRecordClass))
#define IS_VALA_IMAGE_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_IMAGE_RECORD))
#define IS_VALA_IMAGE_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_IMAGE_RECORD))
#define VALA_IMAGE_RECORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_IMAGE_RECORD, ValaImageRecordClass))

typedef struct _ValaImageRecord ValaImageRecord;
typedef struct _ValaImageRecordClass ValaImageRecordClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dpap_viewer_unref0(var) ((var == NULL) ? NULL : (var = (dpap_viewer_unref (var), NULL)))
typedef struct _ParamSpecDpapViewer ParamSpecDpapViewer;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DpapViewer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DpapViewerPrivate * priv;
};

struct _DpapViewerClass {
	GTypeClass parent_class;
	void (*finalize) (DpapViewer *self);
};

struct _DpapViewerPrivate {
	DmapMdnsBrowser* browser;
	DmapConnection* connection;
	GtkListStore* liststore;
	ValaDmapDb* db;
	ValaImageRecordFactory* factory;
};

struct _ParamSpecDpapViewer {
	GParamSpec parent_instance;
};

static gint DpapViewer_private_offset;
static gpointer dpap_viewer_parent_class = NULL;

VALA_EXTERN gpointer dpap_viewer_ref (gpointer instance);
VALA_EXTERN void dpap_viewer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_dpap_viewer (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_dpap_viewer (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_dpap_viewer (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_dpap_viewer (const GValue* value);
VALA_EXTERN GType dpap_viewer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DpapViewer, dpap_viewer_unref)
VALA_EXTERN GType vala_dmap_db_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaDmapDb, g_object_unref)
VALA_EXTERN GType vala_image_record_factory_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaImageRecordFactory, g_object_unref)
static void dpap_viewer_connected_cb (DpapViewer* self,
                               DmapConnection* connection,
                               gboolean _result_,
                               const gchar* reason);
static void __lambda4_ (DpapViewer* self,
                 guint k,
                 DmapRecord* v);
VALA_EXTERN GType vala_image_record_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaImageRecord, g_object_unref)
VALA_EXTERN GArray* vala_image_record_get_thumbnail (ValaImageRecord* self);
VALA_EXTERN const gchar* vala_image_record_get_filename (ValaImageRecord* self);
static void ___lambda4__dmap_id_record_func (guint id,
                                      DmapRecord* record,
                                      gpointer self);
VALA_EXTERN DpapViewer* dpap_viewer_new (GtkBuilder* builder,
                             GError** error);
VALA_EXTERN DpapViewer* dpap_viewer_construct (GType object_type,
                                   GtkBuilder* builder,
                                   GError** error);
VALA_EXTERN ValaDmapDb* vala_dmap_db_new (void);
VALA_EXTERN ValaDmapDb* vala_dmap_db_construct (GType object_type);
VALA_EXTERN ValaImageRecordFactory* vala_image_record_factory_new (void);
VALA_EXTERN ValaImageRecordFactory* vala_image_record_factory_construct (GType object_type);
static void __lambda5_ (DpapViewer* self,
                 DmapMdnsBrowser* browser,
                 DmapMdnsService* service);
static void _dpap_viewer_connected_cb_dmap_connection_func (DmapConnection* connection,
                                                     gboolean _result_,
                                                     const gchar* reason,
                                                     gpointer self);
static void ___lambda5__dmap_mdns_browser_service_added (DmapMdnsBrowser* _sender,
                                                  DmapMdnsService* service,
                                                  gpointer self);
static void dpap_viewer_finalize (DpapViewer * obj);
static GType dpap_viewer_get_type_once (void);
static gint _vala_main (gchar** args,
                 gint args_length1);

static inline gpointer
dpap_viewer_get_instance_private (DpapViewer* self)
{
	return G_STRUCT_MEMBER_P (self, DpapViewer_private_offset);
}

static void
__lambda4_ (DpapViewer* self,
            guint k,
            DmapRecord* v)
{
	GdkPixbuf* pixbuf = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp13_;
	GtkTreeIter _tmp14_ = {0};
	GtkListStore* _tmp15_;
	GtkTreeIter _tmp16_;
	GdkPixbuf* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (v != NULL);
	pixbuf = NULL;
	_tmp0_ = vala_image_record_get_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (v, TYPE_VALA_IMAGE_RECORD, ValaImageRecord));
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gchar* path = NULL;
		gint fd = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_;
		const gchar* _tmp4_;
		GArray* _tmp5_;
		GArray* _tmp6_;
		gpointer* _tmp7_;
		gint _tmp7__length1;
		GdkPixbuf* _tmp8_ = NULL;
		const gchar* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		const gchar* _tmp12_;
		_tmp3_ = g_file_open_tmp ("dpapview.XXXXXX", &_tmp2_, &_inner_error0_);
		_g_free0 (path);
		path = _tmp2_;
		fd = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = path;
		_tmp5_ = vala_image_record_get_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (v, TYPE_VALA_IMAGE_RECORD, ValaImageRecord));
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->data;
		_tmp7__length1 = _tmp6_->len;
		g_file_set_contents (_tmp4_, (const char*) ((guint8*) _tmp7_), (gsize) _tmp7__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		close (fd);
		_tmp9_ = path;
		_tmp10_ = gdk_pixbuf_new_from_file (_tmp9_, &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp11_;
		_tmp12_ = path;
		g_unlink (_tmp12_);
		_g_object_unref0 (_tmp8_);
		_g_free0 (path);
	}
	_tmp13_ = self->priv->liststore;
	gtk_list_store_append (_tmp13_, &_tmp14_);
	iter = _tmp14_;
	_tmp15_ = self->priv->liststore;
	_tmp16_ = iter;
	_tmp17_ = pixbuf;
	_tmp18_ = vala_image_record_get_filename (G_TYPE_CHECK_INSTANCE_CAST (v, TYPE_VALA_IMAGE_RECORD, ValaImageRecord));
	_tmp19_ = _tmp18_;
	gtk_list_store_set (_tmp15_, &_tmp16_, 0, _tmp17_, 1, _tmp19_, -1);
	_g_object_unref0 (pixbuf);
}

static void
___lambda4__dmap_id_record_func (guint id,
                                 DmapRecord* record,
                                 gpointer self)
{
	__lambda4_ ((DpapViewer*) self, id, record);
}

static void
dpap_viewer_connected_cb (DpapViewer* self,
                          DmapConnection* connection,
                          gboolean _result_,
                          const gchar* reason)
{
	ValaDmapDb* _tmp0_;
	ValaDmapDb* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	_tmp0_ = self->priv->db;
	g_debug ("%" G_GINT64_FORMAT " entries\n", dmap_db_count ((DmapDb*) _tmp0_));
	_tmp1_ = self->priv->db;
	dmap_db_foreach ((DmapDb*) _tmp1_, ___lambda4__dmap_id_record_func, self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_dpap_viewer_connected_cb_dmap_connection_func (DmapConnection* connection,
                                                gboolean _result_,
                                                const gchar* reason,
                                                gpointer self)
{
	dpap_viewer_connected_cb ((DpapViewer*) self, connection, _result_, reason);
}

static void
__lambda5_ (DpapViewer* self,
            DmapMdnsBrowser* browser,
            DmapMdnsService* service)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	ValaDmapDb* _tmp8_;
	ValaImageRecordFactory* _tmp9_;
	DmapImageConnection* _tmp10_;
	DmapConnection* _tmp11_;
	g_return_if_fail (browser != NULL);
	g_return_if_fail (service != NULL);
	g_object_get (service, "service-name", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_object_get (service, "host", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	g_object_get (service, "port", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->db;
	_tmp9_ = self->priv->factory;
	_tmp10_ = dmap_image_connection_new (_tmp2_, _tmp5_, _tmp7_, (DmapDb*) _tmp8_, (DmapRecordFactory*) _tmp9_);
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, DMAP_TYPE_CONNECTION, DmapConnection);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	_tmp11_ = self->priv->connection;
	dmap_connection_start (_tmp11_, _dpap_viewer_connected_cb_dmap_connection_func, self);
}

static void
___lambda5__dmap_mdns_browser_service_added (DmapMdnsBrowser* _sender,
                                             DmapMdnsService* service,
                                             gpointer self)
{
	__lambda5_ ((DpapViewer*) self, _sender, service);
}

DpapViewer*
dpap_viewer_construct (GType object_type,
                       GtkBuilder* builder,
                       GError** error)
{
	DpapViewer* self = NULL;
	GtkWidget* widget = NULL;
	GObject* _tmp0_;
	GtkWidget* _tmp1_;
	GtkIconView* iconview = NULL;
	GObject* _tmp2_;
	GtkIconView* _tmp3_;
	GObject* _tmp4_;
	GtkListStore* _tmp5_;
	ValaDmapDb* _tmp6_;
	ValaImageRecordFactory* _tmp7_;
	DmapMdnsBrowser* _tmp8_;
	DmapMdnsBrowser* _tmp9_;
	DmapMdnsBrowser* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (builder != NULL, NULL);
	self = (DpapViewer*) g_type_create_instance (object_type);
	gtk_builder_connect_signals (builder, self);
	_tmp0_ = gtk_builder_get_object (builder, "window");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp0_) : NULL);
	widget = _tmp1_;
	_tmp2_ = gtk_builder_get_object (builder, "iconview");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_icon_view_get_type ()) ? ((GtkIconView*) _tmp2_) : NULL);
	iconview = _tmp3_;
	_tmp4_ = gtk_builder_get_object (builder, "liststore");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_list_store_get_type ()) ? ((GtkListStore*) _tmp4_) : NULL);
	_g_object_unref0 (self->priv->liststore);
	self->priv->liststore = _tmp5_;
	_tmp6_ = vala_dmap_db_new ();
	_g_object_unref0 (self->priv->db);
	self->priv->db = _tmp6_;
	_tmp7_ = vala_image_record_factory_new ();
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp7_;
	gtk_icon_view_set_pixbuf_column (iconview, 0);
	gtk_icon_view_set_text_column (iconview, 1);
	gtk_widget_show_all (widget);
	_tmp8_ = dmap_mdns_browser_new (DMAP_MDNS_SERVICE_TYPE_DPAP);
	_g_object_unref0 (self->priv->browser);
	self->priv->browser = _tmp8_;
	_tmp9_ = self->priv->browser;
	g_signal_connect (_tmp9_, "service-added", (GCallback) ___lambda5__dmap_mdns_browser_service_added, self);
	_tmp10_ = self->priv->browser;
	dmap_mdns_browser_start (_tmp10_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (iconview);
		_g_object_unref0 (widget);
		_dpap_viewer_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (iconview);
	_g_object_unref0 (widget);
	return self;
}

DpapViewer*
dpap_viewer_new (GtkBuilder* builder,
                 GError** error)
{
	return dpap_viewer_construct (TYPE_DPAP_VIEWER, builder, error);
}

static void
value_dpap_viewer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_dpap_viewer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		dpap_viewer_unref (value->data[0].v_pointer);
	}
}

static void
value_dpap_viewer_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dpap_viewer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_dpap_viewer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_dpap_viewer_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DpapViewer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dpap_viewer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_dpap_viewer_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	DpapViewer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dpap_viewer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_dpap_viewer (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecDpapViewer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DPAP_VIEWER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_dpap_viewer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DPAP_VIEWER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_dpap_viewer (GValue* value,
                       gpointer v_object)
{
	DpapViewer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DPAP_VIEWER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DPAP_VIEWER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dpap_viewer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dpap_viewer_unref (old);
	}
}

void
value_take_dpap_viewer (GValue* value,
                        gpointer v_object)
{
	DpapViewer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DPAP_VIEWER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DPAP_VIEWER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dpap_viewer_unref (old);
	}
}

static void
dpap_viewer_class_init (DpapViewerClass * klass,
                        gpointer klass_data)
{
	dpap_viewer_parent_class = g_type_class_peek_parent (klass);
	((DpapViewerClass *) klass)->finalize = dpap_viewer_finalize;
	g_type_class_adjust_private_offset (klass, &DpapViewer_private_offset);
}

static void
dpap_viewer_instance_init (DpapViewer * self,
                           gpointer klass)
{
	self->priv = dpap_viewer_get_instance_private (self);
	self->ref_count = 1;
}

static void
dpap_viewer_finalize (DpapViewer * obj)
{
	DpapViewer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DPAP_VIEWER, DpapViewer);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->browser);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->liststore);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
}

static GType
dpap_viewer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_dpap_viewer_init, value_dpap_viewer_free_value, value_dpap_viewer_copy_value, value_dpap_viewer_peek_pointer, "p", value_dpap_viewer_collect_value, "p", value_dpap_viewer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DpapViewerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dpap_viewer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DpapViewer), 0, (GInstanceInitFunc) dpap_viewer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType dpap_viewer_type_id;
	dpap_viewer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DpapViewer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	DpapViewer_private_offset = g_type_add_instance_private (dpap_viewer_type_id, sizeof (DpapViewerPrivate));
	return dpap_viewer_type_id;
}

GType
dpap_viewer_get_type (void)
{
	static volatile gsize dpap_viewer_type_id__once = 0;
	if (g_once_init_enter (&dpap_viewer_type_id__once)) {
		GType dpap_viewer_type_id;
		dpap_viewer_type_id = dpap_viewer_get_type_once ();
		g_once_init_leave (&dpap_viewer_type_id__once, dpap_viewer_type_id);
	}
	return dpap_viewer_type_id__once;
}

gpointer
dpap_viewer_ref (gpointer instance)
{
	DpapViewer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
dpap_viewer_unref (gpointer instance)
{
	DpapViewer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DPAP_VIEWER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	GError* _inner_error0_ = NULL;
	gint result;
	gtk_init ((gint*) (&args_length1), &args);
	{
		GtkBuilder* builder = NULL;
		GtkBuilder* _tmp0_;
		GtkBuilder* _tmp1_;
		DpapViewer* dpapviewer = NULL;
		GtkBuilder* _tmp2_;
		DpapViewer* _tmp3_;
		_tmp0_ = gtk_builder_new ();
		builder = _tmp0_;
		_tmp1_ = builder;
		gtk_builder_add_from_file (_tmp1_, "tests/dpapview.ui", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (builder);
			goto __catch0_g_error;
		}
		_tmp2_ = builder;
		_tmp3_ = dpap_viewer_new (_tmp2_, &_inner_error0_);
		dpapviewer = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (builder);
			goto __catch0_g_error;
		}
		gtk_main ();
		_dpap_viewer_unref0 (dpapviewer);
		_g_object_unref0 (builder);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "Error: %s\n", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = 0;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

