#ifndef FRAME_API__RESAMPLE_CMD_HH
#define FRAME_API__RESAMPLE_CMD_HH

#include "filters/Resample.hh"

#include "framecpp/FrAdcData.hh"
#include "framecpp/FrProcData.hh"
#include "framecpp/FrVect.hh"

#include "genericAPI/swigexception.hh"

#include "util.hh"

//!exc: SwigException   
Filters::ResampleBase* createResampleState(const int q,
					   const FrameCPP::FrAdcData* const adc);
//!exc: SwigException      
Filters::ResampleBase* createResampleState(const int q,
					   const FrameCPP::FrProcData* const proc);   
//!exc: SwigException   
void destructResampleState(Filters::ResampleBase* const r);

//!exc: SwigException      
REAL_8 resampleDelay( const FrameCPP::FrProcData* const proc,
		      const Filters::ResampleBase* const r );

//!exc: SwigException   
FrameCPP::FrProcData* resampleAdcData( const FrameCPP::FrAdcData* const adc,
                                     Filters::ResampleBase* const r );
//!exc: SwigException   
FrameCPP::FrProcData* resampleProcData( const FrameCPP::FrProcData* const proc,
                                     Filters::ResampleBase* const r );
   
#endif /* FRAME_API__RESAMPLE_CMD_HH */
