#ifndef RDS_STREAM_MEMORY_HH
#define RDS_STREAM_MEMORY_HH

#include <vector>

#include "RDSStream.hh"

class RDSStreamMemory
  : public RDSStream
{
public:
  typedef std::vector< frame_h_type >	result_type;

  RDSStreamMemory( );

  virtual void Abandon( );

  virtual void Close( bool Final );

  virtual bool Next( const LDASTools::AL::GPSTime& FrameStart,
		     const REAL_8 Dt,
		     INT_4U& FramesPerStream );

  result_type Results( ) const;

  virtual void Write( frame_h_type Frame,
		      compression_scheme_type CompressionScheme,
		      compression_level_type CompressionLevel,
		      chkSum_type CheckSum );

protected:
private:
  result_type	m_frames;
};

inline RDSStreamMemory::result_type RDSStreamMemory::
Results( ) const
{
  return m_frames;
}

#endif /* RDS_STREAM_MEMORY_HH */
