#include <unistd.h>

#include "framecpp/Common/MD5Sum.hh"

#include "genericAPI/Logging.hh"

#include "RDSStreamFileResample.hh"

using FrameCPP::Common::MD5Sum;
using FrameAPI::LogMD5Sum;

RDSStreamFileResample::
RDSStreamFileResample( const std::string& OutputDirectory,
		       const std::string& OutputType,
		       const std::string& MD5SumOutputDirectory )
  : RDSStreamFileReduce( OutputDirectory,
			 OutputType,
			 MD5SumOutputDirectory )
{
}

RDSStreamFileResample::
~RDSStreamFileResample( )
{
}

#if 0
bool RDSStreamFileResample::
Next( const LDASTools::AL::GPSTime& FrameStart,
      const REAL_8 Dt,
      INT_4U& FramesPerStream )
{
  QUEUE_LOG_MESSAGE( "RDSStreamFileResample::Next:"
		     << " FrameStart: " << FrameStart
		     << " Dt: " << Dt
		     << " FramesPerStream: " << FramesPerStream,
		     MT_DEBUG,
		     30,
		     "RDSStreamFileResample::Next",
		     "RDS::Resample" );
  bool	retval = false;

  if ( ( fileWriter( ).get( ) == (FileWriter*)NULL ) &&
       ( FrameStart >= m_user_start ) &&
       ( ( FrameStart + Dt ) <= m_user_stop ) )
  {
    openFrameFile( generateTmpOutputName( FrameStart.GetSeconds( ) ) );
    m_frame_file_start = FrameStart.GetSeconds( );
    m_frame_file_deltaT = 0;
    const INT_4U max( INT_4U( ( m_user_stop.GetSeconds( ) - FrameStart.GetSeconds( ) ) / Dt ) );
    if ( FramesPerStream > max )
    {
      FramesPerStream = max;
    }
    retval = true;
  }
  else if ( m_current_file_writer )
  {
    FramesPerStream = 1;
  }
  return retval;
}

void RDSStreamFileResample::
Write( frame_h_type Frame,
       compression_scheme_type CompressionScheme,
       compression_level_type CompressionLevel,
       chkSum_type CheckSum )
{
  static const char* caller = "RDSStreamFileResample::Write";

  QUEUE_LOG_MESSAGE( "CompressionScheme: " << CompressionScheme
		     << " CompressionLevel: " << CompressionLevel,
		     MT_DEBUG, 30,
		     caller,
		     "RDSResample" );
  if ( m_frame_file_deltaT == 0 )
  {
    m_frame_file_start = Frame->GetGTime( ).GetSeconds( );
  }
  m_frame_file_deltaT += Frame->GetDt( );
  file_writer_type	active =
    ( fileWriter( )
      ? fileWriter( )
      : m_current_file_writer );

  active->WriteFrame( Frame,
		      CompressionScheme,
		      CompressionLevel,
		      CheckSum );
}
#endif /* 0 */

#if 0
void RDSStreamFileResample::
Close( bool Final )
{
  const char* caller = "RDSStreamFileResample::Close";

  QUEUE_LOG_MESSAGE( "ENTRY: Final: " << Final,
		     MT_DEBUG, 30,
		     caller,
		     "RDSResample" );
  //---------------------------------------------------------------------
  // If this is the final closing, then shut things down
  //---------------------------------------------------------------------
  if ( Final )
  {
    QUEUE_LOG_MESSAGE( "RDSStreamFileResample::Close:"
		       << " abandoning filename: " << RDSStreamFileReduce::currentFilename( ),
		       MT_DEBUG, 30,
		       caller,
		       "RDSResample" );
    close_frame_file( );
  }
  else
  {
    //------------------------------------------------------------------
    // Store and advance filename information
    //------------------------------------------------------------------
    QUEUE_LOG_MESSAGE( "before m_current_filename: " << m_current_filename,
		       MT_DEBUG, 30,
		       caller,
		       "RDSResample" );
    m_current_filename
      = RDSStreamFileReduce::currentFilename( );

    QUEUE_LOG_MESSAGE( "RDSStreamFileResample::Close:"
		       << " before m_current_filename: " << m_current_filename,
		       MT_DEBUG, 30,
		       caller,
		       "RDSResample" );
    m_current_file_writer = fileWriter( );
    fileWriter( ).reset( );
  }

  QUEUE_LOG_MESSAGE( "EXIT",
		     MT_DEBUG, 30,
		     caller,
		     "RDSResample" );
}
#endif /* 0 */

void RDSStreamFileResample::
closeFrameFile( const std::string& Filename,
		bool Final )
{
  static const char* caller = "RDSStreamFileResample::closeFrameFile";

  QUEUE_LOG_MESSAGE( "RDSStreamFileResample::closeFrameFile:"
		     << " Filename: " << Filename
		     << " Final: " << Final,
		     MT_DEBUG, 30,
		     caller,
		     "RDSResample" );
  if ( Final )
  {
    close_frame_file( );
  }
  else
  {
    m_current_filename = Filename;
    m_current_file_writer = fileWriter( );
    fileWriter( ).reset( );
  }
}

void RDSStreamFileResample::
close_frame_file( )
{
  static const char* caller = "RDSStreamFileResample::close_frame_file";

  
  QUEUE_LOG_MESSAGE( "ENTRY",
		     MT_DEBUG, 30,
		     caller,
		     "RDSResample" );
  QUEUE_LOG_MESSAGE( "RDSStreamFileResample::close_frame_file:",
		     MT_DEBUG, 30,
		     caller,
		     "RDSResample" );
#if 0
  m_is_last_frame_of_file = m_options.FramesPerFile( );
#endif /* 0 */
  //--------------------------------------------------------------------
  // Write out the privious file
  //--------------------------------------------------------------------
#if WIP   
  closeFrameWriter( m_current_file_writer,
		    RDSStreamFileReduce::currentFilename( ) );
#endif /* WIP */
  if ( m_current_file_writer )
  {
    //-----------------------------------------------------------------
    // Close output frame file, renaming it in accordance to
    //   user's request
    //-----------------------------------------------------------------
    m_current_file_writer->Close( );

    std::string	tmpfile( m_current_file_writer->GetFilename( ) );
    bool		calculating_md5_sum = true;
    MD5Sum	 	md5;

    QUEUE_LOG_MESSAGE( "tmpfile: " << tmpfile
		       << " m_current_filename: " << m_current_filename
		       << " m_frame_file_deltaT: " << m_frame_file_deltaT,
		       MT_DEBUG, 30,
		       caller,
		       "RDSResample" );
    try
    {
      md5 = m_current_file_writer->GetMD5Sum( );
      md5.Finalize( );
    }
    catch( ... )
    {
      calculating_md5_sum = false;
    }

    // m_current_file_writer->SetMD5Sum( md5 );  // :TODO: Why is this needed?

    m_current_file_writer.reset( (FileWriter*)NULL );	// Free up resourses

    if ( m_current_filename.length( ) > 0 )
    {
      if ( m_frame_file_deltaT <= 0 )
      {
	//-----------------------------------------------------------
	// No frames were written to this file. Just remove it.
	//-----------------------------------------------------------
	if ( ! tmpfile.empty( ) )
	{
	  unlink( tmpfile.c_str( ) );	// Remove the tempory file
	  tmpfile.clear( );
	}
	return;
      }
      try
      {
	ensureNoSuchFile( m_current_filename );
      }
      catch( ... )
      {
	if ( ! tmpfile.empty( ) )
	{
	  unlink( tmpfile.c_str( ) );	// Remove the tempory file
	  tmpfile.clear( );
	}
	throw;
      }
      if ( rename( tmpfile.c_str( ), m_current_filename.c_str( ) ) != 0 )
      {
	//-----------------------------------------------------------
	// Cannot rename the file. Must remove the temporary file
	//   and inform the call about the error.
	//-----------------------------------------------------------
	unlink( tmpfile.c_str( ) );	// Remove the tempory file
	std::ostringstream	oss;
	    
	oss << "Unable to rename:" 
	    << " old: " << tmpfile
	    << " new: " << m_current_filename
	    << " perror: " << strerror( errno );
	tmpfile.clear( );
	throw std::runtime_error( oss.str( ) );
      }
      tmpfile.clear( );
      if ( calculating_md5_sum )
      {
	LogMD5Sum( m_current_filename, md5,
		   m_md5sum_output_directory );
      }
      appendOutputFrameFilename( m_current_filename );

    } // if ( m_current_filename.length( ) > 0 )
    if ( ! tmpfile.empty( ) )
    {
      unlink( tmpfile.c_str( ) );	// Remove the tempory file
      tmpfile.clear( );
    }
    QUEUE_LOG_MESSAGE( "before m_current_filename: " << m_current_filename,
		       MT_DEBUG, 30,
		       caller,
		       "RDSResample" );
    m_current_filename
      = RDSStreamFileReduce::currentFilename( );
    QUEUE_LOG_MESSAGE( "m_current_filename: " << m_current_filename,
		       MT_DEBUG, 30,
		       caller,
		       "RDSResample" );
    m_frame_file_deltaT = 0;		// Reset
  } // if ( m_current_file_writer )
  QUEUE_LOG_MESSAGE( "EXIT",
		     MT_DEBUG, 30,
		     caller,
		     "RDSResample" );
}
