#ifndef RDS_STREAM_FILE_REDUCE_HH
#define RDS_STREAM_FILE_REDUCE_HH

#include "RDSStreamFile.hh"

class RDSStreamFileReduce
  : public RDSStreamFile
{
public:
  RDSStreamFileReduce( const std::string& OutputDirectory,
			 const std::string& OutputType,
			 const std::string& MD5SumOutputDirectory );

  virtual bool Next( const LDASTools::AL::GPSTime& FrameStart,
		     const REAL_8 Dt,
		     INT_4U& FramesPerStream );

  virtual void Write( frame_h_type Frame,
		      compression_scheme_type CompressionScheme,
		      compression_level_type CompressionLevel,
		      chkSum_type CheckSum );
protected:

  virtual void closeFrameFile( const std::string& Filename,
			       bool Final );

protected:
  const std::string& currentFilename( ) const;

private:
  LDASTools::AL::GPSTime	m_frame_file_start_time;
#if 0
  bool			m_is_last_frame_of_file;
#endif /* 0 */
  std::string		m_current_filename;
  file_writer_type	m_current_file_writer;

  void close_frame_file( );
};

inline const std::string& RDSStreamFileReduce::
currentFilename( ) const
{
  return m_current_filename;
}
#endif /* RDS_STREAM_FILE_REDUCE_HH */
