#ifndef RDS_STREAM_HH
#define RDS_STREAM_HH

#include "ldastoolsal/types.hh"

#include "framecpp/Common/FrameStream.hh"
#include "framecpp/FrameH.hh"

class RDSStream
{
public:
  typedef INT_2U compression_scheme_type;
  typedef INT_2U compression_level_type;

  typedef LDASTools::AL::SharedPtr< FrameCPP::FrameH >	frame_h_type;
  typedef FrameCPP::Common::OFrameStream::chkSum_type	chkSum_type;

  virtual ~RDSStream( );

  virtual void Abandon( ) = 0;

  virtual void Close( bool Final ) = 0;

  void IFOList( const std::string& IFOList );

  const std::string& IFOList( ) const;

  virtual bool Next( const LDASTools::AL::GPSTime& StartTime,
		     REAL_8 Dt,
		     INT_4U& FramesPerStream ) = 0;

  void UserRange( INT_4U Start, INT_4U End );

  virtual void Write( frame_h_type Frame,
		      compression_scheme_type CompressionScheme,
		      compression_level_type CompressionLevel,
		      chkSum_type CheckSum ) = 0;
protected:
  LDASTools::AL::GPSTime	m_user_start;
  LDASTools::AL::GPSTime	m_user_stop;

  void ensureNoSuchFile( const std::string& Filename ) const;

private:
  std::string		m_ifo_list;

};

inline RDSStream::
~RDSStream( )
{
}

inline const std::string& RDSStream::
IFOList( ) const
{
  return m_ifo_list;
}

inline void RDSStream::
IFOList( const std::string& IFOList )
{
  m_ifo_list = IFOList;
}


inline void RDSStream::
UserRange( INT_4U Start, INT_4U End )
{
  m_user_start = LDASTools::AL::GPSTime( Start, 0 );
  m_user_stop = LDASTools::AL::GPSTime( End, 0 );
}

#endif /* RDS_STREAM_HH */
