/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.forgejo.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import feign.form.FormData;
import java.util.List;
import java.util.Map;
import org.jreleaser.sdk.forgejo.api.Asset;
import org.jreleaser.sdk.forgejo.api.Attachment;
import org.jreleaser.sdk.forgejo.api.Branch;
import org.jreleaser.sdk.forgejo.api.Issue;
import org.jreleaser.sdk.forgejo.api.Label;
import org.jreleaser.sdk.forgejo.api.Milestone;
import org.jreleaser.sdk.forgejo.api.Organization;
import org.jreleaser.sdk.forgejo.api.Release;
import org.jreleaser.sdk.forgejo.api.Repository;
import org.jreleaser.sdk.forgejo.api.SearchUser;
import org.jreleaser.sdk.forgejo.internal.Page;

public interface ForgejoAPI {
    @RequestLine(value="GET /repos/{owner}/{repo}")
    public Repository getRepository(@Param(value="owner") String var1, @Param(value="repo") String var2);

    @RequestLine(value="GET /orgs/{org}")
    public Organization getOrganization(@Param(value="org") String var1);

    @RequestLine(value="POST /orgs/{org}/repos")
    @Headers(value={"Content-Type: application/json"})
    public Repository createRepository(Map<String, Object> var1, @Param(value="org") String var2);

    @RequestLine(value="POST /user/repos")
    @Headers(value={"Content-Type: application/json"})
    public Repository createRepository(Map<String, Object> var1);

    @RequestLine(value="GET /repos/{owner}/{repo}/releases/tags/{tag}")
    public Release getReleaseByTagName(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="tag") String var3);

    @RequestLine(value="DELETE /repos/{owner}/{repo}/releases/{id}")
    public void deleteRelease(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="id") Integer var3);

    @RequestLine(value="DELETE /repos/{owner}/{repo}/releases/tags/{tag}")
    public void deleteTag(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="tag") String var3);

    @RequestLine(value="POST /repos/{owner}/{repo}/releases")
    @Headers(value={"Content-Type: application/json"})
    public Release createRelease(Release var1, @Param(value="owner") String var2, @Param(value="repo") String var3);

    @RequestLine(value="PATCH /repos/{owner}/{repo}/releases/{id}")
    @Headers(value={"Content-Type: application/json"})
    public void updateRelease(Release var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="id") Integer var4);

    @RequestLine(value="POST /repos/{owner}/{repo}/releases/{id}/assets")
    @Headers(value={"Content-Type: multipart/form-data"})
    public Attachment uploadAsset(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="id") Integer var3, @Param(value="attachment") FormData var4);

    @RequestLine(value="GET /repos/{owner}/{repo}/milestones/{milestoneName}")
    public Milestone findMilestoneByTitle(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="milestoneName") String var3);

    @RequestLine(value="PATCH /repos/{owner}/{repo}/milestones/{id}")
    @Headers(value={"Content-Type: application/json"})
    public void updateMilestone(Map<String, Object> var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="id") Integer var4);

    @RequestLine(value="GET /users/search")
    @Headers(value={"Content-Type: application/json"})
    public SearchUser searchUser(@QueryMap Map<String, String> var1);

    @RequestLine(value="GET /repos/{owner}/{repo}/releases")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<Release>> listReleases(@Param(value="owner") String var1, @Param(value="repo") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="GET /repos/{owner}/{repo}/branches")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<Branch>> listBranches(@Param(value="owner") String var1, @Param(value="repo") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="GET /repos/{owner}/{repo}/releases/{releaseId}/assets")
    @Headers(value={"Content-Type: application/json"})
    public List<Asset> listAssets(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="releaseId") Integer var3);

    @RequestLine(value="DELETE /repos/{owner}/{repo}/releases/{releaseId}/assets/{assetId}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteAsset(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="releaseId") Integer var3, @Param(value="assetId") Integer var4);

    @RequestLine(value="GET /repos/{owner}/{repo}/labels")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<Label>> listLabels(@Param(value="owner") String var1, @Param(value="repo") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="POST /repos/{owner}/{repo}/labels")
    @Headers(value={"Content-Type: application/json"})
    public Label createLabel(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="name") String var3, @Param(value="color") String var4, @Param(value="description") String var5);

    @RequestLine(value="GET /repos/{owner}/{repo}/issues/{issueNumber}")
    @Headers(value={"Content-Type: application/json"})
    public Issue findIssue(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="issueNumber") int var3);

    @RequestLine(value="POST /repos/{owner}/{repo}/issues/{issueNumber}/labels")
    @Headers(value={"Content-Type: application/json"})
    public void labelIssue(Map<String, List<Integer>> var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="issueNumber") Integer var4);

    @RequestLine(value="POST /repos/{owner}/{repo}/issues/{issueNumber}/comments")
    @Headers(value={"Content-Type: application/json"})
    public void commentIssue(Map<String, String> var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="issueNumber") Integer var4);

    @RequestLine(value="PATCH /repos/{owner}/{repo}/issues/{index}")
    @Headers(value={"Content-Type: application/json"})
    public void updateIssue(Map<String, Object> var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="index") Integer var4);

    @RequestLine(value="DELETE /packages/{owner}/{type}/{name}/{version}")
    public void deletePackage(@Param(value="owner") String var1, @Param(value="type") String var2, @Param(value="name") String var3, @Param(value="version") String var4);
}

