/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.io.File;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.AbstractScalarValueSnapshot;
import org.jspecify.annotations.Nullable;

public class FileValueSnapshot
extends AbstractScalarValueSnapshot<String>
implements Isolatable<File> {
    public FileValueSnapshot(File value) {
        super(value.getPath());
    }

    public FileValueSnapshot(String value) {
        super(value);
    }

    public ValueSnapshot asSnapshot() {
        return this;
    }

    public File isolate() {
        return new File((String)this.getValue());
    }

    public <S> @Nullable S coerce(Class<S> type) {
        if (type.isAssignableFrom(File.class)) {
            return type.cast(this.isolate());
        }
        return null;
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        File file;
        if (value instanceof File && (file = (File)value).getPath().equals(this.getValue())) {
            return this;
        }
        return snapshotter.snapshot(value);
    }

    public void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.getValue());
    }
}

