/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.SharedPsiElementImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.templateLanguages.OuterLanguageElement;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class MultiplePsiFilesPerDocumentFileViewProvider
extends AbstractFileViewProvider {
    protected final ConcurrentMap<Language, PsiFileImpl> myRoots;
    private MultiplePsiFilesPerDocumentFileViewProvider myOriginal;

    public MultiplePsiFilesPerDocumentFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(1);
        }
        super(manager, virtualFile, eventSystemEnabled);
        this.myRoots = new ConcurrentHashMap<Language, PsiFileImpl>(1, 0.75f, 1);
    }

    @Override
    @NotNull
    public abstract Language getBaseLanguage();

    @Override
    @NotNull
    public List<PsiFile> getAllFiles() {
        ArrayList<PsiFile> roots = new ArrayList<PsiFile>();
        for (Language language2 : this.getLanguages()) {
            PsiFile psi = this.getPsi(language2);
            if (psi == null) continue;
            roots.add(psi);
        }
        PsiFile base = this.getPsi(this.getBaseLanguage());
        if (!roots.isEmpty() && roots.get(0) != base) {
            roots.remove(base);
            roots.add(0, base);
        }
        ArrayList<PsiFile> arrayList = roots;
        if (arrayList == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected final void removeFile(@NotNull Language language2) {
        PsiFileImpl file;
        if (language2 == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(3);
        }
        if ((file = (PsiFileImpl)this.myRoots.remove(language2)) != null) {
            file.markInvalidated();
        }
    }

    @Override
    protected PsiFile getPsiInner(@NotNull Language target) {
        PsiFileImpl file;
        if (target == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(4);
        }
        if ((file = (PsiFileImpl)this.myRoots.get(target)) == null) {
            PsiFile originalFile;
            if (!this.shouldCreatePsi()) {
                return null;
            }
            if (target != this.getBaseLanguage() && !this.getLanguages().contains(target)) {
                return null;
            }
            file = this.createPsiFileImpl(target);
            if (file == null) {
                return null;
            }
            if (this.myOriginal != null && (originalFile = this.myOriginal.getPsi(target)) != null) {
                file.setOriginalFile(originalFile);
            }
            file = ConcurrencyUtil.cacheOrGet(this.myRoots, target, file);
        }
        return file;
    }

    @Nullable
    protected PsiFileImpl createPsiFileImpl(@NotNull Language target) {
        if (target == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(5);
        }
        return (PsiFileImpl)this.createFile(target);
    }

    @Override
    public final PsiFile getCachedPsi(@NotNull Language target) {
        if (target == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(6);
        }
        return (PsiFile)this.myRoots.get(target);
    }

    @Override
    @NotNull
    public final List<PsiFile> getCachedPsiFiles() {
        List<PsiFile> list = ContainerUtil.mapNotNull(this.myRoots.keySet(), this::getCachedPsi);
        if (list == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public final List<FileASTNode> getKnownTreeRoots() {
        ArrayList<FileASTNode> files2 = new ArrayList<FileASTNode>(this.myRoots.size());
        for (PsiFileImpl file : this.myRoots.values()) {
            FileASTNode treeElement = file.getNodeIfLoaded();
            if (treeElement == null) continue;
            files2.add(treeElement);
        }
        ArrayList<FileASTNode> arrayList = files2;
        if (arrayList == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @TestOnly
    public void checkAllTreesEqual() {
        Collection roots = this.myRoots.values();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.getManager().getProject());
        documentManager.commitAllDocuments();
        for (PsiFile root : roots) {
            Document document = documentManager.getDocument(root);
            assert (document != null);
            PsiDocumentManagerBase.checkConsistency(root, document);
            assert (root.getText().equals(document.getText()));
        }
    }

    @Override
    @NotNull
    public final MultiplePsiFilesPerDocumentFileViewProvider createCopy(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(9);
        }
        MultiplePsiFilesPerDocumentFileViewProvider copy = this.cloneInner(fileCopy);
        copy.myOriginal = this.myOriginal == null ? this : this.myOriginal;
        MultiplePsiFilesPerDocumentFileViewProvider multiplePsiFilesPerDocumentFileViewProvider = copy;
        if (multiplePsiFilesPerDocumentFileViewProvider == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(10);
        }
        return multiplePsiFilesPerDocumentFileViewProvider;
    }

    @NotNull
    protected abstract MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile var1);

    @Override
    @Nullable
    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(11);
        }
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement ret = null;
        for (Language language2 : this.getLanguages()) {
            PsiFile psiRoot;
            PsiElement psiElement;
            if (!ReflectionUtil.isAssignable(lang, language2.getClass()) || lang.equals(Language.class) && !this.getLanguages().contains(language2) || (psiElement = MultiplePsiFilesPerDocumentFileViewProvider.findElementAt(psiRoot = this.getPsi(language2), offset)) == null || psiElement instanceof OuterLanguageElement || ret != null && psiRoot == mainRoot) continue;
            ret = psiElement;
        }
        return ret;
    }

    @Override
    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, Language.class);
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset) {
        TextRange minRange = new TextRange(0, this.getContents().length());
        PsiReference ret = null;
        for (Language language2 : this.getLanguages()) {
            TextRange textRange;
            PsiFile psiRoot = this.getPsi(language2);
            PsiReference reference2 = SharedPsiElementImplUtil.findReferenceAt(psiRoot, offset, language2);
            if (reference2 == null || !minRange.contains(textRange = reference2.getRangeInElement().shiftRight(reference2.getElement().getTextRange().getStartOffset())) || textRange.contains(minRange) && ret != null) continue;
            minRange = textRange;
            ret = reference2;
        }
        return ret;
    }

    @Override
    public void contentsSynchronized() {
        Set<Language> languages = this.getLanguages();
        Iterator iterator2 = this.myRoots.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (languages.contains(entry.getKey())) continue;
            PsiFileImpl file = (PsiFileImpl)entry.getValue();
            iterator2.remove();
            DebugUtil.performPsiModification(this.getClass().getName() + " root change", () -> file.markInvalidated());
        }
        super.contentsSynchronized();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPsiFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownTreeRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPsiInner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFileImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsi";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

