#include "traversalhppgenvisitor.h"
#include "visitor.h"
#include "ast.h"
#include "strutils.h"

#include <assert.h>

using std::vector;
using std::string;


traversalhppgenvisitor::traversalhppgenvisitor(const char* filename, const char* visitorFilename)
	: m_out(filename)
{
	m_out << "#ifndef PROCESSOR_HPP_\n";
	m_out << "#define PROCESSOR_HPP_\n";
	m_out << "#include \"" << visitorFilename << "\"\n\n";
	m_out << "class Processor : public Visitor\n";
	m_out << "{\n";
	m_out << "	public:\n";
	m_out << "		virtual ~Processor() {}\n";

}

traversalhppgenvisitor::~traversalhppgenvisitor()
{
	m_out << "};\n\n";
	m_out << "#endif\n";
}

void traversalhppgenvisitor::visit_lhs_IDENT_SEPARATOR(const lhs_IDENT_SEPARATOR *plhs_IDENT_SEPARATOR)
{
	m_rulename = *plhs_IDENT_SEPARATOR->m_IDENT;
}

void traversalhppgenvisitor::visit_grammar_grammar_production(const grammar_grammar_production *pgrammar_grammar_production)
{
	if (pgrammar_grammar_production->m_grammar.get() != 0)
	{
		pgrammar_grammar_production->m_grammar->accept(this);
	}
	pgrammar_grammar_production->m_production->accept(this);

}

void traversalhppgenvisitor::visit_grammar_grammar_COMMENT(const grammar_grammar_COMMENT *pgrammar_grammar_COMMENT)
{
	return;
}

void traversalhppgenvisitor::visit_expression_base_OPT(const expression_base_OPT *pexpression_base_OPT)
{
	// not yet implemented
	assert(0);
	pexpression_base_OPT->m_base->accept(this);
}

void traversalhppgenvisitor::visit_production_lhs_expressionListList_TERMINATOR(const production_lhs_expressionListList_TERMINATOR *pproduction_lhs_expressionListList_TERMINATOR)
{
	pproduction_lhs_expressionListList_TERMINATOR->m_lhs->accept(this);

	// m_rulename has already been set
	if (!isSpecialRule(m_rulename))
	{
		if (pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList.get() != 0)
		{
			if (pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->size() > 1)
			{
				for (vector<vector<expression*>*>::const_iterator i = pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->begin();
					  i != pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->end();
					  ++i)
				{
					if (*i)
					{
						// first build up the classname and gather the idents
						string classname = m_rulename;
						vector<string> idents;
						for (vector<expression*>::const_iterator j = (*i)->begin();
							  j != (*i)->end();
							  ++j)
						{
							m_literal.erase();
							m_ident.erase();
							(*j)->accept(this);
							if (m_ident.length() > 0)
							{
								classname += "_" + m_ident;
								idents.push_back(m_ident);
							}
						}
						if ((*i)->size() == 0)
						{
							classname += "_empty";
						}

						m_out << "		virtual void visit_" << classname << "(\n";
						m_out << "			const " << classname << "* p" << classname << "\n";
						m_out << "			);\n\n";

					}
				}
			}
			else
			{
				string classname = m_rulename;
				m_out << "		virtual void visit_" << classname << "(\n";
				m_out << "			const " << classname << "* p" << classname << "\n";
				m_out << "			);\n\n";
			}
		}
	}
}

void traversalhppgenvisitor::visit_expression_base_PLUS(const expression_base_PLUS *pexpression_base_PLUS)
{
	// not yet implemented
	assert(0);
	pexpression_base_PLUS->m_base->accept(this);
}

void traversalhppgenvisitor::visit_expression_base(const expression_base *pexpression_base)
{
	pexpression_base->m_base->accept(this);
}

void traversalhppgenvisitor::visit_base_LITERAL(const base_LITERAL *pbase_LITERAL)
{
	m_literal = *pbase_LITERAL->m_LITERAL;
}

void traversalhppgenvisitor::visit_expression_base_STAR(const expression_base_STAR *pexpression_base_STAR)
{
	// not yet implemented
	assert(0);
	pexpression_base_STAR->m_base->accept(this);
}

void traversalhppgenvisitor::visit_base_LPAREN_expressionList_RPAREN(const base_LPAREN_expressionList_RPAREN *pbase_LPAREN_expressionList_RPAREN)
{
	// not yet implemented
	assert(0);
	if (pbase_LPAREN_expressionList_RPAREN->m_expressionList.get() != 0)
	{
		for (vector<expression*>::const_iterator i = pbase_LPAREN_expressionList_RPAREN->m_expressionList->begin();
			  i != pbase_LPAREN_expressionList_RPAREN->m_expressionList->end();
			  ++i)
		{
			(*i)->accept(this);
		}
	}
}

void traversalhppgenvisitor::visit_expression_COMMENT(const expression_COMMENT *pexpression_COMMENT)
{
	// not yet implemented
	assert(0);
	(void)pexpression_COMMENT->m_COMMENT;
}

void traversalhppgenvisitor::visit_alternation_expression_OR_expression(const alternation_expression_OR_expression *palternation_expression_OR_expression)
{
	// not yet implemented
	assert(0);
	palternation_expression_OR_expression->m_expression1->accept(this);
	palternation_expression_OR_expression->m_expression2->accept(this);
}

void traversalhppgenvisitor::visit_base_IDENT(const base_IDENT *pbase_IDENT)
{
	m_ident = *pbase_IDENT->m_IDENT;
}

void traversalhppgenvisitor::visit_base_LPAREN_alternation_RPAREN(const base_LPAREN_alternation_RPAREN *pbase_LPAREN_alternation_RPAREN)
{
	// not yet implemented
	assert(0);
	pbase_LPAREN_alternation_RPAREN->m_alternation->accept(this);
}

void traversalhppgenvisitor::visit_alternation_alternation_OR_expression(const alternation_alternation_OR_expression *palternation_alternation_OR_expression)
{
	// not yet implemented
	assert(0);
	palternation_alternation_OR_expression->m_alternation->accept(this);
	palternation_alternation_OR_expression->m_expression->accept(this);
}


