#ifndef TRAVERSAL_CPP_GEN_VISITOR_H_
#define TRAVERSAL_CPP_GEN_VISITOR_H_

#include "visitor.h"
#include <fstream>
#include <string>
#include <map>
#include <vector>

class traversalcppgenvisitor : public visitor
{
public:
	traversalcppgenvisitor(const char* filename, const char* traversalhppFilename, const char* astFilename);
	virtual ~traversalcppgenvisitor();

	virtual void visit_lhs_IDENT_SEPARATOR(const lhs_IDENT_SEPARATOR *plhs_IDENT_SEPARATOR) ;
	virtual void visit_grammar_grammar_production(const grammar_grammar_production *pgrammar_grammar_production) ;
	virtual void visit_grammar_grammar_COMMENT(const grammar_grammar_COMMENT *pgrammar_grammar_COMMENT) ;
	virtual void visit_expression_base_OPT(const expression_base_OPT *pexpression_base_OPT) ;
	virtual void visit_production_lhs_expressionListList_TERMINATOR(const production_lhs_expressionListList_TERMINATOR *pproduction_lhs_expressionListList_TERMINATOR) ;
	virtual void visit_expression_base_PLUS(const expression_base_PLUS *pexpression_base_PLUS) ;
	virtual void visit_expression_base(const expression_base *pexpression_base) ;
	virtual void visit_base_LITERAL(const base_LITERAL *pbase_LITERAL) ;
	virtual void visit_expression_base_STAR(const expression_base_STAR *pexpression_base_STAR) ;
	virtual void visit_base_LPAREN_expressionList_RPAREN(const base_LPAREN_expressionList_RPAREN *pbase_LPAREN_expressionList_RPAREN) ;
	virtual void visit_expression_COMMENT(const expression_COMMENT *pexpression_COMMENT) ;
	virtual void visit_alternation_expression_OR_expression(const alternation_expression_OR_expression *palternation_expression_OR_expression) ;
	virtual void visit_base_IDENT(const base_IDENT *pbase_IDENT) ;
	virtual void visit_base_LPAREN_alternation_RPAREN(const base_LPAREN_alternation_RPAREN *pbase_LPAREN_alternation_RPAREN) ;
	virtual void visit_alternation_alternation_OR_expression(const alternation_alternation_OR_expression *palternation_alternation_OR_expression) ;

private:
	std::ofstream m_out;
	std::string m_rulename;
	std::string m_ident;
	std::string m_literal;
	
	std::map<std::string, std::string> m_listTypes;

	std::string getListType(const std::string& rule)
	{
		return m_listTypes[rule];
	}

	void addListType(const std::string& rule, const std::string& type)
	{
		m_listTypes[rule] = type;
	}

	void write_traversal(std::vector<std::vector<expression*>*>::const_iterator rule);
	void write_traversal_simple(std::vector<std::vector<expression*>*>::const_iterator rule);
	void write_traversal_common(const std::string& classname, const std::vector<std::string>& idents);
};


#endif

