#ifndef TEST2VISITOR_H_HPP_GUARD_
#define TEST2VISITOR_H_HPP_GUARD_
#include <string>

class grammar;
class grammar_production;
class grammar_grammar_production;
class grammar_grammar_COMMENT;
class production;
class lhs;
class expression;
class expression_base;
class expression_base_OPT;
class expression_base_STAR;
class expression_base_PLUS;
class expression_COMMENT;
class base;
class base_LITERAL;
class base_IDENT;
class base_LPAREN_expressionList_RPAREN;
class base_LPAREN_alternation_RPAREN;
class alternation;
class alternation_expression_OR_expression;
class alternation_alternation_OR_expression;


class Visitor
{
	public:
		virtual ~Visitor() {}
		virtual void visit_grammar_production(
			const grammar_production* pgrammar_production
			) = 0;

		virtual void visit_grammar_grammar_production(
			const grammar_grammar_production* pgrammar_grammar_production
			) = 0;

		virtual void visit_grammar_grammar_COMMENT(
			const grammar_grammar_COMMENT* pgrammar_grammar_COMMENT
			) = 0;

		virtual void visit_production(
			const production* pproduction
			) = 0;

		virtual void visit_lhs(
			const lhs* plhs
			) = 0;

		virtual void visit_expression_base(
			const expression_base* pexpression_base
			) = 0;

		virtual void visit_expression_base_OPT(
			const expression_base_OPT* pexpression_base_OPT
			) = 0;

		virtual void visit_expression_base_STAR(
			const expression_base_STAR* pexpression_base_STAR
			) = 0;

		virtual void visit_expression_base_PLUS(
			const expression_base_PLUS* pexpression_base_PLUS
			) = 0;

		virtual void visit_expression_COMMENT(
			const expression_COMMENT* pexpression_COMMENT
			) = 0;

		virtual void visit_base_LITERAL(
			const base_LITERAL* pbase_LITERAL
			) = 0;

		virtual void visit_base_IDENT(
			const base_IDENT* pbase_IDENT
			) = 0;

		virtual void visit_base_LPAREN_expressionList_RPAREN(
			const base_LPAREN_expressionList_RPAREN* pbase_LPAREN_expressionList_RPAREN
			) = 0;

		virtual void visit_base_LPAREN_alternation_RPAREN(
			const base_LPAREN_alternation_RPAREN* pbase_LPAREN_alternation_RPAREN
			) = 0;

		virtual void visit_alternation_expression_OR_expression(
			const alternation_expression_OR_expression* palternation_expression_OR_expression
			) = 0;

		virtual void visit_alternation_alternation_OR_expression(
			const alternation_alternation_OR_expression* palternation_alternation_OR_expression
			) = 0;

};

#endif
