#include "test2tv.h"
#include "test2ast.h"

void Processor::visit_grammar_production(
	const grammar_production* pgrammar_production
	)
{
	pgrammar_production->m_pproduction1->accept(this);
}

void Processor::visit_grammar_grammar_production(
	const grammar_grammar_production* pgrammar_grammar_production
	)
{
	pgrammar_grammar_production->m_pgrammar1->accept(this);
	pgrammar_grammar_production->m_pproduction2->accept(this);
}

void Processor::visit_grammar_grammar_COMMENT(
	const grammar_grammar_COMMENT* pgrammar_grammar_COMMENT
	)
{
	pgrammar_grammar_COMMENT->m_pgrammar1->accept(this);
}

void Processor::visit_production(
	const production* pproduction
	)
{
	pproduction->m_plhs1->accept(this);
	for (std::list<*>::const_iterator i = pproduction->m_pexpressionListList2->begin();
		i != pproduction->m_pexpressionListList2->end();
		++i )
	{
		(*i)->accept(this);
	}
}

void Processor::visit_lhs(
	const lhs* plhs
	)
{
	(void)plhs;
}

void Processor::visit_expression_base(
	const expression_base* pexpression_base
	)
{
	pexpression_base->m_pbase1->accept(this);
}

void Processor::visit_expression_base_OPT(
	const expression_base_OPT* pexpression_base_OPT
	)
{
	pexpression_base_OPT->m_pbase1->accept(this);
}

void Processor::visit_expression_base_STAR(
	const expression_base_STAR* pexpression_base_STAR
	)
{
	pexpression_base_STAR->m_pbase1->accept(this);
}

void Processor::visit_expression_base_PLUS(
	const expression_base_PLUS* pexpression_base_PLUS
	)
{
	pexpression_base_PLUS->m_pbase1->accept(this);
}

void Processor::visit_expression_COMMENT(
	const expression_COMMENT* pexpression_COMMENT
	)
{
	(void)pexpression_COMMENT;
}

void Processor::visit_base_LITERAL(
	const base_LITERAL* pbase_LITERAL
	)
{
	(void)pbase_LITERAL;
}

void Processor::visit_base_IDENT(
	const base_IDENT* pbase_IDENT
	)
{
	(void)pbase_IDENT;
}

void Processor::visit_base_LPAREN_expressionList_RPAREN(
	const base_LPAREN_expressionList_RPAREN* pbase_LPAREN_expressionList_RPAREN
	)
{
	for (std::list<*>::const_iterator i = pbase_LPAREN_expressionList_RPAREN->m_pexpressionList2->begin();
		i != pbase_LPAREN_expressionList_RPAREN->m_pexpressionList2->end();
		++i )
	{
		(*i)->accept(this);
	}
}

void Processor::visit_base_LPAREN_alternation_RPAREN(
	const base_LPAREN_alternation_RPAREN* pbase_LPAREN_alternation_RPAREN
	)
{
	pbase_LPAREN_alternation_RPAREN->m_palternation2->accept(this);
}

void Processor::visit_alternation_expression_OR_expression(
	const alternation_expression_OR_expression* palternation_expression_OR_expression
	)
{
	palternation_expression_OR_expression->m_pexpression1->accept(this);
	palternation_expression_OR_expression->m_pexpression3->accept(this);
}

void Processor::visit_alternation_alternation_OR_expression(
	const alternation_alternation_OR_expression* palternation_alternation_OR_expression
	)
{
	palternation_alternation_OR_expression->m_palternation1->accept(this);
	palternation_alternation_OR_expression->m_pexpression3->accept(this);
}

