#include "astgenvisitor2.h"
#include "ast.h"
#include "strutils.h"

#include <assert.h>
#include <iostream>

using std::vector;
using std::string;
using std::ios;

astgenvisitor2::astgenvisitor2(const char* filename, const char* visitorFilename)
	: m_out(filename, ios::app)
{
}

astgenvisitor2::~astgenvisitor2()
{
	m_out << "#endif\n";
}

void astgenvisitor2::visit_lhs_IDENT_SEPARATOR(const lhs_IDENT_SEPARATOR *plhs_IDENT_SEPARATOR)
{
	m_rulename = *plhs_IDENT_SEPARATOR->m_IDENT;
}

void astgenvisitor2::visit_grammar_grammar_production(const grammar_grammar_production *pgrammar_grammar_production)
{
	if (pgrammar_grammar_production->m_grammar.get() != 0) // start of the AST
	{
		pgrammar_grammar_production->m_grammar->accept(this);
	}
	pgrammar_grammar_production->m_production->accept(this);

}

void astgenvisitor2::visit_grammar_grammar_COMMENT(const grammar_grammar_COMMENT *pgrammar_grammar_COMMENT)
{
	return;
}

void astgenvisitor2::visit_expression_base_OPT(const expression_base_OPT *pexpression_base_OPT)
{
	// not yet implemented
	assert(0);
	pexpression_base_OPT->m_base->accept(this);
}

void astgenvisitor2::visit_production_lhs_expressionListList_TERMINATOR(const production_lhs_expressionListList_TERMINATOR *pproduction_lhs_expressionListList_TERMINATOR)
{

	pproduction_lhs_expressionListList_TERMINATOR->m_lhs->accept(this);
	// m_rulename is now set (by astgenvisitor2::visit_lhs_IDENT_SEPARATOR
	if (!beginsWithStr(m_rulename))
	{
		if (pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList.get() != 0)
		{
			if (pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->size() > 1)
			{
				if (!endsWithList(m_rulename))
				{
					for (vector<vector<expression*>*>::const_iterator i = pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->begin();
						  i != pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->end();
						  ++i)
					{
						if (*i)
						{
							write_destructor(i, false);
						}
					}
				}
			}
			else
			{
				write_destructor(pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->begin(), true);
			}
		}
	}
}

string astgenvisitor2::create_class_name(const vector<vector<expression*>*>::const_iterator i, vector<string>& idents)
{
	// first build up the classname and gather the idents
	string classname = m_rulename;
	for (vector<expression*>::const_iterator j = (*i)->begin();
		  j != (*i)->end();
		  ++j)
	{
		m_literal.erase();
		m_ident.erase();
		(*j)->accept(this);
		if (m_ident.length() > 0)
		{
			classname += "_" + m_ident;
			idents.push_back(m_ident);
		}
	}
	if ((*i)->size() == 0)
	{
		classname += "_empty";
	}

	return classname;
}

void astgenvisitor2::write_destructor(const vector<vector<expression*>*>::const_iterator i, bool simple)
{
	// first build up the classname and gather the idents
	vector<string> idents;
	string classname;
	if (simple)
	{
		create_class_name(i, idents);
		classname = m_rulename;
	}
	else
		classname = create_class_name(i, idents);

	// write out the destructor
	m_out << "inline " << classname << "::~" << classname << "()\n";
	m_out << "{\n";
	int arg_num = 1;
	for (vector<string>::const_iterator i = idents.begin(); i!= idents.end(); ++i, ++arg_num)
	{
		if (endsWithList(*i))
		{
			m_out << "\twhile(!m_p" << *i << arg_num << "->empty())\n";
			m_out << "\t{\n";
			m_out << "\t\tdelete m_p" << *i << arg_num << "->front();\n";
			m_out << "\t\tm_p" << *i << arg_num << "->pop_front();\n";
			m_out << "\t}\n";
		}
		m_out << "\tdelete m_p" << *i << arg_num << ";\n";
	}
	m_out << "}\n\n";
}

void astgenvisitor2::visit_expression_base_PLUS(const expression_base_PLUS *pexpression_base_PLUS)
{
	// not yet implemented
	assert(0);
	pexpression_base_PLUS->m_base->accept(this);
}

void astgenvisitor2::visit_expression_base(const expression_base *pexpression_base)
{
	pexpression_base->m_base->accept(this);
}

void astgenvisitor2::visit_base_LITERAL(const base_LITERAL *pbase_LITERAL)
{
	m_literal = *pbase_LITERAL->m_LITERAL;
}

void astgenvisitor2::visit_expression_base_STAR(const expression_base_STAR *pexpression_base_STAR)
{
	// not yet implemented
	assert(0);
	pexpression_base_STAR->m_base->accept(this);
}

void astgenvisitor2::visit_base_LPAREN_expressionList_RPAREN(const base_LPAREN_expressionList_RPAREN *pbase_LPAREN_expressionList_RPAREN)
{
	// not yet implemented
	assert(0);
	if (pbase_LPAREN_expressionList_RPAREN->m_expressionList.get() != 0)
	{
		for (vector<expression*>::const_iterator i = pbase_LPAREN_expressionList_RPAREN->m_expressionList->begin();
			  i != pbase_LPAREN_expressionList_RPAREN->m_expressionList->end();
			  ++i)
		{
			(*i)->accept(this);
		}
	}
}

void astgenvisitor2::visit_expression_COMMENT(const expression_COMMENT *pexpression_COMMENT)
{
	// not yet implemented
	assert(0);
	(void)pexpression_COMMENT->m_COMMENT;
}

void astgenvisitor2::visit_alternation_expression_OR_expression(const alternation_expression_OR_expression *palternation_expression_OR_expression)
{
	// not yet implemented
	assert(0);
	palternation_expression_OR_expression->m_expression1->accept(this);
	palternation_expression_OR_expression->m_expression2->accept(this);
}

void astgenvisitor2::visit_base_IDENT(const base_IDENT *pbase_IDENT)
{
	m_ident = *pbase_IDENT->m_IDENT;
}

void astgenvisitor2::visit_base_LPAREN_alternation_RPAREN(const base_LPAREN_alternation_RPAREN *pbase_LPAREN_alternation_RPAREN)
{
	// not yet implemented
	assert(0);
	pbase_LPAREN_alternation_RPAREN->m_alternation->accept(this);
}

void astgenvisitor2::visit_alternation_alternation_OR_expression(const alternation_alternation_OR_expression *palternation_alternation_OR_expression)
{
	// not yet implemented
	assert(0);
	palternation_alternation_OR_expression->m_alternation->accept(this);
	palternation_alternation_OR_expression->m_expression->accept(this);
}


