#ifndef AST_H_
#define AST_H_

#include <string>
#include <vector>
#include <memory>
#include "visitor.h"


class node
{
	public:
		virtual ~node() {}
		virtual void accept( visitor * ) const = 0;
};

class grammar : public node
{
	public:
		virtual ~grammar() {}
};

class production : public node
{
	public:
		virtual ~production() {}
};

class lhs : public node
{
	public:
		virtual ~lhs() {}
};

class expression : public node
{
	public:
		virtual ~expression() {}
};

class base : public node
{
	public:
		virtual ~base() {}
};

class alternation : public node
{
	public:
		virtual ~alternation() {}
};

class grammar_grammar_production : public grammar
{
	public:
		grammar_grammar_production( const grammar* pgrammar,
				const production* pproduction )
			: m_grammar( pgrammar )
			, m_production( pproduction )
			{}
		virtual ~grammar_grammar_production() {}
		
		void accept( visitor* v ) const
		{
			v->visit_grammar_grammar_production( this );
		}

		std::auto_ptr< const grammar > m_grammar;
		std::auto_ptr< const production > m_production;
};

class grammar_grammar_COMMENT : public grammar
{
	public:
		grammar_grammar_COMMENT( const grammar* pgrammar,
				const std::string* pCOMMENT )
			: m_grammar( pgrammar )
			, m_COMMENT( pCOMMENT )
			{}
		virtual ~grammar_grammar_COMMENT() {}

		void accept( visitor* v ) const
		{
			v->visit_grammar_grammar_COMMENT( this );
		}

		std::auto_ptr< const grammar > m_grammar;
		std::auto_ptr< const std::string > m_COMMENT;
};

class production_lhs_expressionListList_TERMINATOR : public production
{
	public:
		production_lhs_expressionListList_TERMINATOR( const lhs* plhs,
				const std::vector< std::vector< expression* >* >* pexpressionListList )
			: m_lhs( plhs )
			, m_expressionListList( pexpressionListList )
			{}
		virtual ~production_lhs_expressionListList_TERMINATOR() {}

		void accept( visitor* v ) const
		{
			v->visit_production_lhs_expressionListList_TERMINATOR( this );
		}

		std::auto_ptr< const lhs > m_lhs;
		std::auto_ptr< const std::vector< std::vector< expression* >* > >
			m_expressionListList;
};

class lhs_IDENT_SEPARATOR : public lhs
{
	public:
		lhs_IDENT_SEPARATOR( const std::string* pIDENT )
			: m_IDENT( pIDENT )
			{}
		virtual ~lhs_IDENT_SEPARATOR() {}

		void accept( visitor* v ) const
		{
			v->visit_lhs_IDENT_SEPARATOR( this );
		}

		std::auto_ptr< const std::string > m_IDENT;
};

class expression_base : public expression
{
	public:
		expression_base( const base* pbase )
			: m_base( pbase )
			{}
		virtual ~expression_base() {}

		void accept( visitor* v ) const
		{
			v->visit_expression_base( this );
		}

		std::auto_ptr< const base > m_base;
};

class expression_base_OPT : public expression
{
	public:
		expression_base_OPT( const base* pbase )
			: m_base( pbase )
			{}
		virtual ~expression_base_OPT() {}

		void accept( visitor* v ) const
		{
			v->visit_expression_base_OPT( this );
		}

		std::auto_ptr< const base > m_base;
};

class expression_base_STAR : public expression
{
	public:
		expression_base_STAR( const base* pbase )
			: m_base( pbase )
			{}
		virtual ~expression_base_STAR() {}

		void accept( visitor* v ) const
		{
			v->visit_expression_base_STAR( this );
		}

		std::auto_ptr< const base > m_base;
};

class expression_base_PLUS : public expression
{
	public:
		expression_base_PLUS( const base* pbase )
			: m_base( pbase )
			{}
		virtual ~expression_base_PLUS() {}

		void accept( visitor* v ) const
		{
			v->visit_expression_base_PLUS( this );
		}

		std::auto_ptr< const base > m_base;
};

class expression_COMMENT : public expression
{
	public:
		expression_COMMENT( const std::string* pCOMMENT )
			: m_COMMENT( pCOMMENT )
			{}
		virtual ~expression_COMMENT() {}

		void accept( visitor* v ) const
		{
			v->visit_expression_COMMENT( this );
		}

		std::auto_ptr< const std::string > m_COMMENT;
};


class base_LITERAL : public base
{
	public:
		base_LITERAL( const std::string* pLITERAL )
			: m_LITERAL( pLITERAL )
			{}
		virtual ~base_LITERAL() {}

		void accept( visitor* v ) const
		{
			v->visit_base_LITERAL( this );
		}

		std::auto_ptr< const std::string > m_LITERAL;
};

class base_IDENT : public base
{
	public:
		base_IDENT( const std::string* pIDENT )
			: m_IDENT( pIDENT )
			{}
		virtual ~base_IDENT() {}

		void accept( visitor* v ) const
		{
			v->visit_base_IDENT( this );
		}

		std::auto_ptr< const std::string > m_IDENT;
};

class base_LPAREN_expressionList_RPAREN : public base
{
	public:
		base_LPAREN_expressionList_RPAREN( const std::vector<expression*>*
				pexpressionList )
			: m_expressionList( pexpressionList )
			{}
		virtual ~base_LPAREN_expressionList_RPAREN() {}

		void accept( visitor* v ) const
		{
			v->visit_base_LPAREN_expressionList_RPAREN( this );
		}

		std::auto_ptr< const std::vector<expression*> > m_expressionList;
};

class base_LPAREN_alternation_RPAREN : public base
{
	public:
		base_LPAREN_alternation_RPAREN( const alternation* palternation )
			: m_alternation( palternation )
			{}
		virtual ~base_LPAREN_alternation_RPAREN() {}

		void accept( visitor* v ) const
		{
			v->visit_base_LPAREN_alternation_RPAREN( this );
		}

		std::auto_ptr< const alternation > m_alternation;
};


class alternation_expression_OR_expression : public alternation
{
	public:
		alternation_expression_OR_expression( const expression* pexpression1,
				const expression* pexpression2 )
			: m_expression1( pexpression1 )
			, m_expression2( pexpression2 )
			{}
		virtual ~alternation_expression_OR_expression() {}

		void accept( visitor* v ) const
		{
			v->visit_alternation_expression_OR_expression( this );
		}

		std::auto_ptr< const expression > m_expression1;
		std::auto_ptr< const expression > m_expression2;
};

class alternation_alternation_OR_expression : public alternation
{
	public:
		alternation_alternation_OR_expression( const alternation* palternation,
				const expression* pexpression )
			: m_alternation( palternation )
			, m_expression( pexpression )
			{}
		virtual ~alternation_alternation_OR_expression() {}

		void accept( visitor* v ) const
		{
			v->visit_alternation_alternation_OR_expression( this );
		}

		std::auto_ptr< const alternation > m_alternation;
		std::auto_ptr< const expression > m_expression;
};


#endif
