package guiexample;

import ccl.swing.MainJFrame;
import ccl.swing.RunnableAction;
import ccl.swing.SwingUtil;
import ccl.util.Util;
import java.awt.Event;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.KeyStroke;


/**
 *
 *
 * @author Chr. Clemens Lee
 * @version $Id: ApplicationWizard.java,v 1.6 2001/02/28 20:45:10 clemens Exp clemens $
 */
public class ViewController extends MainJFrame
                            implements ActionListener
{
    private static final String S_INI_CONTENT = "[Init]\n"
                                                + "Author=Chr. Clemens Lee\n"
                                                + "JavadocAuthor=Chr. Clemens Lee\n"
                                                + "ProjectSuffix=.xml\n";
    private static final String S_MF_NEW     = "&New";
    private static final String S_MF_OPEN    = "&Open...";
    private static final String S_MF_SAVE    = "&Save";
    private static final String S_MF_SAVE_AS = "Save &As...";

    private void _setTitle() {
	setTitle( "GuiExample" );
    }

    public void newFile() {
        if ( !_confirmClose() ) {
            return;
        }

        super.newFile();
    }

    public void open( String sFileName_ ) {
        // Last thing in this method should be invoking
        // the open super method.
        super.open( sFileName_ );
    }

    /**
     * Implement the logic to save your application project
     * data in this method.
     */
    public void save( String sProjectFileName_ ) {
    }

    public class NewAction extends RunnableAction {
        public NewAction() {
            super( "&New" );
        }

        public void run() {
            newFile();
        }
    }

    public class OpenAction extends RunnableAction {
        public OpenAction() {
            super( "&Open..." );
        }

        public void run() {
            open();
        }
    }

    private class SaveAction extends RunnableAction {
        public SaveAction() {
            super( "&Save" );
        }

        public void run() {
            save();
        }

        public KeyStroke getAccelerator() {
            return KeyStroke.getKeyStroke( KeyEvent.VK_S,
                                           Event.CTRL_MASK );
        }
    }

    private class SaveAsAction extends RunnableAction {
        public SaveAsAction() {
            super( "Save &As..." );
        }

        public void run() {
            saveAs();
        }
    }

    private void _setMenuBar() {
	Vector vMenus = new Vector();
	Vector vFileMenu = new Vector();
	Vector vHelpMenu = new Vector();

	vFileMenu.addElement( "File" );
	vFileMenu.addElement( new NewAction() );
	vFileMenu.addElement( new OpenAction() );
	vFileMenu.addElement( new SaveAction() );
	vFileMenu.addElement( new SaveAsAction() );
	vFileMenu.addElement( "E&xit" );

	vHelpMenu.addElement( "Help" );
	vHelpMenu.addElement( "&Contents..." );
	vHelpMenu.addElement( "-----" );
	vHelpMenu.addElement( "&About..." );

	vMenus.addElement( vFileMenu );
	vMenus.addElement( vHelpMenu );

	setMenuBar( vMenus );
    }

    public ViewController( String[] asArg_, String sRCSHeader_ ) {
        super( "GuiExample"
               , asArg_
               , sRCSHeader_
               , S_INI_CONTENT );

        if ( isExitSet() ) {
            return;
        }

        _setTitle();
        _setMenuBar();
        pack();
        SwingUtil.maximizeWindow( this );
        show();
        SwingUtilities.invokeLater( new Runnable() {
            public void run() {
                SwingUtil.maximizeWindow( ViewController.this );
                Util.sleep( 1 );
                SwingUtil.maximizeWindow( ViewController.this );
            }
        } );
    }
}
