/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.xml.test;

import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Util;
import ccl.xml.XMLUtil;
import java.io.File;
import javax.xml.transform.TransformerException;

/**
 * This class tests some of the features the ccl.xml.XMLUtil
 * class offers.
 *
 * @version $Id: XMLUtilTest.java,v 1.6 2003/10/18 07:53:28 clemens Exp clemens $
 * @author  Chr. Clemens Lee
 */
public class XMLUtilTest extends Test 
{
    /**
     * Tests method 'valueOf'.
     */
    public void testValueOf()
        throws Exception
    {
        String sXML = "<boo>\n  <foo>\n    <flop>blah</flop>\n  </foo>\n</boo>\n";
        try
        {
            String sResult = XMLUtil.getValueOf( sXML, "/boo/foo/flop" );
            Assert( sResult.equals( "blah" ) );
        }
        catch( NoClassDefFoundError classError )
        {
            Util.print( " No Xalan XSLT parser found, skipping test! " );
        }
    }

    /**
     * Tests that method 'getXML' does through an exception containing the file name,
     * when an exception inside of it happens.
     */
    public void testGetXMLException()
        throws Exception
    {
        // create temporary empty file
        File tempFile = File.createTempFile( "_xmltest", null );

        // parse file
        // catch exception
        // exception should contain file name
        String stylesheet = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n" +
               "<xsl:stylesheet\n" +
               "   version=\"1.0\"\n" +
               "   xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n" +
               "<xsl:output method=\"text\"/>\n" +
               "\n" +
               "<xsl:template match=\"/\"><xsl:value-of select=\"xpath\"/></xsl:template>\n" +
               "\n" +
               "</xsl:stylesheet>\n";
        //try
            //{
        String result = null;
        try
        {
            result = XMLUtil.getXML( "<xml></xml>", tempFile );
            Assert( false );
        }
        catch( TransformerException transformerException )
        {
            Assert( transformerException.getMessage().indexOf( "_xmltest" ) != -1
                    , transformerException.getMessage() );
        }
        try
        {
            result = XMLUtil.getXML( tempFile, tempFile );
            Assert( false );
        }
        catch( TransformerException transformerException )
        {
            Assert( transformerException.getMessage().indexOf( "_xmltest" ) != -1
                    , transformerException.getMessage() );
        }
        
        try
        {
            result = XMLUtil.getXML( tempFile, stylesheet );
            Assert( false );
        }
        catch( TransformerException transformerException )
        {
            Assert( transformerException.getMessage().indexOf( "_xmltest" ) != -1
                    , transformerException.getMessage() );
        }

        // remove temporary empty file
        FileUtil.delete( tempFile.getPath() );
    }

    /**
     * Default empty constructor.
     */
    public XMLUtilTest() 
    {
        super();
    }

    /**
     * Default standard constructor.
     */
    public XMLUtilTest( Test pTest_ ) 
    {
        super( pTest_ );
    }

    /**
     * Insert your test code into the _doIt() method and
     * test bugs with 'bugIf( boolean expression );' or
     * 'bugIf( boolean expression, "comment about what went wrong" );'.
     * Then just invoke the main routine.
     *
     * @exception   Exception   if anything goes wrong the test fails as well.
     */
    protected void _doIt()
        throws Exception
    {
        testGetXMLException();
        testValueOf        ();
    }

    /**
     * This is the static main method which can be used if
     * this test class should be executed stand alone.
     */
    public static void main( String[] asArg_ ) 
    {
        Test pTest = (Test)(new XMLUtilTest());
        pTest.setVerbose( true );
        pTest.run();
        Test.printResult( pTest );

        System.exit( 0 );
    }
}
