/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util.test;

import ccl.util.Init;
import ccl.util.Test;

/**
 * Collection of test cases (sub tests) for ccl.util package.
 * 
 * @version $Id: UtilPackageTest.java,v 1.1 2003/05/09 20:21:41 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class UtilPackageTest extends Test 
{
    private Init _init = null;

    /**
     * This is the default constructor.
     */
    public UtilPackageTest()
    {
        super();
    }

    /**
     * This constructor is needed for this test to be a
     * sub test.
     */
    public UtilPackageTest(Test pTest_) 
    {
        super(pTest_);
    }

    /**
     * Test execution starts here.
     *
     * @throws   Exception   Whatever can go wrong.
     */
    protected void _doIt() 
        throws Exception
    {
        _doSubTests();
    }

    /**
     * Collection of sub tests.
     */
    private void _doSubTests()
    {
        Test pOutErrTest = new OutputErrorStreamManagerTest( this );
        pOutErrTest.run();
        setTests( pOutErrTest );

        Test pTestTest = new TestTest( this );
        pTestTest.run();
        setTests( pTestTest );

        Test pSToLAndConcatTest = new SToLAndConcatTest( this );
        pSToLAndConcatTest.run();
        setTests( pSToLAndConcatTest );

        Test pFileUtilTest = new FileUtilTest( this );
        pFileUtilTest.run();
        setTests( pFileUtilTest );

        Test pInitTest = new InitTest( this );
        ((InitTest) pInitTest).setInit( _init );
        pInitTest.run();
        setTests( pInitTest );

        Test pIniFileTest = new IniFileTest( this );
        pIniFileTest.run();
        setTests( pIniFileTest );

        Test pClassPathUtilTest = new ClassPathUtilTest( this );
        pClassPathUtilTest.run();
        setTests( pClassPathUtilTest );

        Test sysEnvTest = new SysEnvTest( this );
        sysEnvTest.run();
        setTests( sysEnvTest );

        Test pSingletonTest = new SingletonTest( this );
        pSingletonTest.run();
        setTests( pSingletonTest );

        Test pUtilTest = new UtilTest( this );
        pUtilTest.run();
        setTests( pUtilTest );
    }

    /**
     * The InitTest uses the ccl init object itself. The
     * init object is forwarded from outer test to the
     * next test.
     */
    public void setInit( Init init_ ) 
    {
        _init = init_;
    }

    /**
     * The main method of this class in case you want to execute the tests of it
     * stand alone without the other test classes.
     *
     * @param   args   string array with command line arguments are totally unused.
     */
    public static void main(String[] args) 
    {
        Test pTest = (Test) (new UtilPackageTest());
        pTest.setVerbose( true );
        pTest.setTiming( true );
        pTest.run();
        pTest.printResult();

        System.exit( 0 );
    }
}
