/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util.test;

import ccl.util.FileUtil;
import ccl.util.SysEnv;
import ccl.util.Test;

/**
 * @version $Id: SysEnvTest.java,v 1.4 2003/05/01 16:44:53 clemens Exp clemens $
 * @author  Chr. Clemens Lee
 */
public class SysEnvTest extends Test 
{
    public SysEnvTest() 
    {
        super();
    }

    public SysEnvTest( Test pTest_ ) 
    {
        super( pTest_ );
    }

    protected void _doIt() 
    {
        String sLocalPath = FileUtil.getClassPath(this);
        
        String sTestPropertiesFile = FileUtil.concatPath
               ( sLocalPath, "test.properties" );
        String sTestPropertiesContent = "HOME=/home/clemens\nNOTHING=\nPP_DEV_HOME=Z:\\ZUR_PPOSITION_DEV\n";
        try 
        {
            FileUtil.writeFile( sTestPropertiesFile, sTestPropertiesContent );
            bugIf( false );
        }
        catch( Exception exception ) 
        {
            bugIf( true, "exception: " + exception );
        }

        SysEnv.initialize( sTestPropertiesFile );

        String sTest1 = "$(HOME)/bin";
        String sGoodResult1 = "/home/clemens/bin";
        String sResult1 = SysEnv.evalEnvVariable( sTest1 );
        bugIf ( !sGoodResult1.equals( sResult1 ),
                "sResult1: " + sResult1 );

        String sTest2 = "$(NOTHING)/bin";
        String sGoodResult2 = "/bin";
        String sResult2 = SysEnv.evalEnvVariable( sTest2 );
        bugIf ( !sGoodResult2.equals( sResult2 ),
                "sResult2: " + sResult2 );

        String sTest3 = "$(PP_DEV_HOME)";
        String sGoodResult3 = "Z:\\ZUR_PPOSITION_DEV";
        String sResult3 = SysEnv.evalEnvVariable( sTest3 );
        bugIf ( !sGoodResult3.equals( sResult3 ),
                "sResult3: " + sResult3 );


    }

    public static void main( String[] asArg_ ) 
    {
        Test pTest = (Test) (new SysEnvTest());
        pTest.printResult();

        System.exit( 0 );
    }
}
