/** @(#)StringMethods.java  1.09  2/25/96  Benjamin "Quincy" Cabell V (thethe@wpi.edu), Besiex Software.
 *
 * Copyright (c) 1996 Besiex Software. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that credit is this copyright notice
 * appears in all copies.
 *
 * Distributed under the terms of the GNU Library General Public License.
 *
 * FrIJDE Homepage:
 * http://amber.wpi.edu/~thethe/Document/Besiex/Java/FrIJDE/
 *
 * Edited and modified by Chr. Clemens Lee <clemens@kclee.com>,
 * 1999-07-27.
 */

package ccl.util;

/**
 * This class is copyrighted by 1996 Besiex Software (Benjarmin Cabell)
 * and distributed under the terms of the Gnu Library General Public License.
 *
 * This class reads Windows like .ini files and can set values
 * as well. The standard Java way is to use property files
 * instead, but if you have legacy code which uses ini files or
 * if you want to access for example a kde .kderc configuration
 * file, then this class is for you.
 *
 * @version $Id: IniFile.java,v 1.18 2002/05/20 12:09:44 clemens Exp clemens $
 * @author   Benjamin Cabell <thethe@wpi.edu<,
 *           Chr. Clemens Lee <clemens@kclee.com>
 */
public class IniFile
{
    /** Indicates that reading the ini file worked fine. */
    public static final int OK = 0;
    /** Reading the ini file resulted in an error. */
    public static final int FILE_ERROR = 1;
    /** Reading the ini file resulted in an error when parsing a section. */
    public static final int SECTION_ERROR = 2;
    /** Reading the ini file resulted in an error when parsing for a key. */
    public static final int KEY_ERROR = 3;

    private static int _status = OK;
    
    private static String _getSection(String sSectionName_,
                                      String sIniFileContent_)
    {
        _status = OK;
        String sIniContent = "\n" + sIniFileContent_;
        
        // Start of Section (without Section Name)
        int index = sIniContent.indexOf("\n[" + sSectionName_ + "]");
        if (index == -1) 
        {
            _status = SECTION_ERROR;
            return "";
        }
        index += 3 + sSectionName_.length();
        
        // Extract Section
        String sSectionContent = sIniFileContent_.substring(index);
        int indexOfFollowingSection = sSectionContent.indexOf("\n[") + 1;
        if (indexOfFollowingSection == 0) 
        {
            indexOfFollowingSection = sSectionContent.length();
        }
        sSectionContent = sSectionContent.substring(0, indexOfFollowingSection);
        
        return sSectionContent;
    }

    private static String _getKeyValue(String sKey_,
                                       String sSectionContent_)
    {
        String sSection = "\n" + sSectionContent_;
        
        // Start of Value
        int indexStart = sSection.indexOf("\n" + sKey_ + "=");
        if (indexStart == -1) 
        {
            _status = KEY_ERROR;
            return "";
        }
        indexStart += 2 + sKey_.length();
        String sValue = sSection.substring(indexStart);

        // End of Value
        int indexEnd = sValue.indexOf('\n');
        if (indexEnd == -1) 
        {
            indexEnd = sValue.length();
        }
        sValue = (sValue.substring(0, indexEnd)).trim();
        
        return sValue;
    }
    
    public static String getKeyValue(String sIniFullFileName_,
                                     String sSectionName_,
                                     String sKey_)
    {
        Util.debug( "ccl.util.IniFile.getKeyValue(..).sIniFullFileName_: " + sIniFullFileName_ );
        Util.debug( "ccl.util.IniFile.getKeyValue(..).sSectionName_:     " + sSectionName_     );
        Util.debug( "ccl.util.IniFile.getKeyValue(..).sKey_:             " + sKey_             );
        
        String sIniFileContent = "";
        
        _status = OK;
        
        // File
        try 
        {
            sIniFileContent = FileUtil.readFile(sIniFullFileName_);
        }
        catch(Exception e) 
        {
            Util.debug( "ccl.util.IniFile.getKeyValue(..).e: " + e );
            _status = FILE_ERROR;

            return "";
        }
        
        String sValue = getKeyValueFromString(sSectionName_,
                                              sKey_,
                                              sIniFileContent);
        
        return (sValue);
    }
    
    /**
     * Returns the value for the given key in the given 
     * section. First the lookup takes place in the normal
     * ini file, if there is no value found, a second
     * lookup in the default ini content takes place.
     *
     * @param   sIniFullFileName_  (The foolowing comment is outdated: is not used if sIniFullFileName_ is not 
     *                             equal null. Besides of that it's only
     *                             there to separate the method signature from 
     *                             getKeyValue(String,String,String)
     *                             - what a hack.)
     * @param   sIniFileContent_   (The foolowing comment is outdated: 
     *                             if null it's the same as getKeyValue(String,
     *                             String,String). Otherwise it workes straight
     *                             on this String.)
     */
    public static String getKeyValue( String sIniFullFileName_,
                                      String sSectionName_,
                                      String sKey_,
                                      String sIniFileContent_ )
    {
        _status = OK;

        if (sIniFileContent_ == null) 
        {
            return getKeyValue(sIniFullFileName_, sSectionName_, sKey_);
        }
        
        String sRetVal = getKeyValue( sIniFullFileName_
                                      , sSectionName_
                                      , sKey_ );
        if ( !Util.isEmpty( sRetVal ) 
             || sIniFileContent_ == null ) 
        {
            return sRetVal;
        }

        _status = OK;

        // we did not find anything in the file but got a 
        // default content string to look there
        
        // Section
        String sSectionContent = _getSection( sSectionName_,
                                              sIniFileContent_ );

        if ( _status != OK ) 
        {
            return "";
        }
        
        // Value
        String sValue = _getKeyValue( sKey_, sSectionContent );
        
        return( sValue );
    }
    
    /**
     * Returns the value for the given key in the given 
     * String.
     */
    public static String getKeyValueFromString( String sSectionName_,
                                                String sKey_,
                                                String sIniFileContent_ )
    {
        _status = OK;

        if (sIniFileContent_ == null) 
        {
            return "";
        }
        
        // Section
        String sSectionContent = _getSection( sSectionName_,
                                              sIniFileContent_ );

        if ( _status != OK ) 
        {
            return "";
        }
        
        // Value
        String sValue = _getKeyValue( sKey_, sSectionContent );
        
        return( sValue );
    }

    /**
     * Ini file status indicates any problems.
     */
    public static int getStatus() 
    {
        return _status;
    }
    
    public static void setKeyValue(String sIniFileName_, String sSection_,
                                   String sKey_, String sValue_)
    {
        String sIniFileContent = "";
        
        _status = OK;
        try 
        {
            sIniFileContent = FileUtil.readFile(sIniFileName_);
        }
        catch(Exception e) 
        {
            sIniFileContent = "[" + sSection_ + "]\n" + sKey_ + "=" + sValue_ + "\n";
        }
        
        String sCompleteSection = _getSection(sSection_, sIniFileContent);
        Util.debug("IniFile.setKeyValue(String, String, String, String).sCompleteSection: \n" +
                   sCompleteSection);
        int status = getStatus();
        Util.debug("IniFile.setKeyValue(String, String, String, String).status: " +
                   status);
        if (status == SECTION_ERROR) 
        {
            sCompleteSection = "\n[" + sSection_ + "]\n" + sKey_ + "=" + sValue_ + "\n";
            sIniFileContent += sCompleteSection;
            _status = OK;
        }
        if (sCompleteSection.equals("") || !sCompleteSection.startsWith("\n")) 
        {
            sCompleteSection = "\n" + sCompleteSection;
        }
        Util.debug("IniFile.setKeyValue(String, String, String, String).sIniFileContent: " +
                   sIniFileContent);
        int indexKeyStart = sCompleteSection.indexOf("\n" + sKey_ + "=") + 1;
        Util.debug("IniFile.setKeyValue(String, String, String, String).indexKeyStart, sKey_: " +
                   indexKeyStart + ", " + sKey_);
        Util.debug("IniFile.setKeyValue(String, String, String, String).sCompleteSection: \n" +
                   sCompleteSection);
        int indexKeyStop =  sCompleteSection.indexOf("\n", indexKeyStart) + 1;
        String sNewSection = null;
        if (indexKeyStart == 0 || indexKeyStop == -1) 
        {
            Util.debug("IniFile.setKeyValue(..): key does not exist!");
            // neuer Key
            sNewSection = "\n" + sKey_ + "=" + sValue_ + "\n" +
                   sCompleteSection.substring(1, sCompleteSection.length());
        }
        else 
        {
            sNewSection = sCompleteSection.substring(0, indexKeyStart) +
                   sKey_ + "=" + sValue_ + "\n" +
                   sCompleteSection.substring(indexKeyStop, sCompleteSection.length());
        }
        
        int indexSectionStart = sIniFileContent.indexOf(sCompleteSection);
        String sNewIniFileContent = sIniFileContent.substring(0, indexSectionStart) +
               sNewSection + sIniFileContent.substring(indexSectionStart +
                                                       sCompleteSection.length(),
                                                       sIniFileContent.length());
        
        try 
        {
            FileUtil.writeFile(sIniFileName_, sNewIniFileContent);
        }
        catch(Exception e) 
        {
            _status = FILE_ERROR;
            return;
        }
    }
}
