/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.util.*;

import javax.swing.*;

import ccl.util.*;

/**
 * Panel with memory information.
 *
 * @version  $Id: MemoryPanel.java,v 1.5 2002/10/06 16:41:45 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>>
 */
public class MemoryPanel extends JPanel
                         implements Runnable,
                                    ActionListener,
                                    ItemListener
{
    private JComboBox _jcbInterval = new JComboBox();
    private JButton _btnUpdate = new JButton("Update Now");
    private JButton _btnGC = new JButton("Collect Garbage");
    private JButton _btnOK = new JButton("OK");
    private JLabel _lblInUseMemory = new JLabel("000,000,000");
    private JLabel _lblTotalMemory = new JLabel("000,000,000");
    private JLabel _lblPercentage = new JLabel();
    private NumberFormat _pNumberFormat;
    private JProgressBar _pJProgressBar = null;
    private int _updateInterval = 2;
    private Thread _pThread;
    private boolean _bExit = false;

    private void _updateValues() 
    {
        Runtime pRuntime = Runtime.getRuntime();
        long lTotalMemory = pRuntime.totalMemory();
        long lInUseMemory  = lTotalMemory - pRuntime.freeMemory();
        _lblInUseMemory.setText(_pNumberFormat.format(lInUseMemory));
        _lblTotalMemory.setText(_pNumberFormat.format(lTotalMemory));
        int percentage = (int)(lInUseMemory * 1000 / lTotalMemory);
        String sPercentage = "(" + Util.itoa(percentage/10) + "." +
               Util.itoa(percentage % 10) + " %)";
        _lblPercentage.setText(sPercentage);
        _pJProgressBar.setValue(percentage);
        Util.debug("MemoryPanel._updateValues().percentage: " + percentage);
        Util.debug("MemoryPanel._updateValues()._pJProgressBar.getMinimum(): " + 
                   _pJProgressBar.getMinimum());
        Util.debug("MemoryPanel._updateValues()._pJProgressBar.getMaximum(): " + 
                   _pJProgressBar.getMaximum());
    }

    public MemoryPanel() 
    {
        super();

        AutoGridBagLayout agblMemory = new AutoGridBagLayout();
        agblMemory.setInsets(3);
        setLayout(agblMemory);

        _pJProgressBar = new JProgressBar();

        _pJProgressBar.setMinimum(0);
        _pJProgressBar.setMaximum(1000);

        // new line -------------------------------------------
        agblMemory.setAnchor(GridBagConstraints.WEST);
        add(new JLabel("Update every "));
        
        _pNumberFormat = DecimalFormat.getInstance(Locale.US);
        
        _jcbInterval.addItem("1");
        _jcbInterval.addItem("2");
        _jcbInterval.addItem("3");
        _jcbInterval.addItem("4");
        _jcbInterval.addItem("5");
        _jcbInterval.addItem("10");
        _jcbInterval.addItem("20");
        _jcbInterval.addItem("30");
        _jcbInterval.addItem("60");
        _jcbInterval.addItem("300  ");
        _jcbInterval.setSelectedIndex(1);
        _updateInterval = 2;
        _jcbInterval.addItemListener(this);

        agblMemory.setAnchor(GridBagConstraints.CENTER);
        add(_jcbInterval);
                
        agblMemory.setAnchor(GridBagConstraints.WEST);
        add(new JLabel(" seconds. "));
                
        _btnUpdate.addActionListener(this);
        agblMemory.setFillHorizontal();
        add(_btnUpdate);
        agblMemory.setFillNone();

        agblMemory.endLine();

        // new line -------------------------------------------
        add(new JLabel("Memory in use: "));
        
        _updateValues();

        agblMemory.setAnchor(GridBagConstraints.EAST);
        add(_lblInUseMemory);
                
        agblMemory.setAnchor(GridBagConstraints.WEST);
        add(new JLabel(" bytes"));

        add(_lblPercentage);

        agblMemory.endLine();

        // new line -------------------------------------------
        add(new JLabel("Total memory: "));
        
        agblMemory.setAnchor(GridBagConstraints.EAST);
        add(_lblTotalMemory);

        agblMemory.setAnchor(GridBagConstraints.WEST);
        add(new JLabel(" bytes"));

        _btnGC.addActionListener(this);
        add(_btnGC);

        agblMemory.endLine();

        // new line -------------------------------------------
        agblMemory.setExtend(4, 1);
        agblMemory.setFillHorizontal();
        agblMemory.setAnchor(GridBagConstraints.CENTER);
        add(_pJProgressBar);
        agblMemory.setFillNone();
        agblMemory.setExtend(1, 1);
        agblMemory.endLine();
    }

    public void setBackground( Color pColor_ ) 
    {
        super.setBackground( pColor_ );

        if ( _pJProgressBar != null ) 
        {
            _pJProgressBar.setBackground( pColor_ );
        }
    }

    public void actionPerformed(ActionEvent pActionEvent_) 
    {
        Object oSource = pActionEvent_.getSource();
        if (oSource == _btnUpdate) 
        {
            _pThread.interrupt();
        }
        else if (oSource == _btnGC) 
        {
            Runtime.getRuntime().gc();
            _pThread.interrupt();
        }
    }
    
    public void itemStateChanged(ItemEvent pItemEvent_) 
    {
        _updateInterval = Util.atoi(_jcbInterval.getSelectedItem().toString());
        _pThread.interrupt();
    }
    
    public void run() 
    {
        while(_pThread != null) 
        {
            if (_bExit) 
            {
                _pThread = null;
                break;
            }
            
            _updateValues();
            repaint();
            
            try 
            {
                _pThread.sleep(_updateInterval * 1000);
            }
            catch (InterruptedException e) 
            {
            }
        }
    }
    
    public void start() 
    {
        _pThread = new Thread( this );
        _pThread.start();
    }

    public void stop() 
    {
        _bExit = true;
        if ( _pThread != null ) 
        {
            _pThread.interrupt();
        }
    }
}
