/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.ExitJDialog;
import ccl.swing.SwingUtil;
import ccl.util.SysEnv;
import ccl.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.*;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * Appropriate for selecting CLASSPATH's for example.
 *
 * @version  $Id: ListEditDialog.java,v 1.10 2003/05/09 20:21:34 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>>
 */
public class ListEditDialog extends ExitJDialog
                            implements ActionListener,
                                       DocumentListener,
                                       ListSelectionListener
{
    private static final int WIDTH = 300;
    private static final int HEIGHT = 400;
    private static final Insets INSETS = new Insets(24, 4, 5, 4);
    private JButton _btnBrowse = new JButton( "Browse...");
    private JButton _btnAdd = new JButton("Add");
    private JButton _btnChange = new JButton("Change");
    private JButton _btnDelete = new JButton("Delete");
    private JButton _btnUp = new JButton("Up");
    private JButton _btnDown = new JButton("Down");
    private JButton _btnOK = new JButton("OK");
    private JButton _btnCancel = new JButton("Cancel");
    private JList _lstItems = null;
    private JTextField _txtItem = new JTextField();
    private Vector _vOrigListItems = null;
    private Vector _vListItems = null;
    private boolean _bEnabled = false;
    private Frame _frmParent = null;

    private void _setFont(Component pComponent_) 
    {
        pComponent_.setFont(new Font("Dialog", Font.BOLD, 12));
        pComponent_.setForeground( Color.black );
    }

    private void _addButton( AutoGridBagLayout agblLayout_,
                             JPanel pnlBackground_,
                             JButton pButton_ )
    {
        agblLayout_.setExpandNone();
        _setFont( pButton_ );
        pButton_.setEnabled( false );
        pButton_.addActionListener( this );
        pnlBackground_.add( pButton_ );
    }

    public ListEditDialog(Frame frmParent_, String sTitle_,
                          Vector vListItems_)
    {
        this( frmParent_, sTitle_, vListItems_, false );
    }
    
    public ListEditDialog(Frame frmParent_, 
                          String sTitle_,
                          Vector vListItems_,
                          boolean bAddFileAndDirBrowsing_ )
    {
        super(frmParent_, sTitle_);

        _frmParent = frmParent_;

        JPanel pnlBackground = (JPanel)getContentPane();
        /*pnlBackground.setBackground( frmParent_.getBackground() );*/

        Util.panicIf(vListItems_ == null);
        _vOrigListItems = (Vector)vListItems_.clone();
        _vListItems = (Vector)vListItems_.clone();

        DefaultListModel dlmItems = new DefaultListModel();
        _lstItems = new JList( dlmItems );
        for(Enumeration e = _vListItems.elements(); e.hasMoreElements(); ) 
        {
            dlmItems.addElement( (String)e.nextElement() );
        }

        AutoGridBagLayout agblLayout = new AutoGridBagLayout();
        pnlBackground.setLayout(agblLayout);

        Util.debug("ListEditDialog: <init>: insets: " + getInsets());

        agblLayout.setFillHorizontal();
        agblLayout.setExpandHorizontal();
        JLabel lblNew = new JLabel("New Item:");
        _setFont(lblNew);
        pnlBackground.add(lblNew);

        agblLayout.endLine();
        _txtItem.getDocument().addDocumentListener(this);
        _txtItem.setBorder( SwingUtil.createCCLBorder() );
        pnlBackground.add(_txtItem);

        // add browse feature
        if ( bAddFileAndDirBrowsing_ ) 
        {
            agblLayout.setExpandNone();
            _setFont( _btnBrowse );
            _btnBrowse.addActionListener(this);
            pnlBackground.add( _btnBrowse );
        }
        else 
        {
            _addButton( agblLayout, pnlBackground, _btnAdd );
        }

        agblLayout.endLine();
        agblLayout.setExpandHorizontal();
        JLabel lblCurrent = new JLabel("Current Items:");
        _setFont(lblCurrent);
        pnlBackground.add(lblCurrent);

        if ( bAddFileAndDirBrowsing_ ) 
        {
            agblLayout.setExpandNone();
            pnlBackground.add( new JLabel( " " ) );
        }
        else 
        {
            _addButton( agblLayout, pnlBackground, _btnChange );
        }
        agblLayout.endLine();

        agblLayout.setFillBoth();
        agblLayout.setExpandBoth();
        int lines = 5;
        if ( bAddFileAndDirBrowsing_ ) 
        {
            lines += 2;
        }
        agblLayout.setExtend(1, lines);
        _lstItems.addListSelectionListener( this );
        JScrollPane scpList = new JScrollPane( _lstItems );
        scpList.setBorder( SwingUtil.createCCLBorder() );
        pnlBackground.add( scpList );
        agblLayout.setExtend(1, 1);

        if ( bAddFileAndDirBrowsing_ ) 
        {
            _addButton( agblLayout, pnlBackground, _btnAdd );
            agblLayout.nextLine();
            _addButton( agblLayout, pnlBackground, _btnChange );
            agblLayout.nextLine();
        }

        agblLayout.setAnchor(GridBagConstraints.NORTH);
        agblLayout.setFillHorizontal();
        agblLayout.setExpandNone();
        _setFont(_btnDelete);
        _btnDelete.setEnabled(false);
        _btnDelete.addActionListener(this);
        pnlBackground.add(_btnDelete);

        agblLayout.nextLine();
        agblLayout.setAnchor(GridBagConstraints.SOUTH);
        agblLayout.setExpandVertical();
        _setFont(_btnUp);
        _btnUp.setEnabled(false);
        _btnUp.addActionListener(this);
        pnlBackground.add(_btnUp);
        agblLayout.setAnchor(GridBagConstraints.CENTER);

        agblLayout.nextLine();
        agblLayout.setExpandNone();
        _setFont(_btnDown);
        _btnDown.addActionListener(this);
        _btnDown.setEnabled(false);
        pnlBackground.add(_btnDown);
        
        agblLayout.nextLine();
        agblLayout.setAnchor(GridBagConstraints.SOUTH);
        agblLayout.setExpandVertical(2.0);
        _setFont(_btnOK);
        _btnOK.addActionListener(this);
        pnlBackground.add(_btnOK);
        
        agblLayout.setAnchor(GridBagConstraints.CENTER);
        agblLayout.setExpandNone();
        agblLayout.nextLine();
        _setFont(_btnCancel);
        _btnCancel.addActionListener(this);
        pnlBackground.add(_btnCancel);
        
        setSize(WIDTH, HEIGHT);
        SwingUtil.centerComponent(this);        
    }

    public Insets getInsets() 
    {
        return INSETS;
    }

    public Vector getValue() 
    {
        if (!_bOK) 
        {
            return _vOrigListItems;
        }

        return _vListItems;
    }

    private boolean _bOK = false;

    public boolean isOK() 
    {
        return _bOK;
    }

    public void actionPerformed(ActionEvent pActionEvent_) 
    {
        Object oSource = pActionEvent_.getSource();
        DefaultListModel dlmItems = (DefaultListModel)_lstItems.getModel();

        // ok & cancel
        if (oSource == _btnCancel) 
        {
            setVisible(false);
        }
        if (oSource == _btnOK) 
        {
            _bOK = true;
            setVisible(false);
        }

        if ( oSource == _btnBrowse ) 
        {
            String sStartDir = _txtItem.getText().trim();
            sStartDir = SysEnv.evalEnvVariable( sStartDir );
            String sFile = SwingUtil.getFileOrDirName
                   ( _frmParent, "Select", sStartDir );
            if ( sFile != null ) 
            {
                _txtItem.setText( sFile );
            }
        }
        if (oSource == _btnAdd) 
        {
            String sNewItem = _txtItem.getText();
            _vListItems.addElement(sNewItem);
            dlmItems.addElement( sNewItem );
            int selectedIndex = _vListItems.size() - 1;
            _lstItems.setSelectedIndex( selectedIndex );
            _btnDelete.setEnabled(true);
            _btnChange.setEnabled(_bEnabled);
            _btnUp.setEnabled(selectedIndex != 0);
            _btnDown.setEnabled(false);
            _btnChange.setEnabled(false);
        }
        if (oSource == _btnChange) 
        {
            String sNewItem = _txtItem.getText();
            int selectedIndex = _lstItems.getSelectedIndex();
            Util.debug( "actionPerformed(..).selectedIndex: " + selectedIndex );
            Util.debug( "actionPerformed(..)._vListItems: " + _vListItems );
            _vListItems.setElementAt(sNewItem, selectedIndex);
            Util.debug( "actionPerformed(..)._vListItems: " + _vListItems );
            
            //_lstItems.replaceItem(sNewItem, selectedIndex);
            dlmItems.setElementAt( sNewItem, selectedIndex );
            /*_lstItems.remove( selectedIndex + 1 );*/
            
            _lstItems.setSelectedIndex(selectedIndex);
            _btnChange.setEnabled(false);
        }
        if (oSource == _btnDelete) 
        {
            int selectedIndex = _lstItems.getSelectedIndex();
            _vListItems.removeElementAt(selectedIndex);
            dlmItems.removeElementAt(selectedIndex);
            if (selectedIndex == _vListItems.size()) 
            {
                selectedIndex--;
            }
            if (0 <= selectedIndex) 
            {
                _lstItems.setSelectedIndex(selectedIndex);
                _btnDelete.setEnabled(true);
                _btnChange.setEnabled(_bEnabled);
                _btnUp.setEnabled(selectedIndex != 0);
                _btnDown.setEnabled(selectedIndex != _vListItems.size() - 1);
                _txtItem.setText((String)_vListItems.elementAt(selectedIndex));
            }
            else 
            {
                _btnDelete.setEnabled(false);
                _btnChange.setEnabled(false);
                _btnDown.setEnabled(false);
                _btnUp.setEnabled(false);
                _txtItem.setText("");
            }
        }
        if (oSource == _btnUp) 
        {
            int selectedIndex = _lstItems.getSelectedIndex();
            String sTemp = (String)_vListItems.elementAt(selectedIndex);
            _vListItems.removeElementAt(selectedIndex);
            _vListItems.insertElementAt(sTemp, selectedIndex - 1);
            dlmItems.removeElementAt(selectedIndex);
            dlmItems.insertElementAt(sTemp, selectedIndex - 1);
            _lstItems.setSelectedIndex(selectedIndex - 1);
            _btnUp.setEnabled(selectedIndex > 1);
            _btnDown.setEnabled(true);
        }
        if (oSource == _btnDown) 
        {
            int selectedIndex = _lstItems.getSelectedIndex();
            String sTemp = (String)_vListItems.elementAt(selectedIndex);
            _vListItems.removeElementAt(selectedIndex);
            _vListItems.insertElementAt(sTemp, selectedIndex + 1);
            dlmItems.removeElementAt(selectedIndex);
            dlmItems.insertElementAt(sTemp, selectedIndex + 1);
            _lstItems.setSelectedIndex(selectedIndex + 1);
            _btnUp.setEnabled(true);
            _btnDown.setEnabled(selectedIndex + 2 != _vListItems.size());
        }
    }
    

    // document listener

    public void changedUpdate( DocumentEvent pDocumentEvent_ ) 
    {
        if ( _txtItem.getText().trim().length() > 0 ) 
        {
            _bEnabled = true;
        }
        else 
        {
            _bEnabled = false;
        }
        _btnAdd.setEnabled( _bEnabled );
        _btnChange.setEnabled( _bEnabled && _btnDelete.isEnabled() &&
                               !_txtItem.getText().
                               equals( _lstItems.getSelectedValue().toString() ) );
    }

    public void insertUpdate( DocumentEvent pDocumentEvent_ ) 
    {
        changedUpdate( pDocumentEvent_ );
    }

    public void removeUpdate( DocumentEvent pDocumentEvent_ ) 
    {
        changedUpdate( pDocumentEvent_ );
    }

    public void valueChanged(ListSelectionEvent pListSelectionEvent_) 
    {
        int selectedIndex = _lstItems.getSelectedIndex();
        Util.panicIf(selectedIndex == -1);
        _btnDelete.setEnabled(true);
        _btnChange.setEnabled(_bEnabled);
        _btnUp.setEnabled(selectedIndex != 0);
        _btnDown.setEnabled(selectedIndex != _vListItems.size() - 1);
        _txtItem.setText((String)_vListItems.elementAt(selectedIndex));
    }
}
