/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2003
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.border.LineBorder;

/**
 * This class can not handle round corners, but it can handle lines
 * with a variety of thickness for each individual line.
 * When no insets where provided when constructing this object,
 * the parent classes behavior is used.
 * 
 * @author Chr. Clemens Lee
 * @version $Id: CCLLineBorder.java,v 1.1 2003/05/01 16:44:11 clemens Exp clemens $
 */
public class CCLLineBorder extends LineBorder {
    private Insets insets = null;
    
	/**
	 * @param color
	 */
	public CCLLineBorder(Color color) {
		super(color);
	}

	/**
	 * @param color
	 * @param thickness
	 */
	public CCLLineBorder(Color color, int thickness) {
		super(color, thickness);
	}

	/**
	 * @param color      color used for each line.
	 * @param insets_   insets describing the thickness for each individual line.
	 */
	public CCLLineBorder( Color color, Insets insets_ ) {
		super( color );
		insets = insets_;
	}
	
	
    /**
     * @see javax.swing.border.AbstractBorder#getBorderInsets(java.awt.Component, java.awt.Insets)
     */
    public Insets getBorderInsets(Component c, Insets insets_) 
    {
        if ( insets != null )
        {
            insets_.top = insets.top;
            insets_.left = insets.left;
            insets_.bottom = insets.bottom;
            insets_.right = insets.right;

            return insets_;
        }

        return super.getBorderInsets(c, insets_);
    }

    /**
     * @see javax.swing.border.Border#getBorderInsets(java.awt.Component)
     */
    public Insets getBorderInsets(Component c) 
    {
        if ( insets != null )
        {
            Insets retVal = new Insets( insets.top, insets.left, insets.bottom, insets.right );

            return retVal;
        }

        return super.getBorderInsets(c);
    }

    /**
     * @see javax.swing.border.Border#paintBorder(java.awt.Component, java.awt.Graphics, int, int, int, int)
     */
    public void paintBorder( Component c,
                             Graphics g,
                             int x,
                             int y,
                             int width,
                             int height ) 
    {
        if ( insets == null )
        {
            super.paintBorder(c, g, x, y, width, height);

            return;
        }

        Color color = getLineColor();
        g.setColor( color );

        // top
        g.fillRect( x, y, width, insets.top );
        // left
        g.fillRect( x, y, insets.left, height );
        // bottom
        g.fillRect( x, y + height - insets.bottom, width, insets.bottom);
        // right
        g.fillRect( x + width - insets.right, y, insets.right, height );
    }
}
