/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.servlet;

import ccl.util.Exitable;
import ccl.util.Init;
import ccl.util.Util;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * The debug server is a simple socket server
 * that prints each incoming request to standard
 * output as well as works as an echo server,
 * just like in the Java Tutorial example.
 * Its intended purposes is to quickly see
 * HTTP GET or POST requests to learn
 * and try something about this or other
 * network protocols.<p>
 * 
 * The user has to Ctrl-c to exit the process.
 *
 * The default port is 4444.
 * 
 * @author  Chr. Clemens Lee, clemens@kclee.com
 * @version $Id: DebugServer.java,v 1.6 2002/11/06 22:04:38 clemens Exp clemens $
 */
public class DebugServer implements Exitable
                                    , Runnable
{
    public static final int DEFAULT_PORT = 4444;

    /**
     * Specifies the legal command line options.
     */
    private static final String S_INI_FILE_CONTENT = "[Init]\n"
        + "Author=Chr. Clemens Lee\n"
        + "\n"
        + "[Help]\n"
        + "HelpUsage=\n"
        + "Options=\n";

    /**
     * Used by Exitable interface.
     */
    private boolean _bExit = false;

    /**
     * The Init object encapsulates all application initialization data.     */
    private Init _init = null;

    /**
     * Implements 'ccl.util.Exitable' interface.
     */
    public void setExit()
    {
        _bExit = true;
    }

    /**
     * Create this object and invoke the run method
     * if you want to start the server out of another object.
     */
    public DebugServer()
    {
        super();
    }

    /**
     * This method is invoked to setup the application.
     */
    public void initialize( String[] asArg, String sRCSHeader )
    {
        _init = new Init( this
                          , asArg
                          , sRCSHeader
                          , S_INI_FILE_CONTENT );
    }

    /**
     * This method contains the main batch logic.
     * Be careful to expect system exits if anything
     * goes wrong. Also, this method will never finish
     * by itself if no exception happens.
     */
    public void run()
    {
        ServerSocket serverSocket = null;

        try 
        {
            serverSocket = new ServerSocket( DEFAULT_PORT );
        } 
        catch ( IOException ioException ) 
        {
            Util.printlnErr( "Could not listen on port: " + DEFAULT_PORT + "." );

            // not very clean to exit here
            System.exit(1);
        }

        Util.println( "DebugServer started. Waiting for clients to connect on port " + DEFAULT_PORT + " ...\n" );

        while( true )
        {
            //
            // our client
            //

            Socket clientSocket = null;
            try 
            {
                clientSocket = serverSocket.accept();
            }
            catch (IOException e) 
            {
                Util.printlnErr("Accept failed.");

                // again not very clean to exit here
                System.exit(1);
            }
            
            Util.println( "New connection ...\n" );

            try
            {
                PrintWriter    out = new PrintWriter(clientSocket.getOutputStream(), true);
                BufferedReader in  = new BufferedReader
                       ( new InputStreamReader
                         ( clientSocket.getInputStream() ) );
                String inputLine  = "";
                String outputLine = "";
                
                while ((inputLine = in.readLine()) != null) 
                {
                    Util.println( inputLine );
                    out.println( inputLine );
                }

                out.close();
                in.close();
                clientSocket.close();
            }
            catch( IOException ioException )
            {
                Util.printlnErr( ioException );
            }

            Util.println( "\nClient connection closed, waiting for new connection ...\n" );
        }

        // this can never happen, so why close. I know, not very nice.
        // serverSocket.close();
    }

    public static void main( String[] asArg ) 
    {
        DebugServer debugServer = new DebugServer();
        debugServer.initialize( asArg, "$Header: /home/clemens/src/java/ccl/src/ccl/servlet/RCS/DebugServer.java,v 1.6 2002/11/06 22:04:38 clemens Exp clemens $" );
        if ( debugServer._bExit ) 
        {
            System.exit( 1 );
        }

        debugServer.run();

        // if run failed it did already exit

        System.exit( 0 );
    }
}
