//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;
import lti.java.jcf.RuntimeConstants;       

/** A generic member descriptor (field or method). Can contain attributes */
public class JcfMember implements RuntimeConstants
{
  public short mbrAccessFlags;
  public short mbrNameIndex;
  public short mbrSignatureIndex;
  protected JcfAttributeCollection mbrAttributes;
    public final JcfAttributeCollection getAttributes() { return mbrAttributes; }
  protected JcfConstantPool constPool;
    public final JcfConstantPool getConstPool() { return constPool; }

  /** Reads header information, then creates and reads a new attribute collection. */
  JcfMember (JcfClassInput ist, JcfConstantPool p)
    throws IOException, ClassFormatError
  {
    constPool = p;
    mbrAccessFlags = ist.readShortVerbatim();
    mbrNameIndex = ist.readCPRef();
    mbrSignatureIndex = ist.readCPRef();
    mbrAttributes = constPool.getClassFile().readAttributes(ist);
  }
  
  public void write (JcfClassOutput ost) throws IOException
  {
    ost.writeShortVerbatim (mbrAccessFlags);
    ost.writeCPRef (mbrNameIndex);
    ost.writeCPRef (mbrSignatureIndex);
    mbrAttributes.write(ost);
  }
}
