/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * Base clase to create collection of constant objects.
 *
 * @version  $Id: Enum.java,v 1.7 2002/10/06 16:42:00 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class Enum 
{
    private static Hashtable _htEnums = new Hashtable();
    
    private int _value;
    private String _sName;

    protected Enum(String sElementName_) 
    {
        super();
        Vector vEnums = (Vector) _htEnums.get( getClass().getName() );
        if ( vEnums == null ) 
        {
            vEnums = new Vector();
            _htEnums.put( this.getClass().getName(), vEnums );
        }
           
        _sName = sElementName_;
        _value = vEnums.size();
        vEnums.addElement(this);
    }
    
    public static Enum get( Enum pEnum_, int element_ ) 
    {
        Util.panicIf( pEnum_ == null );

        Vector vEnums = (Vector) _htEnums.get( pEnum_.getClass().getName() );
        Util.panicIf( vEnums == null );

        Util.panicIf(element_ >= vEnums.size() );
        
        return (Enum) vEnums.elementAt( element_ );
    }
    
    public static Enum get( Enum pEnum_, 
                            String sElementName_ ) 
    {
        Util.panicIf( pEnum_ == null );

        Vector vEnums = (Vector) _htEnums.get( pEnum_.getClass().getName() );
        Util.panicIf( vEnums == null );

        for( Enumeration e = vEnums.elements(); e.hasMoreElements(); ) 
        {
            Enum enumNext = (Enum) e.nextElement();
            if ( enumNext._sName.equals( sElementName_ ) ) 
            {
                return enumNext;
            }
        }
        
        return (Enum) null;
    }
    
    public String toString() 
    {
        return _sName;
    }
    
    public int intValue() 
    {
        return _value;
    }
    
    public static int size( Enum pEnum_ ) 
    {
        Util.panicIf( pEnum_ == null );

        Vector vEnums = (Vector) _htEnums.get( pEnum_.getClass().getName() );
        Util.panicIf( vEnums == null );

        return vEnums.size();
    }

    public static Enumeration elements( final Enum pEnum_ ) 
    {
        Util.panicIf( pEnum_ == null );

        final Vector vEnums = (Vector) _htEnums.get
               ( pEnum_.getClass().getName() );
        Util.panicIf( vEnums == null );

        Enumeration pEnumeration = new Enumeration() 
            {
                private int index = 0;
            
                public boolean hasMoreElements() 
                {
                    return( index < vEnums.size() );
                }
            
                public Object nextElement() 
                {
                    index++;
                    return get( pEnum_, index - 1);
                }
            };
        
        return( pEnumeration );
    }
    
    /*public boolean equals(Enum pEnum_) {
      if (pEnum_ == null) {
      return false;
      }
      if (!(getClass().getName().equals(pEnum_.getClass().getName()))) {
      return false;
      }
      return pEnum_.toString().equals(_sName);
      }*/
}
