/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.util.Util;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class YesNoCancelDialog extends ExitJDialog
                               implements ActionListener
{
    private boolean _bYes = false;
    private boolean _bCancel = false;

    private JButton _btnYes;
    private JButton _btnNo;
    private JButton _btnCancel;
    
    public YesNoCancelDialog(Frame frmParent_) 
{
        this(frmParent_, "Some data have changed. Do you want to save them?");
    }
    
    public YesNoCancelDialog(Frame frmParent_, String sMessages_) 
{
        super(frmParent_, "Dialog", true);
        
        setBackground(frmParent_.getBackground());
        setForeground(frmParent_.getForeground());
        
        AutoGridBagLayout pAutoGridBagLayout = new AutoGridBagLayout();
        getContentPane().setLayout(pAutoGridBagLayout);
        ((JPanel)getContentPane()).setBorder
               ( BorderFactory.createEmptyBorder( 20, 10, 10, 10 ) );

        Vector vMessages = Util.stringToLines(sMessages_);
        
        // Dummy Line
        getContentPane().add(new JLabel(" "));
        pAutoGridBagLayout.endLine();
        
        // Messages
        pAutoGridBagLayout.setAnchor( AutoGridBagLayout.WEST);
        int maxLength = 0;
        for(Enumeration e = vMessages.elements(); e.hasMoreElements(); ) 
{
            // Message
            String sLine = (String)e.nextElement();
            JLabel lblLine = new JLabel(sLine, JLabel.LEFT);
            pAutoGridBagLayout.setExtend(4, 1);
            getContentPane().add(lblLine);
            pAutoGridBagLayout.setExtend(1, 1);
            if (lblLine.getSize().width > maxLength) 
{
                maxLength = lblLine.getSize().width;
            }
            pAutoGridBagLayout.endLine();
        }
        pAutoGridBagLayout.setAnchor( AutoGridBagLayout.CENTER);
        
        // Dummy Line
        getContentPane().add(new JLabel(" "));
        pAutoGridBagLayout.endLine();
        
        // Buttons
        _btnYes = new JButton("Yes");
        _btnYes.addActionListener(this);
        _btnYes.setFont(new Font("Dialog",Font.BOLD,12));
        getContentPane().add(_btnYes);
        _btnNo = new JButton("No");
        _btnNo.addActionListener(this);
        _btnNo.setFont(new Font("Dialog",Font.BOLD,12));
        getContentPane().add(_btnNo);
        pAutoGridBagLayout.setFillHorizontal();
        getContentPane().add(new JLabel(" "));
        pAutoGridBagLayout.setFillNone();
        _btnCancel = new JButton("Cancel");
        _btnCancel.addActionListener(this);
        _btnCancel.setFont(new Font("Dialog",Font.BOLD,12));
        pAutoGridBagLayout.setAnchor( AutoGridBagLayout.EAST);
        getContentPane().add(_btnCancel);
        pAutoGridBagLayout.setAnchor( AutoGridBagLayout.CENTER);
        pAutoGridBagLayout.endLine();
        
        // Dummy Line
        getContentPane().add(new JLabel(" "));
        pAutoGridBagLayout.endLine();
        
        /*Dimension dimSize = new Dimension();
        dimSize.height = _btnYes.getMinimumSize().height * (6 + vMessages.size());
        dimSize.width = Util.max(maxLength, 4 * 75) + 80;
        Util.debug("YesNoCancelDialog: <init> dimSize: " + dimSize);
        Dimension dimMax = SwingUtil.getScreenSize();
        Util.panicIf(dimSize.width > dimMax.width, "YesNoCancelDialog: Message passt nicht auf Screen.");*/
        
        setSize( getPreferredSize() );
        SwingUtil.centerComponent(this);
        show();
    }

    public void exit() 
{
        _bCancel = true;
        setVisible(false);
    }

    public void actionPerformed(ActionEvent pActionEvent_) 
{
        Object oSource = pActionEvent_.getSource();
        if (oSource == _btnCancel) 
{
            this.exit();
        }
        if (oSource == _btnYes) 
        {
            _bYes = true;
            setVisible(false);
        }
        if (oSource == _btnNo) 
{
            setVisible(false);
        }
    }

    public boolean isCancel() 
{
        return _bCancel;
    }

    public boolean isYes() 
{
        return _bYes;
    }
}
