/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is taken from a news group and added to 
 * the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is Marcel Nijman.
 * Portions created by Marcel Nijman are Copyright (C) 1999
 * Marcel Nijman. All Rights Reserved.
 * Portions created by Chr. Clemens Lee are Copyright (C) 1999,
 * 2000,2001,2002 Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Marcel Nijman <marcel@mbfys.kun.nl>
 *                 Maintained by Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 */

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JSplitPane;

/**
 * This class provides a workaround for a bug in the 
 * JSplitPane.setDividerLocation( double ) method.
 *
 * @author  Marcel Nijman, Chr. Clemens Lee
 * @version $Id: SplitPane.java,v 1.6 2003/05/01 16:44:27 clemens Exp clemens $
 */
public class SplitPane extends JSplitPane 
{
    private boolean _bPainted = false;
    private boolean _bProportionalLocation = false;
    private double  _dProportionalLocation = 0.5d;

    /**
     * Creates a new <code>JSplitPane</code> configured to arrange the child
     * components side-by-side horizontally with no continuous 
     * layout, using two buttons for the components.
     */
    public SplitPane() 
    {
        super();
    }

    /**
     * Creates a new <code>JSplitPane</code> configured with the
     * specified orientation and no continuous layout.
     *
     * @param newOrientation  <code>JSplitPane.HORIZONTAL_SPLIT</code> or
     *                        <code>JSplitPane.VERTICAL_SPLIT</code>
     * @exception IllegalArgumentException if <code>orientation</code>
     *		is not one of HORIZONTAL_SPLIT or VERTICAL_SPLIT.
     */
    public SplitPane(int newOrientation) 
    {
        super(newOrientation);
    }

    /**
     * Creates a new <code>JSplitPane</code> with the specified
     * orientation and
     * with the specified components that do not do continuous
     * redrawing.
     *
     * @param newOrientation  <code>JSplitPane.HORIZONTAL_SPLIT</code> or
     *                        <code>JSplitPane.VERTICAL_SPLIT</code>
     * @param newLeftComponent the <code>Component</code> that will
     *		appear on the left
     *        	of a horizontally-split pane, or at the top of a
     *        	vertically-split pane
     * @param newRightComponent the <code>Component</code> that will
     *		appear on the right
     *        	of a horizontally-split pane, or at the bottom of a
     *        	vertically-split pane
     * @exception IllegalArgumentException if <code>orientation</code>
     *		is not one of: HORIZONTAL_SPLIT or VERTICAL_SPLIT
     */
    public SplitPane(int newOrientation,
                     Component newLeftComponent,
                     Component newRightComponent)
    {
        super(newOrientation, newLeftComponent, newRightComponent);
    }
    
    /**
     * Creates a new <code>JSplitPane</code> with the specified
     * orientation and redrawing style.
     *
     * @param newOrientation  <code>JSplitPane.HORIZONTAL_SPLIT</code> or
     *                        <code>JSplitPane.VERTICAL_SPLIT</code>
     * @param newContinuousLayout  a boolean, true for the components to 
     *        redraw continuously as the divider changes position, false
     *        to wait until the divider position stops changing to redraw
     * @exception IllegalArgumentException if <code>orientation</code>
     *		is not one of HORIZONTAL_SPLIT or VERTICAL_SPLIT
     */
    public SplitPane(int newOrientation,
                     boolean newContinuousLayout)
    {
        super(newOrientation, newContinuousLayout);
    }
    
    /**
     * Creates a new <code>JSplitPane</code> with the specified
     * orientation and
     * redrawing style, and with the specified components.
     *
     * @param newOrientation  <code>JSplitPane.HORIZONTAL_SPLIT</code> or
     *                        <code>JSplitPane.VERTICAL_SPLIT</code>
     * @param newContinuousLayout  a boolean, true for the components to 
     *        redraw continuously as the divider changes position, false
     *        to wait until the divider position stops changing to redraw
     * @param newLeftComponent the <code>Component</code> that will
     *		appear on the left
     *        	of a horizontally-split pane, or at the top of a
     *        	vertically-split pane
     * @param newRightComponent the <code>Component</code> that will
     *		appear on the right
     *        	of a horizontally-split pane, or at the bottom of a
     *        	vertically-split pane
     * @exception IllegalArgumentException if <code>orientation</code>
     *		is not one of HORIZONTAL_SPLIT or VERTICAL_SPLIT
     */
    public SplitPane(int newOrientation,
                     boolean newContinuousLayout,
                     Component newLeftComponent,
                     Component newRightComponent)
    {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
    }

    /**
     * Sets the divider location as a percentage of the
     * <code>JSplitPane</code>'s size.
     * <p>
     * This method is implemented in terms of
     * <code>setDividerLocation(int)</code>.
     * This method immediately changes the size of the split pane based on
     * its current size. If the split pane is not correctly realized and on
     * screen, this method will have no effect (new divider location will
     * become (current size * proportionalLocation) which is 0).
     *
     * @param dLocation_ a double-precision floating point value
     *        that specifies a percentage, from zero (top/left) to 1.0
     *        (bottom/right)
     * @exception IllegalArgumentException if the specified location is < 0
     *            or > 1.0
     * @beaninfo
     *  description: The location of the divider.
     */
    public void setDividerLocation( double dLocation_ ) 
    {
        if ( !_bPainted ) 
        {
            _bProportionalLocation = true;
            _dProportionalLocation = dLocation_;
        }
        else 
        {
            super.setDividerLocation( dLocation_ );
        }
    }

    /**
     * Sets the location of the divider. This is passed off to the 
     * look and feel implementation, and then listeners are notified. A value
     * less than 0 implies the divider should be reset to a value that
     * attempts to honor the preferred size of the left/top component.
     * After notifying the listeners, the last divider location is updated,
     * via <code>setLastDividerLocation</code>.
     *
     * @param location_ an int specifying a UI-specific value (typically a 
     *        pixel count)
     * @beaninfo
     *        bound: true
     *  description: The location of the divider.
     */
    public void setDividerLocation( int location_ ) 
    {
        _bProportionalLocation = false;

        super.setDividerLocation( location_ );
    }

    public void paint( Graphics graphics_ ) 
    {
        if ( !_bPainted ) 
        {
            _bPainted = true;
            setDividerLocation( _dProportionalLocation );
        }

        super.paint( graphics_ );
    }
}
